/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.backend.dex.AnnotationBuilder;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.rop.annotation.Annotations;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.Collection;
import javax.annotation.Nonnull;

@Description(value="Builds the rop annotations of a field")
@Synchronized
@Constraint(need={ClassDefItemMarker.class, ClassDefItemMarker.Field.class})
@Transform(add={ClassDefItemMarker.FieldAnnotation.class}, modify={ClassDefItemMarker.class})
@Use(value={AnnotationBuilder.class})
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(no={JAnnotation.RepeatedAnnotation.class})})})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class FieldAnnotationBuilder
implements RunnableSchedulable<JField> {
    @Override
    public synchronized void run(@Nonnull JField field) {
        Annotations ropAnnotations;
        JDefinedClassOrInterface declaringClass = field.getEnclosingType();
        Collection<JAnnotation> annotations = field.getAnnotations();
        if (!annotations.isEmpty() && (ropAnnotations = new AnnotationBuilder().createAnnotations(annotations)).size() > 0) {
            ClassDefItemMarker classDefItemMarker = declaringClass.getMarker(ClassDefItemMarker.class);
            assert (classDefItemMarker != null);
            ClassDefItem classDefItem = classDefItemMarker.getClassDefItem();
            classDefItem.addFieldAnnotations(RopHelper.createFieldRef(field, (JClassOrInterface)field.getEnclosingType()), ropAnnotations);
        }
    }
}

