/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.api.v01.impl;

import com.android.jack.CommandLine;
import com.android.jack.IllegalOptionsException;
import com.android.jack.Options;
import com.android.jack.api.v01.Cli01CompilationTask;
import com.android.jack.api.v01.impl.Cli01ConfigImpl;
import com.android.sched.util.log.LoggerFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

class Cli01CompilationTaskImpl
extends CommandLine
implements Cli01CompilationTask {
    @Nonnull
    private final PrintStream standardError;
    @Nonnull
    private final PrintStream standardOutput;
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Options options;
    private final String[] args;

    public Cli01CompilationTaskImpl(@Nonnull Cli01ConfigImpl config, @Nonnull Options options, @Nonnull String[] args) {
        this.options = options;
        this.standardError = config.getStandardError();
        this.standardOutput = config.getStandardOutput();
        this.args = args;
    }

    @Override
    public int run() {
        if (this.args.length == 0) {
            this.standardError.println("Try --help for help.");
            return 0;
        }
        if (this.options.askForHelp()) {
            Cli01CompilationTaskImpl.printUsage(this.standardOutput);
            return 0;
        }
        if (this.options.askForPropertiesHelp()) {
            try {
                Cli01CompilationTaskImpl.printHelpProperties(this.standardOutput, this.options);
                return 0;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return 1;
            }
            catch (IllegalOptionsException e) {
                this.standardError.println(e.getMessage());
                return 2;
            }
        }
        if (this.options.askForVersion()) {
            try {
                Cli01CompilationTaskImpl.printVersion(this.standardOutput, this.options);
                return 0;
            }
            catch (IllegalOptionsException e) {
                this.standardError.println(e.getMessage());
                return 2;
            }
        }
        if (this.options.askForPluginsList()) {
            try {
                Cli01CompilationTaskImpl.printPluginsList(this.standardOutput, this.options);
                return 0;
            }
            catch (IllegalOptionsException e) {
                this.standardError.println(e.getMessage());
                return 2;
            }
        }
        return Cli01CompilationTaskImpl.runJack(this.standardError, this.options);
    }
}

