/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.api.impl;

import com.android.jack.Jack;
import com.android.jack.api.ConfigNotSupportedAnymoreException;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.JackConfig;
import com.android.jack.api.JackProvider;
import com.android.jack.api.ResourceController;
import com.android.jack.api.UnknownConfigException;
import com.android.jack.api.impl.ApiFeature;
import com.android.jack.api.impl.JackConfigImpl;
import com.android.jack.api.v01.Api01Config;
import com.android.jack.api.v01.Cli01Config;
import com.android.jack.api.v01.impl.Api01Feature;
import com.android.jack.api.v01.impl.Cli01ConfigImpl;
import com.android.jack.api.v02.Api02Config;
import com.android.jack.api.v02.impl.Api02Feature;
import com.android.jack.api.v03.Api03Config;
import com.android.jack.api.v03.impl.Api03Feature;
import com.android.jack.api.v04.Api04Config;
import com.android.jack.api.v04.impl.Api04ConfigImpl;
import com.android.jack.api.v04.impl.Api04Feature;
import com.android.jack.management.CleanCodeRequest;
import com.android.jack.management.CleanDiskRequest;
import com.android.jack.management.CleanMemoryRequest;
import com.android.jack.management.Impact;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JackProviderImpl
implements JackProvider,
ResourceController {
    @Nonnull
    private static final Map<Class<? extends JackConfig>, Class<? extends JackConfigImpl>> impl = new HashMap<Class<? extends JackConfig>, Class<? extends JackConfigImpl>>();
    @Nonnull
    private static final Map<Class<? extends JackConfig>, Class<? extends ApiFeature>> features = new HashMap<Class<? extends JackConfig>, Class<? extends ApiFeature>>();

    @Override
    public <T extends JackConfig> T createConfig(Class<T> cls) throws ConfigNotSupportedException {
        if (!impl.containsKey(cls)) {
            throw new UnknownConfigException(cls.getName() + " is not supported");
        }
        Class<? extends JackConfigImpl> clsImpl = impl.get(cls);
        if (clsImpl == null) {
            throw new ConfigNotSupportedAnymoreException(cls.getName() + " is not supported anymore");
        }
        try {
            JackConfigImpl config = clsImpl.newInstance();
            assert (features.containsKey(cls));
            config.setApi(features.get(cls));
            return (T)config;
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Collection<Class<? extends JackConfig>> getSupportedConfigs() {
        return impl.keySet();
    }

    @Override
    @Nonnull
    public <T extends JackConfig> boolean isConfigSupported(@Nonnull Class<T> cls) {
        return impl.containsKey(cls);
    }

    @Override
    @Nonnull
    public String getCompilerReleaseName() {
        return Jack.getVersion().getReleaseName();
    }

    @Override
    @Nonnegative
    public int getCompilerReleaseCode() {
        return Jack.getVersion().getReleaseCode();
    }

    @Override
    @Nonnegative
    public int getCompilerSubReleaseCode() {
        return Jack.getVersion().getSubReleaseCode();
    }

    @Override
    @Nonnull
    public JackProvider.SubReleaseKind getCompilerSubReleaseKind() {
        switch (Jack.getVersion().getSubReleaseKind()) {
            case ENGINEERING: {
                return JackProvider.SubReleaseKind.ENGINEERING;
            }
            case PRE_ALPHA: {
                return JackProvider.SubReleaseKind.PRE_ALPHA;
            }
            case ALPHA: {
                return JackProvider.SubReleaseKind.ALPHA;
            }
            case BETA: {
                return JackProvider.SubReleaseKind.BETA;
            }
            case CANDIDATE: {
                return JackProvider.SubReleaseKind.CANDIDATE;
            }
            case RELEASE: {
                return JackProvider.SubReleaseKind.RELEASE;
            }
        }
        throw new AssertionError((Object)Jack.getVersion().getSubReleaseKind().name());
    }

    @Override
    @CheckForNull
    public String getCompilerSourceCodeBase() {
        return Jack.getVersion().getCodeBase();
    }

    @Override
    public String getCompilerVersion() {
        return Jack.getVersion().getVersion();
    }

    @Override
    @CheckForNull
    public String getCompilerBuildId() {
        return Jack.getVersion().getBuildId();
    }

    @Override
    public void clean(@Nonnull Set<ResourceController.Category> categories, @Nonnull Set<ResourceController.Impact> impacts) {
        EnumSet<Impact> impactsInternal = EnumSet.noneOf(Impact.class);
        if (impacts.contains((Object)ResourceController.Impact.LATENCY)) {
            impactsInternal.add(Impact.LATENCY);
        }
        if (impacts.contains((Object)ResourceController.Impact.PERFORMANCE)) {
            impactsInternal.add(Impact.PERFORMANCE);
        }
        if (categories.contains((Object)ResourceController.Category.CODE)) {
            Jack.getResourceRequestBus().post(new CleanCodeRequest(impactsInternal));
        }
        if (categories.contains((Object)ResourceController.Category.MEMORY)) {
            Jack.getResourceRequestBus().post(new CleanMemoryRequest(impactsInternal));
        }
        if (categories.contains((Object)ResourceController.Category.DISK)) {
            Jack.getResourceRequestBus().post(new CleanDiskRequest(impactsInternal));
        }
    }

    public EnumSet<ResourceController.Category> getSupportedCategories() {
        return EnumSet.of(ResourceController.Category.CODE, ResourceController.Category.DISK, ResourceController.Category.MEMORY);
    }

    public EnumSet<ResourceController.Impact> getSupportedImpacts() {
        return EnumSet.of(ResourceController.Impact.LATENCY, ResourceController.Impact.PERFORMANCE);
    }

    static {
        impl.put(Api01Config.class, Api04ConfigImpl.class);
        impl.put(Api02Config.class, Api04ConfigImpl.class);
        impl.put(Api03Config.class, Api04ConfigImpl.class);
        impl.put(Api04Config.class, Api04ConfigImpl.class);
        impl.put(Cli01Config.class, Cli01ConfigImpl.class);
        features.put(Api01Config.class, Api01Feature.class);
        features.put(Api02Config.class, Api02Feature.class);
        features.put(Api03Config.class, Api03Feature.class);
        features.put(Api04Config.class, Api04Feature.class);
        features.put(Cli01Config.class, Api04Feature.class);
    }
}

