/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dfa.reachingdefs;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.common.ReachabilityAnalyzer;
import com.android.jack.analysis.dfa.reachingdefs.ReachingDefinitionsChecker;
import com.android.jack.analysis.dfa.reachingdefs.ReachingDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThis;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.ThreeAddressCodeFormUtils;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.id.ImplementationPropertyId;
import com.android.sched.util.config.id.PropertyId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Compute reaching definitions.")
@Constraint(need={ControlFlowGraph.class, DefinitionMarker.class})
@Transform(add={ReachingDefsMarker.class})
@Protect(add={JMethod.class, JStatement.class}, modify={JMethod.class, JStatement.class})
@Use(value={ThreeAddressCodeFormUtils.class})
@HasKeyId
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class ReachingDefinitions
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final PropertyId<ReachingDefinitionsChecker> REACHING_DEFS_CHECKER = ((ImplementationPropertyId)ImplementationPropertyId.create("jack.tests.reachingdefs.checker", "Define a checker that must be called at the end of reaching definitions analysis", ReachingDefinitionsChecker.class).addDefaultValue("none")).addCategory(Private.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    private final ReachingDefinitionsChecker checker = ThreadConfig.get(REACHING_DEFS_CHECKER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        this.solve(method);
        this.checker.check(method);
    }

    private void solve(@Nonnull JMethod method) {
        new Analyzer(method).analyze();
    }

    @Nonnull
    private DefinitionMarker getDefinitionMarkerForThis(@Nonnull JMethod method) {
        JThis jThis = method.getThis();
        assert (jThis != null);
        DefinitionMarker dm = jThis.getMarker(DefinitionMarker.class);
        assert (dm != null);
        return dm;
    }

    @Nonnull
    private List<DefinitionMarker> getDefinitions(@Nonnull List<DefinitionMarker> definitions, @Nonnull BitSet in) {
        ArrayList<DefinitionMarker> reachingDefs = new ArrayList<DefinitionMarker>();
        int i = in.nextSetBit(0);
        while (i >= 0) {
            reachingDefs.add(definitions.get(i));
            i = in.nextSetBit(i + 1);
        }
        return reachingDefs;
    }

    @Nonnull
    private List<DefinitionMarker> getAllDefinitions(@Nonnull JMethod method, @Nonnull ControlFlowGraph cfg) {
        ArrayList<DefinitionMarker> definitions = new ArrayList<DefinitionMarker>();
        int bitSetIdx = 0;
        if (method.getThis() != null) {
            DefinitionMarker dm = this.getDefinitionMarkerForThis(method);
            dm.setBitSetIdx(bitSetIdx++);
            definitions.add(dm);
        }
        for (JParameter param : method.getParams()) {
            DefinitionMarker dm = param.getMarker(DefinitionMarker.class);
            assert (dm != null);
            dm.setBitSetIdx(bitSetIdx++);
            definitions.add(dm);
        }
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                DefinitionMarker dm = ThreeAddressCodeFormUtils.getDefinitionMarker(stmt);
                if (dm == null) continue;
                dm.setBitSetIdx(bitSetIdx++);
                definitions.add(dm);
            }
        }
        return definitions;
    }

    private class Analyzer
    extends ReachabilityAnalyzer<BitSet> {
        @Nonnull
        final ControlFlowGraph cfg;
        @Nonnull
        final List<DefinitionMarker> definitions;
        final int initialized;

        private Analyzer(JMethod method) {
            ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
            assert (cfg != null);
            this.cfg = cfg;
            this.definitions = ReachingDefinitions.this.getAllDefinitions(method, this.cfg);
            this.initialized = (method.getThis() != null ? 1 : 0) + method.getParams().size();
        }

        @Override
        @Nonnull
        protected ControlFlowGraph getCfg() {
            return this.cfg;
        }

        @Override
        public void finalize(@Nonnull List<BitSet> in, @Nonnull List<BitSet> out, @Nonnull List<BitSet> outException) {
            for (BasicBlock bb : this.getCfg().getNodes()) {
                bb.addMarker(new ReachingDefsMarker(ReachingDefinitions.this.getDefinitions(this.definitions, in.get(bb.getId()))));
            }
        }

        @Override
        @Nonnull
        public BitSet newState(boolean entry) {
            BitSet s = new BitSet(this.definitions.size());
            if (entry) {
                s.set(0, this.initialized);
            }
            return s;
        }

        @Override
        public void copyState(@Nonnull BitSet src, @Nonnull BitSet dest) {
            dest.clear();
            dest.or(src);
        }

        @Override
        public void mergeState(@Nonnull BitSet state, @Nonnull BitSet otherState) {
            state.or(otherState);
        }

        @Override
        public void processStatement(@Nonnull BitSet outBs, @Nonnull JStatement stmt) {
            DefinitionMarker currentDef = ThreeAddressCodeFormUtils.getDefinitionMarker(stmt);
            if (currentDef != null) {
                outBs.set(currentDef.getBitSetIdx());
                int i = outBs.nextSetBit(0);
                while (i >= 0) {
                    DefinitionMarker dm = this.definitions.get(i);
                    if (dm.getDefinedVariable() == currentDef.getDefinedVariable() && dm != currentDef) {
                        outBs.clear(dm.getBitSetIdx());
                    }
                    i = outBs.nextSetBit(i + 1);
                }
            }
        }

        @Override
        @Nonnull
        public BitSet cloneState(@Nonnull BitSet state) {
            return (BitSet)state.clone();
        }
    }
}

