/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dependency.type;

import com.android.jack.Jack;
import com.android.jack.analysis.dependency.type.TypeDependencies;
import com.android.jack.backend.dex.TypeReferenceCollector;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Collect type dependencies")
@Name(value="TypeDependenciesCollector")
@Transform(add={TypeDependencies.Collected.class})
@Synchronized
@Filter(value={SourceTypeFilter.class})
@Access(value=JSession.class)
public class TypeDependenciesCollector
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private final TypeDependencies typeDependencies = Jack.getSession().getTypeDependencies();

    @Override
    public synchronized void run(@Nonnull JDefinedClassOrInterface declaredType) {
        Visitor v = new Visitor(declaredType);
        v.accept(declaredType);
    }

    private class Visitor
    extends TypeReferenceCollector {
        @Nonnull
        private final JType currentType;

        public Visitor(JType currentType) {
            this.currentType = currentType;
            if (currentType instanceof JDefinedClassOrInterface) {
                JClass superClass;
                if (currentType instanceof JDefinedClass && (superClass = ((JDefinedClass)currentType).getSuperClass()) != null) {
                    TypeDependenciesCollector.this.typeDependencies.addHierarchyDependency(currentType, superClass);
                }
                for (JInterface interf : ((JDefinedClassOrInterface)currentType).getImplements()) {
                    TypeDependenciesCollector.this.typeDependencies.addHierarchyDependency(currentType, interf);
                }
            }
        }

        @Override
        public void endVisit(@Nonnull JType type) {
            if (type instanceof JDefinedClassOrInterface) {
                TypeDependenciesCollector.this.typeDependencies.createEmptyDependencyIfNeeded(this.currentType);
            }
        }

        @Override
        protected void collect(@Nonnull JType usedType) {
            if (usedType instanceof JArrayType) {
                usedType = ((JArrayType)usedType).getLeafType();
            }
            if (!(usedType instanceof JPrimitiveType)) {
                TypeDependenciesCollector.this.typeDependencies.addCodeDependency(this.currentType, usedType);
            }
        }
    }
}

