/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.defsuses;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.analysis.UsedVariableMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Remove def-uses and use-defs chains.")
@Constraint(need={UseDefsMarker.class, UsedVariableMarker.class, ControlFlowGraph.class})
@Transform(remove={UseDefsMarker.class}, modify={DefinitionMarker.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class DefUsesAndUseDefsChainRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                UsedVariableMarker uvm = stmt.getMarker(UsedVariableMarker.class);
                assert (uvm != null);
                for (JVariableRef usedVarRef : uvm.getUsedVariables()) {
                    UseDefsMarker udm = usedVarRef.getMarker(UseDefsMarker.class);
                    assert (udm != null);
                    for (DefinitionMarker dm : udm.getDefs()) {
                        dm.clearUses();
                    }
                    usedVarRef.removeMarker(UseDefsMarker.class);
                }
            }
        }
    }
}

