/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.defsuses;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.analysis.UsedVariableMarker;
import com.android.jack.analysis.dfa.reachingdefs.ReachingDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.ThreeAddressCodeFormUtils;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Compute defs-uses and uses-defs chains.")
@Constraint(need={ControlFlowGraph.class, ReachingDefsMarker.class, UsedVariableMarker.class})
@Transform(add={UseDefsMarker.class})
@Protect(add={JMethod.class, JStatement.class}, modify={JMethod.class, JStatement.class})
@Use(value={ThreeAddressCodeFormUtils.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class DefUsesAndUseDefsChainComputation
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock bb : cfg.getNodes()) {
            ReachingDefsMarker reachingDefs = bb.getMarker(ReachingDefsMarker.class);
            assert (reachingDefs != null);
            ArrayList<DefinitionMarker> currentDefs = new ArrayList<DefinitionMarker>(reachingDefs.getReachingDefs());
            for (JStatement stmt : bb.getStatements()) {
                UsedVariableMarker uvm = stmt.getMarker(UsedVariableMarker.class);
                assert (uvm != null);
                for (JVariableRef usedVarRef : uvm.getUsedVariables()) {
                    JVariable var = usedVarRef.getTarget();
                    assert (usedVarRef.getMarker(UseDefsMarker.class) == null);
                    UseDefsMarker udm = new UseDefsMarker();
                    usedVarRef.addMarker(udm);
                    for (DefinitionMarker def : currentDefs) {
                        if (def.getDefinedVariable() != var) continue;
                        udm.addUsedDefinition(def, usedVarRef);
                    }
                    assert (!udm.isWithoutDefinition());
                }
                this.updateCurrentDefs(stmt, currentDefs);
            }
        }
    }

    private void updateCurrentDefs(@Nonnull JStatement stmt, @Nonnull List<DefinitionMarker> currentDefs) {
        DefinitionMarker newDef = ThreeAddressCodeFormUtils.getDefinitionMarker(stmt);
        if (newDef != null) {
            JVariable varToRemove = newDef.getDefinedVariable();
            Iterator<DefinitionMarker> it = currentDefs.iterator();
            while (it.hasNext()) {
                if (it.next().getDefinedVariable() != varToRemove) continue;
                it.remove();
            }
            currentDefs.add(newDef);
        }
    }
}

