/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.With;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Add definition marker on IR.")
@Constraint(need={JExceptionRuntimeValue.class})
@Transform(add={DefinitionMarker.class})
@Protect(add={JParameter.class, JAsgOperation.class, JAsgOperation.NonReusedAsg.class}, unprotect={@With(remove={DefinitionMarker.class})})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class DefinitionMarkerAdder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JMethod jmethod) {
            JThis thisVar = jmethod.getThis();
            if (thisVar != null && !thisVar.containsMarker(DefinitionMarker.class)) {
                thisVar.addMarkerIfAbsent(new DefinitionMarker(thisVar));
            }
            return super.visit(jmethod);
        }

        @Override
        public boolean visit(@Nonnull JParameter parameter) {
            parameter.addMarker(new DefinitionMarker(parameter));
            return super.visit(parameter);
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binary) {
            JAsgOperation assign;
            if (binary instanceof JAsgOperation && (assign = (JAsgOperation)binary).getLhs() instanceof JVariableRef) {
                binary.addMarker(new DefinitionMarker(binary));
            }
            return super.visit(binary);
        }
    }
}

