/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.util.Comparator;
import org.kohsuke.args4j.spi.OptionHandler;

public class ParserProperties {
    private static final int DEFAULT_USAGE_WIDTH = 80;
    private int usageWidth = 80;
    private Comparator<OptionHandler> optionSorter = DEFAULT_COMPARATOR;
    private String optionValueDelimiter = " ";
    private boolean atSyntax = true;
    static final Comparator<OptionHandler> DEFAULT_COMPARATOR = new Comparator<OptionHandler>(){

        @Override
        public int compare(OptionHandler o1, OptionHandler o2) {
            return o1.option.toString().compareTo(o2.option.toString());
        }
    };

    private ParserProperties() {
    }

    public static ParserProperties defaults() {
        return new ParserProperties();
    }

    public ParserProperties withAtSyntax(boolean atSyntax) {
        this.atSyntax = atSyntax;
        return this;
    }

    public boolean getAtSyntax() {
        return this.atSyntax;
    }

    public ParserProperties withUsageWidth(int usageWidth) {
        if (usageWidth < 0) {
            throw new IllegalArgumentException("Usage width is negative");
        }
        this.usageWidth = usageWidth;
        return this;
    }

    int getUsageWidth() {
        return this.usageWidth;
    }

    public ParserProperties withOptionSorter(Comparator<OptionHandler> sorter) {
        this.optionSorter = sorter;
        return this;
    }

    Comparator<OptionHandler> getOptionSorter() {
        return this.optionSorter;
    }

    public ParserProperties withOptionValueDelimiter(String v) {
        this.optionValueDelimiter = v;
        return this;
    }

    public String getOptionValueDelimiter() {
        return this.optionValueDelimiter;
    }
}

