/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.util.Arrays;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;

public final class NamedOptionDef
extends OptionDef {
    private final String name;
    private final String[] aliases;
    private final String[] depends;
    private final String[] forbids;

    public NamedOptionDef(Option o, boolean forceMultiValued) {
        this(o);
    }

    public NamedOptionDef(Option o) {
        super(o.usage(), o.metaVar(), o.required(), o.help(), o.hidden(), o.handler(), false);
        this.name = o.name();
        this.aliases = NamedOptionDef.createZeroSizedArrayIfNull(o.aliases());
        this.depends = NamedOptionDef.createZeroSizedArrayIfNull(o.depends());
        this.forbids = NamedOptionDef.createZeroSizedArrayIfNull(o.forbids());
    }

    private static String[] createZeroSizedArrayIfNull(String[] in) {
        if (in == null) {
            return new String[0];
        }
        return in;
    }

    public String name() {
        return this.name;
    }

    public String[] aliases() {
        return Arrays.copyOf(this.aliases, this.aliases.length);
    }

    public String[] depends() {
        return Arrays.copyOf(this.depends, this.depends.length);
    }

    public String[] forbids() {
        return Arrays.copyOf(this.forbids, this.forbids.length);
    }

    @Override
    public String toString() {
        if (this.aliases.length > 0) {
            String str = "";
            for (String alias : this.aliases) {
                if (str.length() > 0) {
                    str = String.valueOf(str).concat(", ");
                }
                String string = String.valueOf(str);
                String string2 = String.valueOf(alias);
                str = string2.length() != 0 ? string.concat(string2) : new String(string);
            }
            String string = this.name();
            String string3 = str;
            return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" (").append(string3).append(")").toString();
        }
        return this.name();
    }

    @Override
    public boolean isArgument() {
        return false;
    }
}

