/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.InMemoryVDir;
import com.android.sched.vfs.ParentVFile;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VFSStatCategory;
import com.android.sched.vfs.VPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CachedDirectFS
extends BaseVFS<CachedParentVDir, CachedParentVFile>
implements VFS {
    @Nonnull
    private final Directory dir;
    @Nonnull
    private final CachedParentVDir root;
    @Nonnull
    private final Set<Capabilities> capabilities;
    @CheckForNull
    private String infoString;

    public CachedDirectFS(@Nonnull Directory dir, int permissions) {
        this.dir = dir;
        this.root = new CachedParentVDir(this, "");
        EnumSet<Capabilities> capabilities = EnumSet.noneOf(Capabilities.class);
        if ((permissions & 1) != 0) {
            capabilities.add(Capabilities.READ);
            capabilities.add(Capabilities.PARALLEL_READ);
        }
        if ((permissions & 2) != 0) {
            capabilities.add(Capabilities.WRITE);
            capabilities.add(Capabilities.PARALLEL_WRITE);
        }
        capabilities.add(Capabilities.UNIQUE_ELEMENT);
        this.capabilities = Collections.unmodifiableSet(capabilities);
        this.fillVDirFromRealDirectory(dir.getFile(), this.root);
    }

    private void fillVDirFromRealDirectory(@Nonnull File dir, @Nonnull VDir vDir) {
        File[] fileList = dir.listFiles();
        assert (fileList != null);
        for (File element : fileList) {
            try {
                if (element.isDirectory()) {
                    VDir newVDir = vDir.createVDir(element.getName());
                    this.fillVDirFromRealDirectory(element, newVDir);
                    continue;
                }
                vDir.createVFile(element.getName());
            }
            catch (CannotCreateFileException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "directory on disk with cache";
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.dir.getLocation();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.dir.getPath();
    }

    @Override
    public CachedParentVDir getRootDir() {
        return this.root;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull CachedParentVFile file) throws WrongPermissionException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        VFSStatCategory.DIR_READ.getCounterStat(this.getTracer(), this.infoString).incValue();
        File path = this.getNativeFile(file.getPath());
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            FileOrDirectory.checkPermissions(path, file.getLocation(), 1);
            throw new ConcurrentIOException(e);
        }
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull CachedParentVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull CachedParentVFile file, boolean append) throws WrongPermissionException {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.WRITE));
        VFSStatCategory.DIR_WRITE.getCounterStat(this.getTracer(), this.infoString).incValue();
        File path = this.getNativeFile(file.getPath());
        try {
            return new FileOutputStream(path, append);
        }
        catch (FileNotFoundException e) {
            FileOrDirectory.checkPermissions(path, file.getLocation(), 2);
            throw new ConcurrentIOException(e);
        }
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull CachedParentVDir dir) {
        return dir.getAllFromCache();
    }

    @Override
    boolean isEmpty(@Nonnull CachedParentVDir dir) {
        assert (!this.isClosed());
        assert (this.capabilities.contains((Object)Capabilities.READ));
        File[] fileList = this.getNativeFile(dir.getPath()).listFiles();
        assert (fileList != null);
        return fileList.length == 0;
    }

    @Override
    @Nonnull
    CachedParentVDir getVDir(@Nonnull CachedParentVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        BaseVElement element = parent.getFromCache(name);
        if (element != null) {
            if (element.isVDir()) {
                return (CachedParentVDir)element;
            }
            throw new NotDirectoryException(this.getVDirLocation(parent, name));
        }
        throw new NoSuchFileException(this.getVDirLocation(parent, name));
    }

    @Override
    @Nonnull
    CachedParentVFile getVFile(@Nonnull CachedParentVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        BaseVElement element = parent.getFromCache(name);
        if (element != null) {
            if (!element.isVDir()) {
                return (CachedParentVFile)element;
            }
            throw new NotFileException(this.getVFileLocation(parent, name));
        }
        throw new NoSuchFileException(this.getVFileLocation(parent, name));
    }

    @Override
    @Nonnull
    void delete(@Nonnull CachedParentVFile file) throws CannotDeleteFileException {
        assert (!this.isClosed());
        File path = this.getNativeFile(file.getPath());
        if (!path.delete() || path.exists()) {
            throw new CannotDeleteFileException(file);
        }
        file.deleteFromCache();
    }

    @Override
    @Nonnull
    synchronized CachedParentVFile createVFile(@Nonnull CachedParentVDir parent, @Nonnull String name) throws CannotCreateFileException {
        assert (!this.isClosed());
        try {
            return this.getVFile(parent, name);
        }
        catch (NoSuchFileException e) {
            File path = this.getNativeFile(parent.getPath(), name);
            try {
                AbstractStreamFile.create(path, new FileLocation(path));
                VFSStatCategory.DIR_CREATE.getPercentStat(this.getTracer(), this.infoString).addTrue();
            }
            catch (FileAlreadyExistsException e2) {
                VFSStatCategory.DIR_CREATE.getPercentStat(this.getTracer(), this.infoString).addFalse();
            }
            CachedParentVFile vFile = new CachedParentVFile(this, parent, name);
            parent.putInCache(name, vFile);
            return vFile;
        }
        catch (NotFileException e) {
            throw new CannotCreateFileException(this.getVFileLocation(parent, name));
        }
    }

    @Override
    @Nonnull
    synchronized CachedParentVDir createVDir(@Nonnull CachedParentVDir parent, @Nonnull String name) throws CannotCreateFileException {
        assert (!this.isClosed());
        try {
            return this.getVDir(parent, name);
        }
        catch (NoSuchFileException e) {
            File path = this.getNativeFile(parent.getPath(), name);
            try {
                Directory.create(path, new DirectoryLocation(path));
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            CachedParentVDir vDir = new CachedParentVDir(this, parent, name);
            parent.putInCache(name, vDir);
            return vDir;
        }
        catch (NotDirectoryException e) {
            throw new CannotCreateFileException(this.getVDirLocation(parent, name));
        }
    }

    @Override
    public boolean needsSequentialWriting() {
        return false;
    }

    @Override
    @Nonnull
    public FileTime getLastModified(@Nonnull CachedParentVFile file) throws CannotGetModificationTimeException {
        try {
            return Files.getLastModifiedTime(this.getNativeFile(file.getPath()).toPath(), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CannotGetModificationTimeException(this, (Throwable)e);
        }
    }

    @Nonnull
    FileLocation getVFileLocation(@Nonnull CachedParentVFile file) {
        return new FileLocation(this.getNativeFile(file.getPath()));
    }

    @Nonnull
    FileLocation getVFileLocation(@Nonnull CachedParentVDir parent, @Nonnull String name) {
        return new FileLocation(this.getNativeFile(parent.getPath(), name));
    }

    @Nonnull
    DirectoryLocation getVDirLocation(@Nonnull CachedParentVDir dir) {
        return new DirectoryLocation(this.getNativeFile(dir.getPath()));
    }

    @Nonnull
    DirectoryLocation getVDirLocation(@Nonnull CachedParentVDir parent, @Nonnull String name) {
        return new DirectoryLocation(this.getNativeFile(parent.getPath(), name));
    }

    @Nonnull
    FileLocation getVFileLocation(CachedParentVDir parent, VPath path) {
        return new FileLocation(this.getNativeFile(parent.getPath().clone().appendPath(path)));
    }

    @Nonnull
    DirectoryLocation getVDirLocation(CachedParentVDir parent, VPath path) {
        return new DirectoryLocation(this.getNativeFile(parent.getPath().clone().appendPath(path)));
    }

    @Nonnull
    private File getNativeFile(@Nonnull VPath path) {
        return new File(this.dir.getFile(), path.getPathAsString(File.separatorChar));
    }

    @Nonnull
    private File getNativeFile(@Nonnull VPath path, @Nonnull String name) {
        return new File(new File(this.dir.getFile(), path.getPathAsString(File.separatorChar)), name);
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull CachedParentVDir parent, @Nonnull CachedParentVFile file) {
        StringBuffer path = CachedDirectFS.getPathFromDirInternal(parent, (CachedParentVDir)file.getParent()).append(file.getName());
        return new VPath(path.toString(), '/');
    }

    @Nonnull
    private static StringBuffer getPathFromDirInternal(@Nonnull CachedParentVDir baseDir, @Nonnull CachedParentVDir currentDir) {
        if (baseDir == currentDir) {
            return new StringBuffer();
        }
        CachedParentVDir currentParent = currentDir.getParent();
        assert (currentParent != null);
        return CachedDirectFS.getPathFromDirInternal(baseDir, currentParent).append(currentDir.getName()).append('/');
    }

    @Override
    @Nonnull
    public VPath getPathFromRoot(@Nonnull CachedParentVFile file) {
        return this.getPathFromDir(this.root, file);
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.infoString;
    }

    public void setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
    }

    public String toString() {
        return "cachedDirFS: " + this.getLocation().getDescription();
    }

    static class CachedParentVFile
    extends ParentVFile {
        CachedParentVFile(@Nonnull BaseVFS<? extends BaseVDir, ? extends BaseVFile> vfs, @Nonnull VDir parent, @Nonnull String name) {
            super(vfs, parent, name);
        }

        @Override
        public void delete() throws CannotDeleteFileException {
            this.vfs.delete(this);
        }

        public void deleteFromCache() {
            ((InMemoryVDir)this.parent).internalDelete(this.name);
        }
    }

    static class CachedParentVDir
    extends InMemoryVDir {
        @CheckForNull
        private CachedParentVDir parent;

        CachedParentVDir(@Nonnull BaseVFS<? extends CachedParentVDir, ? extends ParentVFile> vfs, @Nonnull String name) {
            super((BaseVFS<? extends InMemoryVDir, ? extends BaseVFile>)vfs, name);
        }

        CachedParentVDir(@Nonnull BaseVFS<? extends CachedParentVDir, ? extends ParentVFile> vfs, @Nonnull CachedParentVDir parent, @Nonnull String name) {
            super((BaseVFS<? extends InMemoryVDir, ? extends BaseVFile>)vfs, name);
            this.parent = parent;
        }

        @Override
        @Nonnull
        public VPath getPath() {
            if (this.parent != null) {
                return this.parent.getPath().clone().appendPath(new VPath(this.name, '/'));
            }
            return VPath.ROOT;
        }

        @Override
        @Nonnull
        public BaseVFile getVFile(@Nonnull String name) throws NoSuchFileException, NotFileException {
            return this.vfs.getVFile(this, name);
        }

        @Override
        @Nonnull
        public BaseVDir getVDir(@Nonnull String name) throws NotDirectoryException, NoSuchFileException {
            return this.vfs.getVDir(this, name);
        }

        @Override
        @Nonnull
        public BaseVFile createVFile(@Nonnull String name) throws CannotCreateFileException {
            return this.vfs.createVFile(this, name);
        }

        @Override
        @Nonnull
        public BaseVDir createVDir(@Nonnull String name) throws CannotCreateFileException {
            return this.vfs.createVDir(this, name);
        }

        @Override
        @Nonnull
        public Collection<? extends BaseVElement> list() {
            return this.vfs.list(this);
        }

        @CheckForNull
        public CachedParentVDir getParent() {
            return this.parent;
        }
    }
}

