/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.tracer.probe.MemoryBytesProbe;
import com.android.sched.util.log.tracer.probe.Probe;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@ImplementationName(iface=Probe.class, name="heap-usage")
public class HeapMemoryProbe
extends MemoryBytesProbe {
    @Nonnull
    private final MemoryMXBean mmMXBean;

    public HeapMemoryProbe() {
        super("Heap Memory Usage", 11);
        try {
            this.mmMXBean = ManagementFactory.getMemoryMXBean();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @Nonnegative
    @SuppressFBWarnings(value={"DM_GC"})
    public long read() {
        System.gc();
        return this.mmMXBean.getHeapMemoryUsage().getUsed();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

