/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.StandardOutputKind;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.stream.QueryableOutputStream;
import com.android.sched.util.stream.UncloseableOutputStream;
import com.android.sched.vfs.OutputStreamProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class OutputStreamFile
extends AbstractStreamFile
implements OutputStreamProvider {
    private final boolean append;

    public OutputStreamFile(@Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(new File(name), new FileLocation(name), hooks, existence, change, append);
    }

    public OutputStreamFile(@CheckForNull Directory workingDirectory, @Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(OutputStreamFile.getFileFromWorkingDirectory(workingDirectory, name), new FileLocation(name), hooks, existence, change, append);
    }

    protected OutputStreamFile(@Nonnull File file, @Nonnull FileLocation location, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        super(file, location, hooks);
        this.performChecks(existence, 2, change);
        this.append = append;
    }

    public OutputStreamFile(@Nonnull String name, @CheckForNull RunnableHooks hooks) throws CannotCreateFileException, WrongPermissionException, NotFileException {
        super(name, hooks);
        try {
            this.performChecks(FileOrDirectory.Existence.MAY_EXIST, 2, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (NoSuchFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        this.append = false;
    }

    public OutputStreamFile(@Nonnull String name) throws WrongPermissionException, NotFileException {
        super(name, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 2, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (NoSuchFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        this.append = false;
    }

    public OutputStreamFile(@Nonnull StandardOutputKind standardOutputKind) {
        super(standardOutputKind.getLocation());
        this.stream = new QueryableOutputStream(new UncloseableOutputStream(standardOutputKind.getOutputStream()));
        this.append = true;
    }

    public OutputStreamFile(@Nonnull OutputStream stream, @Nonnull Location location) {
        super(location);
        this.stream = new QueryableOutputStream(new UncloseableOutputStream(stream));
        this.append = true;
    }

    @Override
    @Nonnull
    public synchronized OutputStream getOutputStream() {
        this.wasUsed = true;
        if (this.stream == null) {
            this.clearRemover();
            try {
                this.stream = new QueryableOutputStream(new FileOutputStream(this.file, this.append));
            }
            catch (FileNotFoundException e) {
                throw new ConcurrentIOException(e);
            }
        }
        return (OutputStream)((Object)this.stream);
    }

    public boolean isInAppendMode() {
        return this.append;
    }
}

