/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class ChainedException
extends Exception
implements Iterable<ChainedException> {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private String message;
    @Nonnegative
    private int count = 1;
    @Nonnull
    private ChainedException tail = this;
    @CheckForNull
    private ChainedException next = null;

    public ChainedException(@Nonnull String message) {
        super("");
        this.message = message;
    }

    public ChainedException(@Nonnull String message, @Nonnull Throwable cause) {
        super("", cause);
        this.message = message;
    }

    public ChainedException(@Nonnull Throwable cause) {
        super(cause);
        this.message = cause.getMessage();
    }

    @Override
    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public String getLocalizedMessage() {
        return this.message;
    }

    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    @Nonnull
    protected ChainedException putAsLastExceptionOf(@CheckForNull ChainedException head) {
        if (head == null) {
            this.tail = this;
            this.next = null;
            this.count = 1;
            return this;
        }
        head.tail.next = this;
        head.tail = this;
        ++head.count;
        return head;
    }

    @CheckForNull
    public ChainedException getNextException() {
        return this.next;
    }

    @Nonnegative
    public int getNextExceptionCount() {
        return this.count;
    }

    @Override
    @Nonnull
    public Iterator<ChainedException> iterator() {
        ArrayList<ChainedException> list = new ArrayList<ChainedException>(this.count);
        ChainedException exception = this;
        do {
            list.add(exception);
        } while ((exception = exception.next) != null);
        return list.iterator();
    }

    public static class ChainedExceptionBuilder<T extends ChainedException> {
        @CheckForNull
        private T head = null;

        public void appendException(@Nonnull T exceptions) {
            for (ChainedException exception : exceptions) {
                this.head = exception.putAsLastExceptionOf((ChainedException)this.head);
            }
        }

        public void throwIfNecessary() throws T {
            if (this.head != null) {
                throw this.head;
            }
        }

        @Nonnull
        public T getException() {
            assert (this.head != null);
            return this.head;
        }
    }
}

