/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class OrCodec<T>
implements StringCodec<T> {
    @Nonnull
    protected final List<StringCodec<? extends T>> codecList;

    public OrCodec(@Nonnull List<StringCodec<? extends T>> codecList) {
        assert (codecList.size() >= 2);
        this.codecList = codecList;
    }

    public OrCodec(StringCodec<? extends T> ... codecList) {
        assert (codecList.length >= 2);
        this.codecList = Arrays.asList(codecList);
    }

    @Override
    @Nonnull
    public T parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public T checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        for (StringCodec<T> codec : this.codecList) {
            try {
                return codec.checkString(context, string);
            }
            catch (ParsingException parsingException) {
            }
        }
        return this.codecList.get(0).checkString(context, string);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull T data) {
    }

    @Override
    @Nonnull
    public String getUsage() {
        return Joiner.on(" or ").join(Collections2.transform(this.codecList, new Function<StringCodec<? extends T>, String>(){

            @Override
            public String apply(@Nonnull StringCodec<? extends T> codec) {
                return codec.getUsage();
            }
        }));
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return Joiner.on("-or-").join(Collections2.transform(this.codecList, new Function<StringCodec<? extends T>, String>(){

            @Override
            public String apply(@Nonnull StringCodec<? extends T> codec) {
                return codec.getVariableName();
            }
        }));
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull T data) {
        for (StringCodec<T> codec : this.codecList) {
            try {
                return codec.formatValue(data);
            }
            catch (ClassCastException classCastException) {
            }
        }
        throw new AssertionError();
    }
}

