/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.Selector;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.ReflectDefaultCtorFactory;
import com.google.common.base.Joiner;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ImplementationSelector<T>
extends Selector<T>
implements StringCodec<T> {
    private boolean bypassAccessibility = false;

    public ImplementationSelector(@Nonnull Class<T> type) {
        super(type);
    }

    public ImplementationSelector<T> bypassAccessibility() {
        this.bypassAccessibility = true;
        return this;
    }

    @Override
    @CheckForNull
    public T checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        this.getClass(string);
        return null;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull T data) throws CheckingException {
        if (!this.checkClass(data.getClass())) {
            throw new CheckingException("The value must be an instance of {" + Joiner.on(',').join(this.getClasses()) + "} but is an instance of '" + data.getClass().getCanonicalName() + "'");
        }
    }

    @Override
    @Nonnull
    public T parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return new ReflectDefaultCtorFactory(this.getClass(string), !this.bypassAccessibility).create();
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull T data) {
        return this.getName(data.getClass());
    }
}

