/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.sched.item.Component;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

class AddRunnerMutation<T extends Component>
implements EvolutionaryOperator<GroupPlanCandidate<T>> {
    @Nonnull
    private final NumberGenerator<Probability> addProbability;
    @Nonnull
    private final List<ManagedRunnable> runners = new ArrayList<ManagedRunnable>();

    public AddRunnerMutation(@Nonnull NumberGenerator<Probability> addProbability, @Nonnull Request request, @Nonnull Class<? extends Component> runOn) {
        this.addProbability = addProbability;
        for (ManagedSchedulable schedulable : request.getRunners()) {
            if (!schedulable.isRunnable() || !((ManagedRunnable)schedulable).getProductions().isEmpty()) continue;
            this.runners.add((ManagedRunnable)schedulable);
        }
    }

    @Nonnull
    public List<GroupPlanCandidate<T>> apply(List<GroupPlanCandidate<T>> selectedCandidates, Random rng) {
        ArrayList<GroupPlanCandidate<T>> mutatedCandidates = new ArrayList<GroupPlanCandidate<T>>(selectedCandidates.size());
        for (GroupPlanCandidate<T> candidate : selectedCandidates) {
            if (((Probability)this.addProbability.nextValue()).nextEvent(rng)) {
                ArrayList<ManagedRunnable> newRunners = new ArrayList<ManagedRunnable>(candidate.getRunnables());
                newRunners.add(rng.nextInt(newRunners.size() + 1), this.runners.get(rng.nextInt(this.runners.size())));
                mutatedCandidates.add(new GroupPlanCandidate<T>(candidate, newRunners));
                continue;
            }
            mutatedCandidates.add(candidate);
        }
        return mutatedCandidates;
    }
}

