/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.schedulable.ProcessorSchedulable;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanError;
import com.android.sched.scheduler.PlanStep;
import com.android.sched.scheduler.SchedulableNotRegisteredError;
import com.android.sched.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SubPlanBuilder<T extends Component> {
    @Nonnull
    private final Scheduler scheduler;
    @Nonnull
    private final Class<T> runOn;
    @Nonnull
    protected Plan<T> plan;

    protected SubPlanBuilder(@Nonnull Scheduler scheduler, @Nonnull Class<T> runOn) {
        this.runOn = runOn;
        this.scheduler = scheduler;
        this.plan = new Plan(scheduler, runOn);
    }

    public void append(@Nonnull Class<? extends ProcessorSchedulable<T>> runner) {
        ManagedRunnable ir = (ManagedRunnable)this.scheduler.getSchedulableManager().getManagedSchedulable(runner);
        if (ir == null) {
            throw new SchedulableNotRegisteredError(runner);
        }
        if (!ir.getRunOn().equals(this.runOn)) {
            throw new PlanError("'" + ir.getName() + "' expect to be applied on '" + ir.getRunOn().toString() + "' but was on '" + this.runOn.toString() + "'");
        }
        this.append(ir);
    }

    public void append(@Nonnull ManagedRunnable runner) {
        assert (runner != null);
        assert (runner.getRunOn().equals(this.runOn)) : "Expect '" + runner.getRunOn().toString() + "', have '" + this.runOn.toString() + "'";
        this.plan.appendStep(new PlanStep(runner));
    }

    @Nonnull
    public <U extends Component> SubPlanBuilder<U> appendSubPlan(@Nonnull Class<? extends AdapterSchedulable<T, U>> visitor) {
        ManagedVisitor ia = (ManagedVisitor)this.scheduler.getSchedulableManager().getManagedSchedulable(visitor);
        if (ia == null) {
            throw new SchedulableNotRegisteredError(visitor);
        }
        if (!ia.getRunOn().equals(this.runOn)) {
            throw new PlanError("'" + ia.getName() + "' expect to be applied on '" + ia.getRunOn().toString() + "' but was on '" + this.runOn.toString() + "'");
        }
        return this.appendSubPlan(ia);
    }

    @Nonnull
    public <U extends Component> SubPlanBuilder<U> appendSubPlan(@Nonnull ManagedVisitor visitor) {
        assert (visitor != null);
        assert (visitor.getRunOn().equals(this.runOn)) : "Expect '" + visitor.getRunOn().toString() + "', have '" + this.runOn.toString() + "'";
        SubPlanBuilder<? extends Component> subPlanBuilder = new SubPlanBuilder<Component>(this.scheduler, visitor.getRunOnAfter());
        this.plan.appendStep(new PlanStep(visitor, subPlanBuilder.plan));
        return subPlanBuilder;
    }

    @Nonnull
    public Class<T> getRunOn() {
        return this.runOn;
    }

    @Nonnull
    @Deprecated
    public List<ManagedRunnable> getRunners() {
        ArrayList<ManagedRunnable> list = new ArrayList<ManagedRunnable>();
        SubPlanBuilder.getRunners(this.plan, list);
        return list;
    }

    @Nonnull
    private static List<ManagedRunnable> getRunners(@Nonnull Plan<?> plan, @Nonnull List<ManagedRunnable> list) {
        for (PlanStep step : plan) {
            ManagedSchedulable schedulable = step.getManagedSchedulable();
            if (step.isRunner()) {
                list.add((ManagedRunnable)schedulable);
                continue;
            }
            SubPlanBuilder.getRunners(step.getSubPlan(), list);
        }
        return list;
    }

    @Nonnull
    public String toString() {
        return this.plan.toString();
    }

    @Nonnull
    public String getDescription() {
        return this.plan.getDescription();
    }

    @Nonnull
    public String getDetailedDescription() {
        return this.plan.getDetailedDescription();
    }
}

