/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.SchedulableManager;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class RunnerSet
implements Iterable<ManagedRunnable> {
    @Nonnull
    private final SchedulableManager schedulableManager;
    @Nonnull
    private final Set<ManagedRunnable> runners = new TreeSet<ManagedSchedulable>(new SchedulableComparator());

    public RunnerSet(@Nonnull SchedulableManager manager) {
        this.schedulableManager = manager;
    }

    public RunnerSet(@Nonnull RunnerSet initial) {
        this.schedulableManager = initial.schedulableManager;
        this.runners.addAll(initial.runners);
    }

    public void add(@Nonnull Class<? extends RunnableSchedulable<?>> sched) {
        this.runners.add((ManagedRunnable)this.schedulableManager.getManagedSchedulable(sched));
    }

    public void addAll(@Nonnull RunnerSet set) {
        this.runners.addAll(set.runners);
    }

    public void add(@Nonnull ManagedRunnable sched) {
        this.runners.add(sched);
    }

    @Nonnegative
    public int getSize() {
        return this.runners.size();
    }

    @Nonnull
    public Set<ManagedRunnable> getAll() {
        return this.runners;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (ManagedRunnable sched : this.runners) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(sched.getName());
        }
        sb.append(']');
        return new String(sb);
    }

    public void removeAll(@Nonnull List<ManagedRunnable> list) {
        this.runners.removeAll(list);
    }

    public void remove(@Nonnull ManagedRunnable runner) {
        this.runners.remove(runner);
    }

    @Override
    @Nonnull
    public Iterator<ManagedRunnable> iterator() {
        return this.runners.iterator();
    }

    private static class SchedulableComparator
    implements Comparator<ManagedSchedulable>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SchedulableComparator() {
        }

        @Override
        public int compare(@CheckForNull ManagedSchedulable o1, @CheckForNull ManagedSchedulable o2) {
            assert (o1 != null);
            assert (o2 != null);
            return o1.getName().compareTo(o2.getName());
        }
    }
}

