/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.reflections;

import com.android.sched.SchedProperties;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Item;
import com.android.sched.item.ItemSet;
import com.android.sched.item.Items;
import com.android.sched.item.ManagedItem;
import com.android.sched.item.onlyfor.Default;
import com.android.sched.item.onlyfor.OnlyForType;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.sched.ManagedDataListener;
import com.android.sched.util.sched.ManagedDataListenerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ItemManager
extends AbstractItemManager {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Class<? extends OnlyForType> onlyFor = ThreadConfig.get(SchedProperties.ONLY_FOR);
    @Nonnull
    private final ManagedDataListener listener = ManagedDataListenerFactory.getManagedDataListener();
    @Nonnull
    private final Class<? extends Item> type;

    public ItemManager(@Nonnull ReflectionManager reflectionManager, @Nonnull Class<? extends Item> type) {
        this.type = type;
        this.scan(reflectionManager);
    }

    @Override
    @Nonnull
    public Class<? extends Item> getType() {
        return this.type;
    }

    private void scan(@Nonnull ReflectionManager reflectionManager) {
        for (Class<? extends Item> item : reflectionManager.getSubTypesOf(this.type)) {
            if (!this.isToIgnore(item)) {
                ManagedItem ii = this.registerItem(item);
                this.logger.log(Level.INFO, "Register {0} ({1})", new Object[]{ii, item.getCanonicalName()});
                continue;
            }
            this.logger.log(Level.INFO, "Item ''{0}'' ({1}) is ignored because only for {2}", new Object[]{Items.getName(item), item.getCanonicalName(), this.onlyFor.getSimpleName()});
        }
        this.logger.log(Level.INFO, "Register {0} item(s) in {1} integer(s)", new Object[]{this.getItemsCount(), this.getIntegersCount()});
        for (Class<? extends Item> item : this.map.values()) {
            Class<? extends Item> cls = ((ManagedItem)((Object)item)).getItem();
            for (Class<?> sup : reflectionManager.getSuperTypesOf(cls)) {
                ManagedItem managedSup = (ManagedItem)this.map.get(sup);
                if (managedSup == null) continue;
                managedSup.addComposedOf((ManagedItem)((Object)item));
            }
        }
        for (Class<? extends Item> item : this.map.values()) {
            ((ManagedItem)((Object)item)).addComposedOf();
        }
        for (Class<? extends Item> item : this.map.values()) {
            this.listener.notifyNewManagedItem((ManagedItem)((Object)item));
            if (!this.logger.isLoggable(Level.FINER)) continue;
            ItemSet<? extends Item> set = new ItemSet<Item>(this);
            set.add(((ManagedItem)((Object)item)).getItem());
            this.logger.log(Level.FINER, "Item {0} is {1}", new Object[]{item, set});
        }
        this.listener.notifyNoMoreManagedItem(this.type);
    }

    private boolean isToIgnore(Class<? extends Item> item) {
        Class<? extends OnlyForType> onlyFor = Items.getOnlyForType(item);
        return onlyFor != Default.class && onlyFor != this.onlyFor;
    }
}

