/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.reflections;

import com.android.sched.reflections.CommonReflectionManager;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class CompositeReflectionManager
extends CommonReflectionManager
implements ReflectionManager {
    @Nonnull
    private final List<ReflectionManager> reflectionManagers;

    public CompositeReflectionManager() {
        this.reflectionManagers = new ArrayList<ReflectionManager>();
    }

    public CompositeReflectionManager(@Nonnull ReflectionManager reflectionManager) {
        this.reflectionManagers = new ArrayList<ReflectionManager>();
        this.reflectionManagers.add(reflectionManager);
    }

    public CompositeReflectionManager(@Nonnull ReflectionManager[] reflectionManagers) {
        this.reflectionManagers = Arrays.asList(reflectionManagers);
    }

    public CompositeReflectionManager(@Nonnull List<ReflectionManager> reflectionManagers) {
        this.reflectionManagers = reflectionManagers;
    }

    @Nonnull
    public synchronized CompositeReflectionManager addReflectionManager(@Nonnull ReflectionManager reflectionManager) {
        this.reflectionManagers.add(reflectionManager);
        return this;
    }

    @Override
    @Nonnull
    public synchronized <T> Set<Class<? extends T>> getSubTypesOf(@Nonnull Class<T> cls) {
        HashSet<Class<T>> set = new HashSet<Class<T>>();
        for (ReflectionManager reflectionManager : this.reflectionManagers) {
            set.addAll(reflectionManager.getSubTypesOf(cls));
        }
        return set;
    }

    @Override
    @Nonnull
    public synchronized <T> Set<ReflectionManager.ClassWithLocation<? extends T>> getSubTypesOfWithLocation(@Nonnull Class<T> cls) {
        HashSet<ReflectionManager.ClassWithLocation<T>> set = new HashSet<ReflectionManager.ClassWithLocation<T>>();
        for (ReflectionManager reflectionManager : this.reflectionManagers) {
            set.addAll(reflectionManager.getSubTypesOfWithLocation(cls));
        }
        return set;
    }

    @Override
    @Nonnull
    public <T extends Annotation> Set<Class<?>> getAnnotatedBy(@Nonnull Class<T> cls) {
        HashSet set = new HashSet();
        for (ReflectionManager reflectionManager : this.reflectionManagers) {
            set.addAll(reflectionManager.getAnnotatedBy(cls));
        }
        return set;
    }

    @Override
    @Nonnull
    public <T extends Annotation> Set<ReflectionManager.ClassWithLocation<?>> getAnnotatedByWithLocation(@Nonnull Class<T> cls) {
        HashSet set = new HashSet();
        for (ReflectionManager reflectionManager : this.reflectionManagers) {
            set.addAll(reflectionManager.getAnnotatedByWithLocation(cls));
        }
        return set;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return NoLocation.getInstance();
    }
}

