/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.build;

import com.android.sched.build.SchedDiscover;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;

public class JarMerger {
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(@Nonnull String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: in-jar-file-1 [in-jar-file-2 [...] [in-jar-file-n]] [out-jar-file]");
            System.err.println("  In case of entry collision, the first encountered is kept.");
            System.err.println("  Only META-INF directory from the first jar is kept.");
            System.exit(1);
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(args[args.length - 1]));
        HashSet<String> entries = new HashSet<String>();
        SchedDiscover data = new SchedDiscover();
        try {
            for (int idx = 0; idx < args.length - 1; ++idx) {
                File file = new File(args[idx]);
                try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file));){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        if (entry.getName().equals(data.getResourceName())) {
                            data.readResource(new BufferedReader(new InputStreamReader(zis)));
                            continue;
                        }
                        if (idx > 0 && entry.getName().startsWith("META-INF/")) continue;
                        String newName = entry.getName();
                        if (!entries.contains(newName)) {
                            entries.add(newName);
                            ZipEntry newEntry = new ZipEntry(newName);
                            newEntry.setTime(entry.getTime());
                            zos.putNextEntry(newEntry);
                            try {
                                byte[] buffer = new byte[4096];
                                int length = zis.read(buffer);
                                while (length > 0) {
                                    zos.write(buffer, 0, length);
                                    length = zis.read(buffer);
                                }
                                continue;
                            }
                            finally {
                                zos.closeEntry();
                                continue;
                            }
                        }
                        System.err.println("Warning: dropping duplicate entry '" + newName + "' found in '" + args[idx] + "'");
                    }
                    continue;
                }
            }
            zos.putNextEntry(new ZipEntry(data.getResourceName()));
            try {
                OutputStreamWriter writer = new OutputStreamWriter(zos);
                data.writeResource(writer);
                ((Writer)writer).flush();
            }
            finally {
                zos.closeEntry();
            }
        }
        finally {
            zos.close();
        }
        System.exit(0);
    }
}

