/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jill.JillException;
import com.android.jill.Options;
import com.android.jill.backend.jayce.JayceWriter;
import com.android.jill.frontend.java.ClassNodeWriter;
import com.android.jill.frontend.java.SourceInfoWriter;
import com.android.jill.utils.FileUtils;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.MessageDigestCodec;
import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.DeflateFS;
import com.android.sched.vfs.DirectFS;
import com.android.sched.vfs.GenericOutputVFS;
import com.android.sched.vfs.MessageDigestFS;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.PrefixedFS;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WriteZipFS;
import com.android.sched.vfs.WrongVFSFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class JavaTransformer {
    @Nonnull
    private static final String LIB_MAJOR_VERSION = "3";
    @Nonnull
    private static final String LIB_MINOR_VERSION = "3";
    @Nonnull
    private static final String JAYCE_MAJOR_VERSION = "4";
    @Nonnull
    private static final String JAYCE_MINOR_VERSION = "2";
    @Nonnull
    private static final String KEY_LIB_MAJOR_VERSION = "lib.version.major";
    @Nonnull
    private static final String KEY_LIB_MINOR_VERSION = "lib.version.minor";
    @Nonnull
    private static final String KEY_LIB_EMITTER = "lib.emitter";
    @Nonnull
    private static final String KEY_LIB_EMITTER_VERSION = "lib.emitter.version";
    @Nonnull
    private static final String KEY_JAYCE = "jayce";
    @Nonnull
    private static final String KEY_JAYCE_MAJOR_VERSION = "jayce.version.major";
    @Nonnull
    private static final String KEY_JAYCE_MINOR_VERSION = "jayce.version.minor";
    @Nonnull
    private static final String KEY_LIB_JAYCE_DIGEST = "lib.jayce.digest";
    @Nonnull
    private static final String JACK_LIBRARY_PROPERTIES = "jack.properties";
    @Nonnull
    private final String version;
    private final Options options;
    @Nonnull
    private static final String JAYCE_FILE_EXTENSION = ".jayce";
    @Nonnull
    private static final char TYPE_NAME_SEPARATOR = '/';
    @Nonnull
    private final Properties jackLibraryProperties;

    public JavaTransformer(@Nonnull String version, @Nonnull Options options) {
        this.version = version;
        this.options = options;
        this.jackLibraryProperties = new Properties();
        this.jackLibraryProperties.put(KEY_LIB_EMITTER, "jill");
        this.jackLibraryProperties.put(KEY_LIB_EMITTER_VERSION, version);
        this.jackLibraryProperties.put(KEY_LIB_MAJOR_VERSION, "3");
        this.jackLibraryProperties.put(KEY_LIB_MINOR_VERSION, "3");
        this.jackLibraryProperties.put(KEY_LIB_JAYCE_DIGEST, "true");
    }

    public void transform(@Nonnull List<File> javaBinaryFiles) {
        try (VFS baseVFS = this.getBaseOutputVFS();
             OutputVFS outputVFS = this.wrapOutputVFS(baseVFS);){
            for (File fileToTransform : javaBinaryFiles) {
                FileInputStream fis = new FileInputStream(fileToTransform);
                Throwable throwable = null;
                try {
                    this.transformToVFS(fis, outputVFS);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            this.dumpJackLibraryProperties(baseVFS);
        }
        catch (CannotCloseException | IOException e) {
            throw new JillException(e);
        }
    }

    public void transform(@Nonnull JarFile jarFile) {
        try (VFS baseVFS = this.getBaseOutputVFS();){
            try (OutputVFS outputVFS = this.wrapOutputVFS(baseVFS);){
                this.transformJavaFiles(jarFile, outputVFS);
            }
            this.dumpJackLibraryProperties(baseVFS);
        }
        catch (CannotCloseException | IOException e) {
            throw new JillException(e);
        }
    }

    @Nonnull
    private VFS getBaseOutputVFS() {
        BaseVFS baseVFS;
        try {
            switch (this.options.getOutputContainer()) {
                case DIR: {
                    baseVFS = new DirectFS(new Directory(this.options.getOutput().getPath(), null, FileOrDirectory.Existence.MUST_EXIST, 2, FileOrDirectory.ChangePermission.NOCHANGE), 2);
                    break;
                }
                case ZIP: {
                    baseVFS = new WriteZipFS(new OutputZipFile(this.options.getOutput().getPath(), null, FileOrDirectory.Existence.MAY_EXIST, FileOrDirectory.ChangePermission.NOCHANGE, OutputZipFile.Compression.UNCOMPRESSED));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | NotFileException | WrongPermissionException e) {
            throw new JillException(e);
        }
        return baseVFS;
    }

    @Nonnull
    private OutputVFS wrapOutputVFS(@Nonnull VFS baseVFS) {
        MessageDigestCodec mdCodec = new MessageDigestCodec();
        Provider.Service service = (Provider.Service)mdCodec.parseString(new CodecContext(), "SHA");
        try {
            return new GenericOutputVFS(new DeflateFS(new MessageDigestFS(new PrefixedFS(baseVFS, new VPath(KEY_JAYCE, '/')), new MessageDigestFactory(service))));
        }
        catch (CannotCreateFileException | NotDirectoryException | WrongVFSFormatException e) {
            throw new JillException(e);
        }
    }

    private void dumpJackLibraryProperties(@Nonnull VFS baseVFS) {
        try {
            GenericOutputVFS goVFS = new GenericOutputVFS(baseVFS);
            OutputVFile libraryPropertiesOut = goVFS.getRootOutputVDir().createOutputVFile(new VPath(JACK_LIBRARY_PROPERTIES, '/'));
            try (OutputStream os = libraryPropertiesOut.getOutputStream();){
                this.jackLibraryProperties.store(os, "Library Properties");
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)libraryPropertiesOut, (Exception)e);
            }
        }
        catch (CannotCloseException | CannotCreateFileException | WrongPermissionException e) {
            throw new JillException(e);
        }
    }

    private void transformJavaFiles(@Nonnull JarFile jarFile, @Nonnull OutputVFS outputVFS) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry fileEntry;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!FileUtils.isJavaBinaryFile(name) || (fileEntry = jarFile.getJarEntry(name)).isDirectory()) continue;
            InputStream is = jarFile.getInputStream(fileEntry);
            this.transformToVFS(is, outputVFS);
        }
    }

    private void transformToVFS(@Nonnull InputStream is, @Nonnull OutputVFS outputVFS) throws IOException {
        ClassNode cn = this.getClassNode(is);
        VPath outputPath = JavaTransformer.getVPath(cn.name);
        try {
            OutputVFile vFile = outputVFS.getRootOutputVDir().createOutputVFile(outputPath);
            try (OutputStream os = vFile.getOutputStream();){
                this.transform(cn, os, vFile.getLocation());
            }
            catch (IOException e) {
                throw new CannotCloseException(vFile.getLocation(), (Exception)e);
            }
        }
        catch (CannotCloseException | CannotCreateFileException | CannotWriteException | WrongPermissionException e) {
            throw new JillException(e);
        }
    }

    private void transform(@Nonnull ClassNode cn, @Nonnull OutputStream os, @Nonnull Location location) throws CannotWriteException {
        JayceWriter writer = this.createWriter(os);
        ClassNodeWriter asm2jayce = new ClassNodeWriter(writer, new SourceInfoWriter(writer), this.options);
        try {
            asm2jayce.write(cn);
            writer.flush();
        }
        catch (IOException e) {
            throw new CannotWriteException(location, (Throwable)e);
        }
    }

    private JayceWriter createWriter(@Nonnull OutputStream os) {
        JayceWriter writer = new JayceWriter(os);
        this.setJayceProperties();
        return writer;
    }

    @Nonnull
    private static VPath getVPath(@Nonnull String typeBinaryName) {
        return new VPath(typeBinaryName + JAYCE_FILE_EXTENSION, '/');
    }

    @Nonnull
    private ClassNode getClassNode(@Nonnull InputStream is) throws IOException {
        try {
            ClassReader cr = new ClassReader(is);
            ClassNode cn = new ClassNode();
            cr.accept(cn, 4 | (this.options.isEmitDebugInfo() ? 0 : 2));
            return cn;
        }
        catch (IllegalArgumentException e) {
            throw new JillException("class files coming from an unsupported Java version", e);
        }
    }

    private void setJayceProperties() {
        this.jackLibraryProperties.put(KEY_JAYCE, String.valueOf(true));
        this.jackLibraryProperties.put(KEY_JAYCE_MAJOR_VERSION, JAYCE_MAJOR_VERSION);
        this.jackLibraryProperties.put(KEY_JAYCE_MINOR_VERSION, JAYCE_MINOR_VERSION);
    }
}

