// feszer:  An msvcrt.dll pass-through/logger thing.
//

#include "stdafx.h"

#define ALLOW_LOG_ALL
#define ALLOW_LOG_ALL_PROC

DWORD dwTlsIndex;
DWORD retLoc;
HMODULE hMod;

#define DIRSIZE 1024

char LogDir[DIRSIZE];

CRITICAL_SECTION s_log;

void GetAddresses(void);
void __cdecl log_bufsizfmt(const char * fnc, char * out_buf, size_t out_buf_siz, const char * out_fmt);
void __cdecl log_buffmt(const char * fnc, char * out_buf, const char * out_fmt);
void __cdecl log_fmt(const char * fnc, const char * out_fmt);
void __cdecl log_buf(const char * fnc, char * out_buf);
void __cdecl log_bufinp(const char * fnc, char * out_buf, const char * in_buf);
void __cdecl wlog_bufsizfmt(const char * fnc, wchar_t * out_buf, size_t out_buf_siz, const wchar_t * out_fmt);
void __cdecl wlog_buffmt(const char * fnc, wchar_t * out_buf, const wchar_t * out_fmt);
void __cdecl wlog_fmt(const char * fnc, const wchar_t * out_fmt);
void __cdecl wlog_buf(const char * fnc, wchar_t * out_buf);
void __cdecl wlog_bufinp(const char * fnc, wchar_t * out_buf, const wchar_t * in_buf);

typedef unsigned long FILE;

FARPROC old_fprintf = NULL;
FARPROC old_printf = NULL;
FARPROC old__snprintf = NULL;
FARPROC old_sprintf = NULL;
FARPROC old_vfprintf = NULL;
FARPROC old_vprintf = NULL;
FARPROC old__vsnprintf = NULL;
FARPROC old_vsprintf = NULL;
FARPROC old_fwprintf = NULL;
FARPROC old_wprintf = NULL;
FARPROC old__snwprintf = NULL;
FARPROC old_swprintf = NULL;
FARPROC old_vfwprintf = NULL;
FARPROC old_vwprintf = NULL;
FARPROC old__vsnwprintf = NULL;
FARPROC old_vswprintf = NULL;
FARPROC old_strcpy = NULL;
FARPROC old_strcat = NULL;
FARPROC old_wcscat = NULL;
FARPROC old_wcscpy = NULL;
FARPROC old_system = NULL;

extern "C"
{
_CRTIMP int __cdecl fprintf(FILE *, const char *, ...);
_CRTIMP int __cdecl printf(const char *, ...);
_CRTIMP int __cdecl _snprintf(char *, size_t, const char *, ...);
_CRTIMP int __cdecl sprintf(char *, const char *, ...);
_CRTIMP int __cdecl vfprintf(FILE *, const char *, va_list);
_CRTIMP int __cdecl vprintf(const char *, va_list);
_CRTIMP int __cdecl _vsnprintf(char *, size_t, const char *, va_list);
_CRTIMP int __cdecl vsprintf(char *, const char *, va_list);
_CRTIMP int __cdecl fwprintf(FILE *, const wchar_t *, ...);
_CRTIMP int __cdecl wprintf(const wchar_t *, ...);
_CRTIMP int __cdecl _snwprintf(wchar_t *, size_t, const wchar_t *, ...);
_CRTIMP int __cdecl swprintf(wchar_t *, const wchar_t *, ...);
_CRTIMP int __cdecl vfwprintf(FILE *, const wchar_t *, va_list);
_CRTIMP int __cdecl vwprintf(const wchar_t *, va_list);
_CRTIMP int __cdecl _vsnwprintf(wchar_t *, size_t, const wchar_t *, va_list);
_CRTIMP int __cdecl vswprintf(wchar_t *, const wchar_t *, va_list);
_CRTIMP char *  __cdecl _strcpy(char *, const char *);
_CRTIMP char *  __cdecl _strcat(char *, const char *);
_CRTIMP wchar_t * __cdecl _wcscat(wchar_t *, const wchar_t *);
_CRTIMP wchar_t * __cdecl _wcscpy(wchar_t *, const wchar_t *);
_CRTIMP int    __cdecl system(const char *);
}

BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
  switch(ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
      hMod = LoadLibrary("fescrt.dll");
      GetAddresses();
      InitializeCriticalSection(&s_log);
      dwTlsIndex = TlsAlloc();
      memset(LogDir, 0, DIRSIZE);
      break;
		case DLL_THREAD_ATTACH:
      break;
		case DLL_THREAD_DETACH:
      break;
		case DLL_PROCESS_DETACH:
      DeleteCriticalSection(&s_log);
      TlsFree(dwTlsIndex);
      FreeLibrary(hMod);
			break;
  }
  return TRUE;
}

void GetAddresses(void)
{
  HMODULE h;

  h = GetModuleHandle("fescrt.dll");
  old_fprintf = GetProcAddress(h, "fprintf");
  old_printf = GetProcAddress(h, "printf");
  old__snprintf = GetProcAddress(h, "_snprintf");
  old_sprintf = GetProcAddress(h, "sprintf");
  old_vfprintf = GetProcAddress(h, "vfpprintf");
  old_vprintf = GetProcAddress(h, "vprintf");
  old__vsnprintf = GetProcAddress(h, "_vsnprintf");
  old_vsprintf = GetProcAddress(h, "vsprintf");
  old_fwprintf = GetProcAddress(h, "fwprintf");
  old_wprintf = GetProcAddress(h, "wprintf");
  old__snwprintf = GetProcAddress(h, "_snwprintf");
  old_swprintf = GetProcAddress(h, "swprintf");
  old_vfwprintf = GetProcAddress(h, "vfwprintf");
  old_vwprintf = GetProcAddress(h, "vwprintf");
  old__vsnwprintf = GetProcAddress(h, "_vsnwprintf");
  old_vswprintf = GetProcAddress(h, "vswprintf");
  old_strcpy = GetProcAddress(h, "strcpy");
  old_strcat = GetProcAddress(h, "strcat");
  old_wcscat = GetProcAddress(h, "wcscat");
  old_wcscpy = GetProcAddress(h, "wcscpy");
  old_system = GetProcAddress(h, "system");
}

__declspec(naked) _CRTIMP int __cdecl local__snprintf(char *, size_t, const char *, ...)
{
  __asm
  {
    mov eax,old__snprintf
    jmp eax
  }
}

int __cdecl GetLogPath(char * buf, int len)
{
  char g_szRegPath[] = "Software\\feszer";
  int result = 0;
  unsigned long mylen = (unsigned long) len;

  HKEY hKey;
  if(RegOpenKey(HKEY_LOCAL_MACHINE, g_szRegPath, &hKey) == ERROR_SUCCESS)
  {
    DWORD dType;

    if(RegQueryValueEx(hKey, "LogDir", 0, &dType, (PBYTE)buf, &mylen) == ERROR_SUCCESS)
    {
      buf[len - 1] = 0;
      result = 1;
    }
    RegCloseKey(hKey);
  }
  if(!result)
  {
    GetTempPath(len, buf);
  }
  if(strcmp(LogDir, buf))
  {
    int len = strlen(buf);
    if(len >= DIRSIZE)
      len = DIRSIZE - 1;
    memcpy(LogDir, buf, len);
    LogDir[len] = 0;
    CreateDirectory(buf, NULL);
  }
  return result;
}

int __cdecl ShouldLogAll(void)
{
  char g_szRegPath[] = "Software\\feszer";
  int result = 0;

  HKEY hKey;
  if(RegOpenKey(HKEY_LOCAL_MACHINE, g_szRegPath, &hKey) == ERROR_SUCCESS)
  {
    DWORD dwValue = 0;
    DWORD dType, cbValue = sizeof(dwValue);

    if(RegQueryValueEx(hKey, "LogAll", 0, &dType, (PBYTE)&dwValue, &cbValue) == ERROR_SUCCESS)
    {
      if(dwValue)
        result = 1;
    }
    RegCloseKey(hKey);
  }
  return result;
}

int __cdecl ShouldLogAllProc(char * procName)
{
  char g_szRegPath[] = "Software\\feszer\\Globals";
  int result = 0;

  HKEY hKey;
  if(RegOpenKey(HKEY_LOCAL_MACHINE, g_szRegPath, &hKey) == ERROR_SUCCESS)
  {
    DWORD dwValue = 0;
    DWORD dType, cbValue = sizeof(dwValue);

    if(RegQueryValueEx(hKey, procName, 0, &dType, (PBYTE)&dwValue, &cbValue) == ERROR_SUCCESS)
    {
      if(dwValue)
        result = 1;
    }
    RegCloseKey(hKey);
  }
  return result;
}

int __cdecl ShouldLog(char * procName)
{
  char szExeName[1024];
  char szRegPath[2048];
  char * cptr;
  char g_szRegPath[] = "Software\\feszer\\Programs";
  int result = 0;

#ifdef ALLOW_LOG_ALL
  if(ShouldLogAll())
  {
    return 1;
  }
#endif
#ifdef ALLOW_LOG_ALL_PROC
  if(ShouldLogAllProc(procName))
  {
    return 1;
  }
#endif
  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;

  HKEY hKey;
  local__snprintf(szRegPath, 2048, "%s\\%s", g_szRegPath, cptr);
  if(RegOpenKey(HKEY_LOCAL_MACHINE, szRegPath, &hKey) == ERROR_SUCCESS)
  {
    DWORD dwValue = 0;
    DWORD dType, cbValue = sizeof(dwValue);

    if(RegQueryValueEx(hKey, procName, 0, &dType, (PBYTE)&dwValue, &cbValue) == ERROR_SUCCESS)
    {
      if(dwValue)
        result = 1;
    }
    RegCloseKey(hKey);
  }
  return result;
}

__declspec(naked) _CRTIMP int __cdecl fprintf(FILE *, const char * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("fprintf"))
    log_fmt("fprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_fprintf]
  }
}

__declspec(naked) _CRTIMP int __cdecl printf(const char * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("printf"))
    log_fmt("printf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_printf]
  }
}

__declspec(naked) _CRTIMP int __cdecl _snprintf(char * out_buf, size_t out_buf_siz, const char * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("_snprintf"))
  {
    log_bufsizfmt("_snprintf", out_buf, out_buf_siz, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old__snprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    log_buf("_snprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old__snprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl sprintf(char * out_buf, const char * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("sprintf"))
  {
    log_buffmt("sprintf", out_buf, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old_sprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    log_buf("sprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old_sprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl vfprintf(FILE *, const char * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("vfprintf"))
    log_fmt("vfprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_vfprintf]
  }
}


__declspec(naked) _CRTIMP int __cdecl vprintf(const char * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("vprintf"))
    log_fmt("vprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_vprintf]
  }
}

__declspec(naked) _CRTIMP int __cdecl _vsnprintf(char * out_buf, size_t out_siz, const char * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("_vsnprintf"))
  {
    log_bufsizfmt("_vsnprintf", out_buf, out_siz, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old__vsnprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    log_buf("_vsnprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old__vsnprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl vsprintf(char * out_buf, const char * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("vsprintf"))
  {
    log_buffmt("vsprintf", out_buf, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old_vsprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    log_buf("vsprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old_vsprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl fwprintf(FILE *, const wchar_t * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("fwprintf"))
    wlog_fmt("fwprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_fwprintf]
  }
}

__declspec(naked) _CRTIMP int __cdecl wprintf(const wchar_t * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("wprintf"))
    wlog_fmt("wprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_wprintf]
  }
}

__declspec(naked) _CRTIMP int __cdecl _snwprintf(wchar_t * out_buf, size_t out_buf_siz, const wchar_t * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("_snwprintf"))
  {
    wlog_bufsizfmt("_snwprintf", out_buf, out_buf_siz, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old__snwprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    wlog_buf("_snwprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old__snwprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl swprintf(wchar_t * out_buf, const wchar_t * out_fmt, ...)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("swprintf"))
  {
    wlog_buffmt("swprintf", out_buf, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old_swprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    wlog_buf("swprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old_swprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl vfwprintf(FILE *, const wchar_t * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("vfwprintf"))
    wlog_fmt("vfwprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_vfwprintf]
  }
}

__declspec(naked) _CRTIMP int __cdecl vwprintf(const wchar_t * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("vwprintf"))
    wlog_fmt("vwprintf", out_fmt);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_vwprintf]
  }
}

__declspec(naked) _CRTIMP int __cdecl _vsnwprintf(wchar_t * out_buf, size_t out_buf_siz, const wchar_t * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("_vsnwprintf"))
  {
    wlog_bufsizfmt("_vsnwprintf", out_buf, out_buf_siz, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old__vsnwprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    wlog_buf("_vsnwprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old__vsnwprintf]
    }
  }
}

__declspec(naked) _CRTIMP int __cdecl vswprintf(wchar_t * out_buf, const wchar_t * out_fmt, va_list)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("vswprintf"))
  {
    wlog_buffmt("vswprintf", out_buf, out_fmt);
    __asm
    {
      push dword ptr [ebp + 4]
      push dwTlsIndex
      call dword ptr [TlsSetValue]
      call whereami
whereami:
      pop eax
      add eax, 0fh
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      jmp dword ptr [old_vswprintf]
      push 0x41414141 // Alignment (eip) and also for return addr
      push ebp
      mov ebp, esp
      pushad
    }
    wlog_buf("vswprintf", out_buf);
    __asm
    {
      push dwTlsIndex
      call dword ptr [TlsGetValue]
      mov dword ptr [ebp + 4], eax
      popad
      pop ebp
      ret
    }
  }
  else
  {
    __asm
    {
      popad
      pop ebp
      jmp dword ptr [old_vswprintf]
    }
  }
}

__declspec(naked) char *  __cdecl _strcpy(char * out_buf, const char * in_buf)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("strcpy"))
    log_bufinp("strcpy", out_buf, in_buf);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_strcpy]
  }
}

__declspec(naked) char *  __cdecl _strcat(char * out_buf, const char * in_buf)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("strcat"))
    log_bufinp("strcat", out_buf, in_buf);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_strcat]
  }
}

__declspec(naked) wchar_t * __cdecl _wcscat(wchar_t * out_buf, const wchar_t * in_buf)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("wcscat"))
    wlog_bufinp("wcscat", out_buf, in_buf);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_wcscat]
  }
}

__declspec(naked) wchar_t * __cdecl _wcscpy(wchar_t * out_buf, const wchar_t * in_buf)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("wcscpy"))
    wlog_bufinp("wcscpy", out_buf, in_buf);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_wcscpy]
  }
}

__declspec(naked) _CRTIMP int __cdecl system(const char * in_buf)
{
  __asm
  {
    push ebp
    mov ebp, esp
    pushad
  }
  if(ShouldLog("system"))
    log_buf("system", (char *) in_buf);
  __asm
  {
    popad
    pop ebp
    jmp dword ptr [old_system]
  }
}



void __cdecl log_bufsizfmt(const char * fnc, char * out_buf, size_t out_buf_siz, const char * out_fmt)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Output Address: 0x%08x, Size: %lu, Format String: %s\r\n",
      cptr, fnc, out_buf, out_buf_siz, out_fmt);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl log_buffmt(const char * fnc, char * out_buf, const char * out_fmt)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Output Address: 0x%08x, Format String: %s\r\n",
      cptr, fnc, out_buf, out_fmt);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl log_fmt(const char * fnc, const char * out_fmt)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Format String: %s\r\n",
      cptr, fnc, out_fmt);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl log_buf(const char * fnc, char * out_buf)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Buffer Contents: %s\r\n",
      cptr, fnc, out_buf);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl log_bufinp(const char * fnc, char * out_buf, const char * in_buf)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Output Address: 0x%08x, Input Buffer: %s\r\n",
      cptr, fnc, out_buf, in_buf);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl wlog_bufsizfmt(const char * fnc, wchar_t * out_buf, size_t out_buf_siz, const wchar_t * out_fmt)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Output Address: 0x%08x, Size: %lu, Format String: %S\r\n",
      cptr, fnc, out_buf, out_buf_siz, out_fmt);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl wlog_buffmt(const char * fnc, wchar_t * out_buf, const wchar_t * out_fmt)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Output Address: 0x%08x, Format String: %S\r\n",
      cptr, fnc, out_buf, out_fmt);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl wlog_fmt(const char * fnc, const wchar_t * out_fmt)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Format String: %S\r\n",
      cptr, fnc, out_fmt);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl wlog_buf(const char * fnc, wchar_t * out_buf)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Buffer Contents: %S\r\n",
      cptr, fnc, out_buf);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}

void __cdecl wlog_bufinp(const char * fnc, wchar_t * out_buf, const wchar_t * in_buf)
{
  HANDLE hFile = NULL;
  char szExeName[1024];
  char szTmpPathName[1024];
  char szTmpFileName[1024];
  char * cptr;
  DWORD numwritten;

  GetModuleFileName(0, szExeName, sizeof(szExeName));
  CharUpperBuff(szExeName, lstrlen(szExeName));
  cptr = szExeName + lstrlen(szExeName) - 1;
  while((cptr > szExeName) && (*cptr != '\\'))
    cptr--;
  if(*cptr == '\\')
    cptr++;
  GetLogPath(szTmpPathName, 1024);
  local__snprintf(szTmpFileName, 1024, "%s\\%s.txt", szTmpPathName, cptr);
  szTmpFileName[1023] = 0;
  hFile = CreateFile(szTmpFileName, GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);
  if(hFile)
  {
    local__snprintf(szTmpFileName, 1024, "%s (%s):  Output Address: 0x%08x, Input Buffer: %S\r\n",
      cptr, fnc, out_buf, in_buf);
    szTmpFileName[1023] = 0;
    SetFilePointer(hFile, 0, 0, FILE_END);
    WriteFile(hFile, szTmpFileName, strlen(szTmpFileName), &numwritten, 0);
    CloseHandle(hFile);
  }
}
