#include "AUSTIN_NetLib.h"

//Err						errno;
//UInt16					AppNetRefnum;

/********************************************************************
 * Internally used routines
 ********************************************************************/
static PocketCLibGlobalsPtr PrvMakeGlobals(UInt refNum);
static PocketCLibGlobalsPtr PrvLockGlobals(UInt refNum);

/********************************************************************
 * Internally used macros
 ********************************************************************/

// Unlock globals
#define PrvUnlockGlobals(gP)	MemPtrUnlock(gP)

/********************************************************************
 * Open routine - add global initialization code
 ********************************************************************/

PocketCLibGlobalsPtr PocketCLibOpen(UInt refNum, DWordPtr) {
	PocketCLibGlobalsPtr gP;
	Err err = 0;

	gP = PrvMakeGlobals(refNum);
	
	// NOTE: You CANNOT call the global routines (e.g. pop() ) at this point!
	//
	// TODO: Initialize globals
	//
	
	// NOTE: PocketC will fill the structure and then _unlock_ it
	return gP;
}

/********************************************************************
 * Close routine - add global cleanup code 
 ********************************************************************/

Err PocketCLibClose(UInt refNum, DWord) {
	VoidHand gH;
	SysLibTblEntryPtr libEntryP;

	libEntryP = SysLibTblEntry(refNum);
	ErrFatalDisplayIf(libEntryP == NULL, "invalid PocketC lib refNum");

	gH = (VoidHand)(libEntryP->globalsP);
	if (gH) {
		
		//
		// TODO: Insert cleanup routines here (if necessary)
		//
		
		libEntryP->globalsP = NULL;
		MemHandleFree(gH);
	}
	
	return 0;
}

/********************************************************************
 * AddFunctions routine - add your libraries custom functions here
 ********************************************************************/

Err PocketCLibAddFunctions(UInt refNum) {
	PocketCLibGlobalsPtr gP;
	
	gP = PrvLockGlobals(refNum);
	
	//
	// TODO: Add library functions here
	//
	gP->addLibFunc("netLibInit", 0);
	gP->addLibFunc("netLibVersion", 0);
	gP->addLibFunc("netTCPConnect", 2, vtString, vtInt);
	gP->addLibFunc("netSocketClose", 1, vtInt);
	gP->addLibFunc("netSocketReceive", 5, vtInt, vtInt, vtInt, vtInt, vtInt);
	gP->addLibFunc("netSocketSend", 5, vtInt, vtString, vtInt, vtInt, vtInt);
	gP->addLibFunc("netLibClose", 0);
	gP->addLibFunc("netSetTimeout", 1, vtInt);
	gP->addLibFunc("netGetError", 0);
	gP->addLibFunc("netSocketOpen", 2, vtInt, vtInt);
	gP->addLibFunc("netSocketConnect", 4, vtInt, vtString, vtInt, vtInt);	

	PrvUnlockGlobals(gP);
	return 0;
}

/********************************************************************
 * helper functions
 ********************************************************************/

void makeString(Value *strP, Byte *buf, int bytes) {
	String *pString;
	int i;
	
	// check if string sVal is a MemPtr or a MemHandle
	if (0x80000000 & (UInt32)strP->sVal) { 
		// it's a MemHandle : need to resize the old handle
		MemHandleResize(strP->sVal,sizeof(String)+bytes+1); //change handle size 
		pString = (String*)MemHandleLock(strP->sVal); //lock handle
	}
	else {
		// it's a MemPtr : need to allocate a new handle
		strP->sVal = MemHandleNew(sizeof(String)+bytes+1); //change handle size 
		pString = (String*)MemHandleLock(strP->sVal); //lock handle
		pString->sType = stIndirect; //set type of string (currently unused)
		pString->nRef = 1; //for string garbage collection
	}
	
	// copy data into string
	for (i = 0; i < bytes; i++) pString->data[i] = buf[i];
	// set terminator
	pString->data[bytes] = 0;
	MemHandleUnlock(strP->sVal); //unlock handle
}	


/********************************************************************
 * Functions exposed to PocketC applets
 ********************************************************************/

// initializes network library
void netLibInit(PocketCLibGlobalsPtr gP) {
	UInt16 err;
	
	err = SysLibFind("Net.lib", &AppNetRefnum);
	if (!err) err = NetLibOpen(AppNetRefnum, &(gP->error));
	gP->retVal->iVal = err;
}


// returns NetLib's version number
void netLibVersion(PocketCLibGlobalsPtr gP) {
	UInt16 err;
	UInt32 version;
	
	err = FtrGet(netFtrCreator, netFtrNumVersion, &version);
	if (err) {
		gP->retVal->iVal = -1; //BUGBUG
	}
	gP->retVal->iVal = version;
}


#define NET_SOCK_STREAM		0
#define	NET_SOCK_DGRAM		1
#define	NET_SOCK_RAW		2
#define	NET_SOCK_ICMP		3

// open a socket (equivalent to socket() call)
// int netSocketOpen(int type, int *error)
// return the socket number or -1 if an error occured
void netSocketOpen(PocketCLibGlobalsPtr gP) {
	Value vType, vErrorPtr, *errP;
	NetSocketRef socket;
	
	// get parameters
	gP->pop(vErrorPtr);
	gP->pop(vType);
	
	// dereference the error ptr
	errP = gP->deref(vErrorPtr.iVal);

	// open a new socket
	switch (vType.iVal) {
		case NET_SOCK_STREAM:
			socket = NetLibSocketOpen(AppNetRefnum, AF_INET, SOCK_STREAM, netSocketProtoIPTCP, gP->timeout, &(gP->error));
			break;
		case NET_SOCK_DGRAM:
			socket = NetLibSocketOpen(AppNetRefnum, AF_INET, SOCK_DGRAM, netSocketProtoIPUDP, gP->timeout, &(gP->error));
			break;
		case NET_SOCK_RAW:
			socket = NetLibSocketOpen(AppNetRefnum, AF_INET, SOCK_RAW, netSocketProtoIPRAW, gP->timeout, &(gP->error));
			break;
		case NET_SOCK_ICMP:
			socket = NetLibSocketOpen(AppNetRefnum, AF_INET, SOCK_RAW, netSocketProtoIPICMP, gP->timeout, &(gP->error));
			break;
		default:
			gP->error = ERR_INVALID_SOCKET_TYPE;
	}
	// socket and the error number
	errP->iVal = gP->error;
	gP->retVal->iVal = socket;
	
}

// connect to a host on a specific port (equivalent of connect() call)
// int netSocketConnect(int socket, string host, int port, pointer error)
// return 0 for success, -1 for failure
void netSocketConnect(PocketCLibGlobalsPtr gP) {
	Value vSock, vHost, vPort, vErrorPtr, *errP;
	char *host, *addr;
	Int16 result, n;
	NetHostInfoBufType apphostinfo;
	struct hostent *hp;
	struct sockaddr_in socketaddr;
	unsigned long inaddr;
	
	// get parameters
	gP->pop(vErrorPtr);
	gP->pop(vPort);
	gP->pop(vHost);
	gP->pop(vSock);
	
	// dereference the error ptr
	errP = gP->deref(vErrorPtr.iVal);

	// get the host address
	host =  (char *) MemHandleLock(vHost.sVal);
	
	// not really necessary but this makes the structures a little cleaner to look at under the debugger ;-)
	bzero((char *) &socketaddr, sizeof(socketaddr));
	bzero((char *) &apphostinfo, sizeof(apphostinfo));

	// set family and port
	socketaddr.sin_family = AF_INET;
	socketaddr.sin_port = htons(vPort.iVal);
	
	// process the hostname, is is already an IP address?
	if ((inaddr = inet_addr(host)) != INADDR_NONE) {
		bcopy((char *) &inaddr, (char *) &socketaddr.sin_addr, sizeof(inaddr));
	} else {
	// it's a hostname that we need to resolve
		hp = (struct hostent*) NetLibGetHostByName(AppNetRefnum, host, &apphostinfo, gP->timeout, &(gP->error));
/*asm("
dc.w	20040
"); */
		if (hp == NULL) {
			gP->retVal->iVal = -2;
			goto cleanup;
		}
		// FIXME: this is kludge but I couldn't find another solution...
		// if only one IP is returned, then hp->h_addr_list[0] points to its address
		// however when multiple IPs are returned, hp->h_addr_list[0] sometimes points to 0x0
		// so we count the number of IPs and take the second one if there is one
		// weird, could this be an artefact of the emulator under debug ROMs?
		for (n = 0; hp->h_addr_list[n]; n++);
		if (n == 1) bcopy((char *) hp->h_addr_list[0], (char *) &socketaddr.sin_addr, hp->h_length);
		else bcopy((char *) hp->h_addr_list[1], (char *) &socketaddr.sin_addr, hp->h_length);
	}
	
//	result = NetLibSocketConnect(AppNetRefnum, vSock.iVal, (NetSocketAddrType*) &socketaddr, sizeof(socketaddr), AppNetTimeout, &(gP->error));
	result = connect(vSock.iVal, &socketaddr, sizeof(socketaddr));
	gP->retVal->iVal = result;

cleanup:
	// clean up
	errP->iVal = gP->error;
	MemHandleUnlock(vHost.sVal);
	gP->cleanup(vHost);
}

// connects to a specific host/port
// returns socket number, or -1 if failure
void netTCPConnect(PocketCLibGlobalsPtr gP) {
	Value vHost, vPort;
	char *pHost;
	NetSocketRef sock;
	
	gP->pop(vPort);
	gP->pop(vHost);
	
	pHost = (char *) MemHandleLock(vHost.sVal);
	sock = NetUTCPOpen (pHost, NULL, vPort.iVal);
	MemHandleUnlock(vHost.sVal);
	
	gP->cleanup(vHost);
	gP->retVal->iVal = sock;
}


// closes the socket
void netSocketClose(PocketCLibGlobalsPtr gP) {
	Value vSocket;
	Int16 res;
	Err error;
	
	gP->pop(vSocket);
	res = NetLibSocketClose(AppNetRefnum, vSocket.iVal, 200, &error);
	if (res == 0) gP->retVal->iVal = 0;
	else gP->retVal->iVal = error;
}

// reads at most n bytes with t timeout from socket
void netSocketReceive(PocketCLibGlobalsPtr gP) {
	Value vSocket, vStringPtr, vBytesToRead, vFlags, vErrorPtr, *strP, *errP;
	Int16 bytes, bytestoread;
	
	// get parameters
	gP->pop(vErrorPtr);
	gP->pop(vFlags);
	gP->pop(vBytesToRead);
	gP->pop(vStringPtr);
	gP->pop(vSocket);
	
	// dereference the error ptr
	errP = gP->deref(vErrorPtr.iVal);

	// dereference the string ptr	
	strP = gP->deref(vStringPtr.iVal);
	
	// set number of bytes to read
	bytestoread = (vBytesToRead.iVal < BUFFER_LEN) ? vBytesToRead.iVal : BUFFER_LEN-1;
	
	// read data
	bytes = NetLibReceive(AppNetRefnum, vSocket.iVal, gP->buffer, bytestoread, vFlags.iVal, 0, 0, gP->timeout, &(gP->error));

	// set bytes read and the error number
	errP->iVal = gP->error;
	gP->retVal->iVal = bytes;
	
	// if we got an error or just didn't read anything, we return
	if (bytes == -1 || bytes == 0) return;
	
	// otherwise set the string pointer with the buffer's contents
	makeString(strP, gP->buffer, bytes);
}


// sends data via socket
// int netSocketSend(int socket, string data, int length, int flags, pointer error)
// returns number of bytes sent
void netSocketSend(PocketCLibGlobalsPtr gP) {
	Value vSocket, vString, vLength, vFlags, vErrorPtr, *errP;
	char *buf;
	Int16 bytes;
	
	// get parameters
	gP->pop(vErrorPtr);
	gP->pop(vFlags);
	gP->pop(vLength);
	gP->pop(vString);
	gP->pop(vSocket);

	// dereference the error ptr
	errP = gP->deref(vErrorPtr.iVal);
	
	// lock string before modification	
	buf = (char *) MemHandleLock(vString.sVal);
	
	// send data, capture number of bytes sent
	bytes = NetLibSend(AppNetRefnum, vSocket.iVal, buf, vLength.iVal, vFlags.iVal, 0, 0, gP->timeout, &(gP->error));
	
	// cleanup
	MemHandleUnlock(vString.sVal);
	gP->cleanup(vString);
	
	// return number of bytes sent, set error ptr
	gP->retVal->iVal = bytes;
	errP->iVal = gP->error;
}


// closes network library
void netLibClose(PocketCLibGlobalsPtr gP) {
	UInt16 err;
		
	err = NetLibClose(AppNetRefnum, false);
}


// sets the network timeout used in the other calls
// void netSetTimeout(int timeout)
void netSetTimeout(PocketCLibGlobalsPtr gP) {
	Value vTimeout;
	Err error;
	
	gP->pop(vTimeout);
	gP->timeout = vTimeout.iVal;
}

void netGetError(PocketCLibGlobalsPtr gP) {
	// return error value
	gP->retVal->iVal = gP->error;
}



/********************************************************************
 * ExecuteFunction routine - call your library functions from here
 ********************************************************************/
Err PocketCLibExecuteFunction(UInt refNum, int funcNum) {
	PocketCLibGlobalsPtr gP;
	
	gP = PrvLockGlobals(refNum);
	
	switch (funcNum) {
		case  0: netLibInit(gP); break;
		case  1: netLibVersion(gP); break;
		case  2: netTCPConnect(gP); break;
		case  3: netSocketClose(gP); break;
		case  4: netSocketReceive(gP); break;
		case  5: netSocketSend(gP); break;
		case  6: netLibClose(gP); break;
		case  7: netSetTimeout(gP); break;
		case  8: netGetError(gP); break;
		case  9: netSocketOpen(gP); break;
		case 10: netSocketConnect(gP); break;
	};
	
	PrvUnlockGlobals(gP);
	return 0;
}

/********************************************************************
 * Sleep/Wake routines - don't modify these
 ********************************************************************/

Err PocketCLibSleep(UInt refNum) {
	return 0;
}

Err PocketCLibWake(UInt refNum) {
	return 0;
}

/********************************************************************
 * MakeGlobals - no modificcations needed
 ********************************************************************/

static PocketCLibGlobalsPtr PrvMakeGlobals(UInt refNum)
{
	PocketCLibGlobalsPtr gP = NULL;
	VoidHand	 gH;
	SysLibTblEntryPtr libEntryP;

	// Get library globals
	libEntryP = SysLibTblEntry(refNum);
	ErrFatalDisplayIf(libEntryP == NULL, "invalid PocketC lib refNum");

	// Allocate and initialize our library globals.
	gH = MemHandleNew(sizeof(PocketCLibGlobalsType));
	if (!gH) return NULL;

	libEntryP->globalsP = (void*)gH;
	gP = PrvLockGlobals(refNum);
	
	// Initialize our library globals
	MemSet(gP, sizeof(PocketCLibGlobalsType), 0);

	return gP;
}

/********************************************************************
 * LockGlobals - no modificcations needed
 ********************************************************************/

static PocketCLibGlobalsPtr PrvLockGlobals(UInt refNum) {
	PocketCLibGlobalsPtr gP = NULL;
	VoidHand gH;
	SysLibTblEntryPtr libEntryP;

	libEntryP = SysLibTblEntry(refNum);
	if (libEntryP) gH = (VoidHand)(libEntryP->globalsP);
	if (gH) gP = (PocketCLibGlobalsPtr)MemHandleLock(gH);

	return gP;
}


