/$ Write.h

/*
AUSTIN - A Palm OS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Library to write strings to screen and/or memo

#ifndef	WRITE_H
#define	WRITE_H

//#include "pcLib"

#define	WRITESCREEN		1
#define	WRITEMEMO		2
#define	WRITEBOTH		3
#define	NEWMEMO			1
#define	OPENMEMO		2

// whether we're writing to screen, memo, or both
int _mode = NULL,
	_mmtype = NULL,
	_readytowrite = false;

// unless this is set to true, all write calls are ignored
int _enablewrite = false;

string _title;

@doc "Close the memo and return to initial state.";
closeWrite() {
  if (_mode & WRITEMEMO) mmclose();
  _mode = NULL;
}

@doc "Initialize the Write.h module.";
initWrite(string memotitle, int mode, int mmtype) {
  if (_mode != NULL) closeWrite();
  _mode = mode;
  _title = memotitle;
  _mmtype = mmtype;
}

@doc "Creates or opens the memo for writing (internal func).";
_initWrite() {
	if (_mode & WRITEMEMO) {
		if (_mmtype == NEWMEMO) {
			mmnew();
			mmputs(_title + "\n");
			_readytowrite = true;
		} else if (_mmtype == OPENMEMO){
			if (mmfind(_title) == 0) alert("Write.h: Couldn't find memo: " + _title);
			else _readytowrite = true;
		}
	} else {
		_readytowrite = true;
	}
}

@doc "Enable the writing of messages.";
enableWrite() {
	_enablewrite = true;
}

@doc "Disable the writing of messages.";
disableWrite() {
	_enablewrite = false;
}

@doc "Write a string to screen and/or memo.";
write(string s) {
	if (! _enablewrite) return;
	if (! _readytowrite) _initWrite();
	if (_mode & WRITESCREEN) puts(s);
	if (_mode & WRITEMEMO) mmputs(s);
}

@doc "Write a string ending with a line feed.";
writeln(string s) {
  write(s + "\n");
}

#endif
