/$ Util.h

/*
AUSTIN - A PalmOS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Utility library for AUSTIN

@doc "Displays an alert panel with the string s, used for debugging.";
psDebug(string s) {
	alert(s);
}

@doc "Given a url such as \"http://a.b.c/\", returns \"a.b.c\".";
string hostName(string url) {
	url = strright(url, strlen(url)-7);
	return strleft(url, strlen(url)-1);
}

@doc "Returns true if str starts with sub.";
int strStartsWith(string str, string sub) {
	if (strleft(str, strlen(sub)) == sub) return true;
	else return false;
}

@doc "Finds delim in string str and returns the strings to either side of delim.";
splitString(string str, string delim, pointer left, pointer right) {
	int pos;
	
	pos = strstr(str, delim, 0);
	if (pos == -1) {
		writeln("Couldn't find '" + delim + "' in " + str);
	} else {
		*left = strleft(str, pos);
		*right = strright(str, strlen(str)-pos-strlen(delim));
	}
}

@doc "Removes whitespace (i.e. space, \\r, \\n) at the start and end of strings.";
string trim (string str) {
	int b, e;
	char c = ' ';
	
	b = -1; e = strlen(str);
	while (c == ' ' || c == '\n' || c == '\r') c = str@[++b];
	c = ' ';
	while (c == ' ' || c == '\n' || c == '\r') c = str@[--e];
	return substr(str, b, e);
}

@doc "Removes all spaces, CR, and LF chars from a string.";
string stripWhitespace(string str) {
	char c;
	int i;
	string res;
		
	for (i = 0; i < strlen(str); i++) {
		c = str@[i];
		if ( (c != ' ') && (c != '\r') && (c != '\n') ) res = res + c;
	}
	return res;
}

@doc "Returns true if str contains nothing but [0-9,-.].";
int isNumericRange(string str) {
	char c;
	int i;
	
	for (i = 0; i < strlen(str); i++) {
		c = str@[i];
		if ( ((c < '0') || (c > '9')) && (c != ',') && (c != '-') && (c != '.') ) return false;
	}
	return true;
}

