/$ Interactive.h

/*
AUSTIN - A PalmOS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Implements AUSTIN's Interactive mode

#ifndef	__INTERACTIVE_H__
#define	__INTERACTIVE_H__

int _Inter_connected = false;
int _Inter_sock;



@doc "Attempts to connect to host/port. Returns true if successful.";
int interConnect(string ip, int port) {
	writeln("Interactive.h: interConnect()");
	if (_Inter_connected) return false;
	writeln("Interactive.h: interConnect() before tcpConnect");
	_Inter_sock = tcpConnect(ip, port);
	writeln("Interactive.h: interConnect() tcpConnect returned " + _Inter_sock);
	if (_Inter_sock != -1) _Inter_connected = true;
	return _Inter_connected;	
}

@doc "Disconnects the current connection, always succeeds.";
interDisconnect() {
	if (_Inter_connected) {
		tcpClose(_Inter_sock);
		_Inter_sock = 0;
		_Inter_connected = false;
	}
}

@doc "Write the string w to the socket, read result in string r. Returns true if successful.";
int interSend(string w, pointer r) {
	string s;
	int bytes;
	
	if (!_Inter_connected) return false;
	bytes = tcpWrite(_Inter_sock, w);
	bytes = tcpRead(_Inter_sock, &s, 500);
	while (bytes > 0) {
		*r = *r + s;
		s = "";
		bytes = tcpRead(_Inter_sock, &s, 500);
	}
	return true;
}

#endif
