/$ HTTPlib.h

/*
AUSTIN - A Palm OS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Handles all HTTP communications

#include "Write.h"

#define HTTP_DELIM		"\r\n"
#define HTTP_DELIMLEN	2

#define	NAME			0
#define	VALUE			1
#define EXIT_PROGRAM	1

string _HTTP_server;
string _HTTP_protocol;
int _HTTP_retcode;
string _HTTP_retmsg;
pointer _HTTP_headers = null;
int _HTTP_totheaders;
string _HTTP_rawres;
int _HTTP_contentlength;

clearHTTP(int terminate) {
	_HTTP_server = "";
	_HTTP_protocol = "";
	_HTTP_retcode = 0;
	_HTTP_contentlength = 0;
	_HTTP_retmsg = "";
	_HTTP_rawres = "";
	if (_HTTP_headers == null) _HTTP_headers = Array("s,20,2");
	if (terminate) {
		free(_HTTP_headers);
	}
	_HTTP_totheaders = 0;
}

initHTTP() {
	clearHTTP(FALSE);
}

@doc "Returns true if a string is a HTTP request or response.";
isHTTP(string s) {
	return strstr(s, "HTTP", 0) != -1;
}

@doc "Returns a string of all headers.";
listHTTPHeaders() {
	int i;
	string h;
	
	for (i=0; i < _HTTP_totheaders; i++) {
		h = h + _HTTP_headers[i][NAME] + ": " + _HTTP_headers[i][VALUE] + "\n";
	}
	return h;
}

@doc "Prints debugging information on the last HTTP response received.";
printHTTPDebug() {
	writeln("Protocol:\t\t" + _HTTP_protocol);
	writeln("Return code:\t" + _HTTP_retcode);
	writeln("Return msg:\t" + _HTTP_retmsg);
	writeln("Webserver:\t" + _HTTP_server);
	writeln("Content-len:\t" + _HTTP_contentlength);
	writeln(listHTTPHeaders());
}

@doc "Splits a string like \"HTTP/1.1 200 OK\" in its three parts.";
readProtoRetCode (string rec) {
	string stub, retcode;
	
	splitString(rec, " ", &_HTTP_protocol, &stub);
	splitString(stub, " ", &retcode, &_HTTP_retmsg);
	_HTTP_retcode = retcode;
}

@doc "Splits the HTTP headers into name/value pairs.";
readHeader(string rec) {
	string name, value;

	splitString(rec, ": ", &name, &value);
	_HTTP_headers[_HTTP_totheaders][NAME] = name;
	_HTTP_headers[_HTTP_totheaders][VALUE] = value;
	_HTTP_totheaders++;
	if (strlwr(name) == "server") _HTTP_server = strlwr(value);
	if (strlwr(name) == "content-length") _HTTP_contentlength = value;
}

@doc "Retrieves HTTP headers. (Internal function.)";
int _getHTTPHeaders(int sock, string method, string uri) {
	int pos, noretcode=true, httpProtocol=false, run=true, bytes;
	string res, raw, l;
	
	// send HTTP req and read response
	tcpWrite(sock, method + " " + uri + " HTTP/1.0\r\n\r\n");
	writeln("Reading HTTP response...");
	clearHTTP(false);
	while (run) {
		bytes = tcpRead(sock, &raw, 1000);
		// return false if we're not dealing with HTTP
		//writeln("check protocol");
		if (!httpProtocol) {
			if (strstr(raw, "HTTP", 0) == -1) return false;
			else httpProtocol = true;
		}
		
		// add data to the raw results
		_HTTP_rawres = _HTTP_rawres + raw;
		res = res + raw;
		// search for \r\n
		pos = strstr(res, HTTP_DELIM, 0);
		// if found, parse all headers
		while (pos != -1) {
			// if found in first position then we've read all the headers
			if (pos == 0) {
				run = false;
				break;
			}
			l = strleft(res, pos);
			res = strright(res, strlen(res)-pos-HTTP_DELIMLEN);
			if (noretcode && strStartsWith(l, "HTTP")) {
				readProtoRetCode(l);
				noretcode = false;
			} else {
				readHeader(l);
			}
			pos = strstr(res, HTTP_DELIM, 0);
		}
	}
//	if (confirm("Print " + uri + "?")) writeln(_HTTP_rawres);
	printHTTPDebug();
	return true;	
}

@doc "Reads a web page.";
int readPage(string ip, int port, string uri, string method) {
	int res, sock, bytes;
	string buf;
	
	// connect to host
	sock = tcpConnect(ip, port);
	if (sock < 0) return false;
	// get headers
	res = _getHTTPHeaders(sock, method, uri);
	if (method != "GET" || method != "POST" || !res) {
		tcpClose(sock);
		return res;
	}
	if (_HTTP_contentlength != 0) {
		writeln("_HTTP_contentlength = " + _HTTP_contentlength);
		bytes = tcpRead(sock, &buf, _HTTP_contentlength);
		_HTTP_rawres = _HTTP_rawres + buf;
	} else {
		bytes = tcpRead(sock, &buf, 1000);
		while (bytes > 0) {
			_HTTP_rawres = _HTTP_rawres + buf;
			bytes = tcpRead(sock, &buf, 1000);
		}
	}
	tcpClose(sock);
	return true;
}	

@doc "Returns true if successful, false otherwise.";
int getHTTPHeaders(string ip, int port, string uri) {
	int sock, res;
	
	// connect to host
	sock = tcpConnect(ip, port);
	if (sock < 0) return false;
	res = _getHTTPHeaders(sock, "HEAD", uri);
	tcpClose(sock);
	return res;
}
