/$ Gui.h

/*
AUSTIN - A Palm OS Security Scanner.
Copyright (C) 2003  @stake, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Manages the AUSTIN GUI

#include "Fctl.h"


// Forms
#define	GUI_SCANFO			4000
#define	GUI_INTERACTIVEFO	5000
#define	GUI_ABOUTAL			7000

// Fields x100
#define	GUI_HOSTFI			4101
#define	GUI_PORTFI			4102
#define	GUI_STATUSFI		4103
#define	GUI_INTERHOSTFI		5101
#define GUI_INTERPORTFI		5102
#define GUI_INTEROUTPUTFI	5103
#define	GUI_INTERINPUTFI	5104

// Buttons x200
#define	GUI_SCANBU			4201
#define	GUI_SCANINFOBU		4202
#define	GUI_TODBBU			4203
#define	GUI_INTERSENDBU		5201
#define	GUI_INTERCLEARBU	5202
#define	GUI_INTERCONNECTBU	5203
#define	GUI_INTERDISCONNBU	5204

// Checkboxes x300
#define	GUI_TCPSCANCH		4301
#define	GUI_UDPSCANCH		4302
#define	GUI_BANNERGRABCH	4303
#define	GUI_WEBVULNSCANCH	4304
#define	GUI_SCHEDULESCANCH	4305
#define	GUI_NASLSCANCH		4306

// Misc x900
#define	GUI_HISTORYTR		4901
#define	GUI_INTERSCROLLBAR	5901

// Menus 8000
#define GUI_SCANMENU		8001
#define	GUI_INTERMENU		8002
#define GUI_ABOUTMENU		8003

// Events
#define	GUI_PAGEUPKEY		5
#define	GUI_PAGEDOWNKEY		6


// index of the form currently displayed
int _GUI_ondisplay;

@doc "Sets the status field in Scan mode.";
setStatus(string s) {
	FsetText(GUI_STATUSFI, s);
	writeln(s);
}	

@doc "Used to set checkbox state in Scan mode.";
setButtonState(int id, int state) {
	FsetState(id, state);
}

@doc "Used to set the name of a button.";
setButtonString(int id, string str) {
	FsetText(id, str);
}

@doc "Returns true if the user hit the stop button.";
userHitStop() {
	int e;
	
	e = Fevent(0);
	if (e == GUI_SCANBU) return true;
	return false;
}

#include "Scan.h"

@doc "Event handler for Interactive mode's scrollbar. (Internal method).";
_eventHandler(int id, int type) {
	if (id == GUI_INTERSCROLLBAR) return GUI_INTEROUTPUTFI;
	else if(id == GUI_INTEROUTPUTFI) return GUI_INTERSCROLLBAR;
}

@doc "Writes GUI prefs to the _Prefs_ vars.";
saveGUIPrefs() {
	_Prefs_hosts = FgetText(GUI_HOSTFI);
	_Prefs_ports = FgetText(GUI_PORTFI);
	_Prefs_tcpscan = FgetState(GUI_TCPSCANCH);
	_Prefs_udpscan = FgetState(GUI_UDPSCANCH);
	_Prefs_naslscan = FgetState(GUI_NASLSCANCH);
	_Prefs_webvulnscan = FgetState(GUI_WEBVULNSCANCH);
	_Prefs_scheduledscan = FgetState(GUI_SCHEDULESCANCH);
	_Prefs_bannergrab = FgetState(GUI_BANNERGRABCH);
}

@doc "Sets the Scan mode widgets with the prefs read from the db.";
setGUIPrefValues() {
	FsetText(GUI_HOSTFI, _Prefs_hosts);
	FsetText(GUI_PORTFI,  _Prefs_ports);
	FsetState(GUI_TCPSCANCH, _Prefs_tcpscan);
	FsetState(GUI_UDPSCANCH, _Prefs_udpscan);
	FsetState(GUI_NASLSCANCH, _Prefs_naslscan);
	FsetState(GUI_WEBVULNSCANCH, _Prefs_webvulnscan);
	FsetState(GUI_SCHEDULESCANCH, _Prefs_scheduledscan);
	FsetState(GUI_BANNERGRABCH, _Prefs_bannergrab);
}

@doc "Draws the GUI, sets up the widgets.";
initGUI() {
	int res;
	
	title("AUSTIN");
	res = OpenRsrcDb("AUSTINrsrc");
	Fctl(EHAND, _eventHandler); 
	Fctl(LOAD, GUI_INTERACTIVEFO);
	Fctl(LOAD, GUI_SCANFO);
	setGUIPrefValues();
	Fctl(DRAW, GUI_SCANFO);
	_GUI_ondisplay = GUI_SCANFO;
}

@doc "Set state of the Connect/Disconnect buttons in Interactive mode.";
setConnectedButton() {
	if (!_Inter_connected) {
		FsetState(GUI_INTERDISCONNBU, 1);
		FsetState(GUI_INTERCONNECTBU, 0);
	}
}

@doc "Saves the values entered by the user in the Scan form .";
saveUserInput() {
	if (_GUI_ondisplay == GUI_SCANFO) {
		saveGUIPrefs();
		closePrefs();
	}
}

@doc "This function is called before AUSTIN exits.";
austinExit() {
	saveUserInput();
	clearHTTP(EXIT_PROGRAM);
	clearNet();
	closeWrite();
}

@doc "Main GUI event loop.";
mainGUI() {
	int e, keeprunning = true;
	string s1, s2, s3;
	
	while (keeprunning) {
		e = Fevent(1);
		//writeln("Eventid = " + e);
		//if (e == GUI_TODBBU) keeprunning = false;
		s1 = s2 = s3 = "";
		switch (e) {
		// Scan button
			case GUI_SCANBU:
					_Prefs_hosts = FgetText(GUI_HOSTFI);
					_Prefs_ports = FgetText(GUI_PORTFI);
					doScan();
					break;
			case GUI_TODBBU:
					austinExit();
					launch("DBOS");
					break;
		// Scan form checkboxes
			case GUI_TCPSCANCH:
					togglePref(&_Prefs_tcpscan);
					break;
			case GUI_UDPSCANCH:
					togglePref(&_Prefs_udpscan);
					break;
			case GUI_NASLSCANCH:	
					togglePref(&_Prefs_naslscan);
					break;
			case GUI_WEBVULNSCANCH:
					togglePref(&_Prefs_webvulnscan);
					break;
			case GUI_SCHEDULESCANCH:
					togglePref(&_Prefs_scheduledscan);
					break;
			case GUI_BANNERGRABCH:
					togglePref(&_Prefs_bannergrab);
					break;
		// Menu items
			case GUI_INTERMENU:
					if (_GUI_ondisplay != GUI_INTERACTIVEFO) {
						saveUserInput();
						Fctl(DRAW, GUI_INTERACTIVEFO);
						setConnectedButton();
						_GUI_ondisplay = GUI_INTERACTIVEFO;
					}
					break;
			case GUI_SCANMENU:
					if (_GUI_ondisplay != GUI_SCANFO) {
						Fctl(DRAW, GUI_SCANFO);
						_GUI_ondisplay = GUI_SCANFO;
					}
					break;
			case GUI_ABOUTMENU:
					Fctl(POPALERT, GUI_ABOUTAL);
					break;
		// Interactive form
			case GUI_INTERCLEARBU:
					FsetText(GUI_INTEROUTPUTFI, "");
					break;
			case GUI_INTERSENDBU:
					s1 = FgetText(GUI_INTERINPUTFI);
					Fctl(SETFOCUS, GUI_INTEROUTPUTFI);
					if (interSend(s1, &s2)) {
						s3 = s1 + s2;
						Fctl(INSERT, &s3);
						Fctl(SETFOCUS, GUI_INTERINPUTFI);
						Fctl(SELALL);
					} else {
						s3 = "[Couldn't send. Are you connected?]\n";
						Fctl(INSERT, &s3);
						Fctl(SETFOCUS, GUI_INTERINPUTFI);
					}
					break;
			case GUI_INTERCONNECTBU:
					s1 = FgetText(GUI_INTERHOSTFI);
					s2 = FgetText(GUI_INTERPORTFI);
					Fctl(SETFOCUS, GUI_INTEROUTPUTFI);
					if (interConnect(s1, s2)) {
						s3 = "[Connected to " + s1 + ":" + s2 + "]\n";
					} else {
						s3 = "[Couldn't connect. Disconnect first?]\n";
						setConnectedButton();						
					}
					Fctl(INSERT, &s3);
					break;
			case GUI_INTERDISCONNBU:
					interDisconnect();
					break;
		// Misc
			case GUI_PAGEUPKEY:
					Fctl(PREVFIELD);
					break;
			case GUI_PAGEDOWNKEY:
					Fctl(NEXTFIELD);
					break;
		}
	}
}
