#include "spike.h"

#include <malloc.h>
#include <string.h>

/*for select()*/
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>


#include <ctype.h>
#include "hdebug.h"
#include "tcpstuff.h"

#include "spike.h"

#define SPIKEVERSION 1.8

/*undef this for less info*/
//#define DEBUG

/*bug in includes with linux so here's this precurser*/
int isblank (int c);

struct spike * current_spike;       

/*overkill really*/
char *s_fuzzstring[5000];

int
spike_clear()
{
  char * tmp;

  tmp=realloc(current_spike->databuf,4);
  if (tmp==NULL)
    {
      return 0;
    }

  current_spike->databuf=tmp; /*newly allocated buffer*/  
  current_spike->datasize=0;
  current_spike->currentvariable=0;
  initListenerArray(current_spike->block_listeners);
  initListenerArray(current_spike->size_listeners);
  return 1;
}

struct spike *
new_spike()
{
  struct spike *outspike;
  outspike=malloc(sizeof(struct spike));
  outspike->databuf=malloc(1);
  outspike->datasize=0;
  outspike->endbuf=outspike->databuf;
  initListenerArray(outspike->block_listeners);
  initListenerArray(outspike->size_listeners);
  

  return (outspike);
}

int
setspike(struct spike * newspike)
{
  if (newspike==NULL)
    return 0; /*failure*/
  current_spike=newspike;
  return 1; /*success*/
}


/*update any listening sizes*/
void
s_update_listeners(unsigned long size)
{

  int i;

  for (i=0; i< MAXLISTENERS; i++)
    {
       if (current_spike->block_listeners[i].isused && 
	   current_spike->block_listeners[i].isopen)
	 {
	   current_spike->block_listeners[i].size+=size;
	 }
    }

}


/*
  this pushes an arbitrary byte string onto the spike stack
  and updates any listening blocksizes
*/
int
s_push(unsigned char * pushme, unsigned long size)
{
  unsigned char * tmp;

/*
  printf("Datasize=%lu+%lu\n",current_spike->datasize,size);
*/

  tmp=realloc(current_spike->databuf,current_spike->datasize+size);
  if (tmp==NULL)
    {
      return 0;
    }

  current_spike->databuf=tmp; /*newly allocated buffer*/
  memcpy(current_spike->databuf+current_spike->datasize,pushme,size);
  /*now we update any buffer listening for size information*/
  s_update_listeners(size);
  current_spike->datasize+=size;
  return 1;
}

/*
  inputs a string of hex ("ABCDABCD01010101")
  outputs throwing the string of bytes on the spike stack

  This is a huge function that does a little stupid thing. It better work.
*/
int
s_binary(char * instring)
{
  /*grab code from hydrogen for this*/
  /*TODO*/
  unsigned long size=0;

  unsigned long i=0;

  int done=0;


  int firstnibble=1;
  unsigned char currentnibble,lastnibble;

  unsigned char * outarray;


#ifdef DEBUG
  printf("s_binary entered\n");
#endif

  if (instring==NULL)
    {
      /*DEBUG*/
      /*
	printf("sbinary entered with null instring\n");
      */
      return 0;
    }

  outarray=malloc(4); /*just some basic space*/
  if (outarray==NULL)
    {
      printf("ERROR failed to malloc in s_binary()\n");
      return 0;
    }

  while (!done)
    {
#if 0
   printf("S_binary() at %d\n",i);
#endif
      /*check for the end of the string*/
      if (instring[i]==0x00)
	{
	  done=1;
	  /*DEBUG*/
	  /*
	  printf("done with instring at %d\n",i);
	  */
	  continue;
	}
      /*check for 0x or \x*/
      /*
	chance for one byte overflow here, if string is not
	null terminated. So don't do that.
      */
      if ( (instring[i]=='0' && instring[i+1]=='x') ||
	   (instring[i]=='\\' && instring[i+1]=='x') )
	{
	  i+=2;
	  continue;
	}

      /*clear whitespace*/
      if (isspace(instring[i]))
	{
	  i++;
	  continue;
	}

      /*only hex digits are valid now*/
      if (!isxdigit(instring[i]))
	{
	  printf("Parser failure in s_binary!\n");
	  free(outarray);
	  return 0;
	}

      /*handle a hex digit*/
      if (isdigit(instring[i]))
	currentnibble=instring[i]-'0';
      else
	currentnibble=toupper(instring[i])-'A'+10;

      if (firstnibble)
	{
	  /*this is the first nibble*/
	  firstnibble=0;
	}
      else
	{
	  /*finishing off a whole byte*/
	  size++;
	  outarray=realloc(outarray,size);
	  outarray[size-1]=(lastnibble<<4)+currentnibble;
	  firstnibble=1;
	}
      lastnibble=currentnibble;
      i++; /*next input char please*/
    }

  /*DEBUG*/
  /*
  printf("DEBUG: s_binary() pushing %d bytes\n",size);
  */
  s_push(outarray,size);
  free(outarray);
  return 1; /*success*/
}

/*throws a string onto the stack.*/
int
s_string(char * instring)
{

  unsigned long size;

#if 0
  printf("s_string entered\n");
#endif

  if (instring==NULL)
    return 0;

 
  size=strlen(instring);
  if (size!=0) /*no null strings for us*/
    s_push(instring,size); /*won't include trailing zero*/
  
  return 1; /*success*/
}

/*pushes an XDR style string onto the spike stack.
  An XDR style string is an asciiz string with a prepended big
  endian length word and the string itself gets padded with zeros out to
  a word boundry. Many protocols use this sort of thing. Windows, of course,
  needs little endian size fields, but that's another spike_call anyways...
*/
int
s_xdr_string(unsigned char *astring)
{
  unsigned long length;
  int mod;
  int i;
  
  /*null check*/
  if (!astring)
    return 0;

  length=strlen(astring)+1;
  if (length%4==0)
    mod=0;
  else
    mod=4-length%4;

  /*first push the length there*/
  s_bigword(length);
  s_string(astring);
  /*null terminate it*/
  s_binary("00");

  /*add padding*/
  for (i=0; i<mod; i++)
    {
      s_binary("00"); 
    }
  return 1;
}

int
add_size_listener(int size, char * instring, int type, long plussome)
{
  listener *myListener;
  char *number_placeholder;
  
#ifdef DEBUG
  printf("Adding new listener. Size=%d, instring=%s, type=%d plussome=%ld\n",
	 size,instring,type,plussome);
#endif
  myListener=add_listener(current_spike->size_listeners,instring);
  myListener->sizetype=type;

 
  myListener->bufstart=current_spike->datasize;
  myListener->length=size;
  myListener->size=0;
  myListener->addme=plussome;
  number_placeholder=malloc(size);

  memset(number_placeholder,0x00,size);
  s_push((unsigned char *)number_placeholder,size);
  free(number_placeholder);


  return 1;

}
/*input: 

  reserves some bytes to throw an ascii number in
  if the block ends on 1 then it becomes 00000000000000000000001 etc.
*/

int
s_blocksize_string(char * instring, int size)
{
#ifdef DEBUG
  printf("s_blocksize string entered\n");
#endif
  return add_size_listener(size,instring,ASCII,0);
}


int
s_block_start(char *blockname)
{
  listener *myListener ;

#ifdef DEBUG
  printf("s_block_start entered\n");
#endif

  myListener=add_listener(current_spike->block_listeners,blockname);
  if (myListener==NULL)
    return 0; /*failure*/


  return 1; /*success*/
}

int
s_binary_block_size_word_bigendian(char *blockname)
{
#ifdef DEBUG
  printf("s_blocksize_word_bigendian entered\n");
#endif
  return add_size_listener(4,blockname,BINARYBIGENDIAN,0);
}

int
s_binary_block_size_halfword_bigendian(char * blockname)
{
  return add_size_listener(2,blockname,BINARYBIGENDIANHALFWORD,0);
}

int
s_binary_block_size_byte(char * blockname)
{
  return add_size_listener(1,blockname,ONEBYTE,0);
}

int
s_binary_block_size_byte_plus(char * blockname, long plus)
{
  return add_size_listener(1,blockname,ONEBYTE,plus);
}


int
s_binary_block_size_word_bigendian_plussome(char *blockname, long some)
{
#ifdef DEBUG
  printf("s_blocksize_word_bigendian_plussome entered\n");
#endif
  return add_size_listener(4,blockname,BINARYBIGENDIAN,some);
}

int
s_binary_block_size_intel_halfword(char *blockname)
{

  return add_size_listener(2,blockname,BINARYLITTLEENDIANHALFWORD,0);
}

int
s_binary_block_size_intel_halfword_plus(char *blockname,long plus)
{
  return add_size_listener(2,blockname,BINARYLITTLEENDIANHALFWORD,plus);
}



/*pushes the word on the s_stack in big endian format*/
int
s_bigword(unsigned int aword)
{
  unsigned int tempword;
  tempword=htonl(aword);
#ifdef DEBUG
  if (sizeof(tempword)!=4)
    printf("error: sizeof(aword) != 4\n");
#endif
  s_push((unsigned char *)&tempword,sizeof(tempword)); /*better be 4*/
  return 1;
}

int
s_intelword(unsigned int aword)
{
  unsigned int tempword;
  tempword=ioal(aword);
  s_push((unsigned char *)&tempword,sizeof(tempword)); /*better be 4*/
  return 1;
}

/*pushes a short onto the spike in intel order*/
/*also returns the short in ioas format - who knows.*/
int
s_intelhalfword(unsigned short ashort)
{
  unsigned short tempshort;
  unsigned char tempc;
  tempshort=ioas(ashort);

  /*shorts are only two bytes*/
  tempc=(unsigned char)((tempshort >> 0 ) & 0xff);
  s_push(&tempc,1);
  tempc=(unsigned char)((tempshort >> 8 ) & 0xff);
  s_push(&tempc,1);
  return tempshort;
}

void
close_a_size(listener *myListener,unsigned long size)
{
  long addme;
#ifdef DEBUG
  printf("close_a_size entered\n");
#endif
  
  addme=myListener->addme;
  /*wacky signed issues - cludgy and ugly but better stinkin' work*/
  if (addme<0)
    {
      addme=-addme; /*make it positive*/
      size=size-addme;
    }
  else
    size=size+addme;

  switch (myListener->sizetype)
    {
    case ASCII:
      {
	char tmpbuf[2000];
	char fmt[20];
	/*do we need a special format for long?*/
	sprintf(fmt,"%%%lulu",myListener->length);
	sprintf(tmpbuf,fmt,size);
	/*debug*/
#ifdef DEBUG
	printf("format: *%s*\n",fmt);
	printf("size: *%s*\n",tmpbuf);
#endif
	memcpy(current_spike->databuf+myListener->bufstart,tmpbuf,myListener->length);
      }
      break;
    case BINARYBIGENDIAN:
     
      {
	unsigned long tmpint;
	tmpint=htonl(size);
#ifdef DEBUG
	printf("BINARYBIGENDIAN size = %p\n",(void *)tmpint);
#endif
	memcpy(current_spike->databuf+myListener->bufstart,&tmpint,myListener->length);
      }
      break;
    case ONEBYTE:
      {
	unsigned char tmpc;
	tmpc=(unsigned char)size;
	memcpy(current_spike->databuf+myListener->bufstart,&tmpc,myListener->length);
      }
      break;
    case BINARYLITTLEENDIANHALFWORD:
      {
	/*theoretically this actually works*/
	unsigned short temps;
	unsigned char a,b;
	temps=(unsigned short)size;
	a=temps & 0xff;
	b=(temps >> 8) & 0xff;
	memcpy(current_spike->databuf+myListener->bufstart,&a,1);
	memcpy(current_spike->databuf+myListener->bufstart+1,&b,1);
      }
      break;
    case BINARYBIGENDIANHALFWORD:
      {
	unsigned short temps;
	unsigned char a,b;
	temps=(unsigned short)size;
	b=temps & 0xff;
	a=(temps >> 8) & 0xff;
	memcpy(current_spike->databuf+myListener->bufstart,&a,1);
	memcpy(current_spike->databuf+myListener->bufstart+1,&b,1);
      }
    default:
      fprintf(stderr,"Something wrong - we don't have that type!\n");
      break;
      
    }
}

void
close_sizes(char * blockname, unsigned long size)
{

  int i;

#ifdef DEBUG
  printf("close_sizes entered\n");
#endif

  for (i=0; i< MAXLISTENERS; i++)
    {

      if (current_spike->size_listeners[i].isused )
       {
#ifdef DEBUG
	 printf("looking at listener with mystring %s for %s\n",current_spike->size_listeners[i].mystring,blockname);
#endif
	 if (!strcmp(current_spike->size_listeners[i].mystring,blockname))
	   {
#ifdef DEBUG
	     printf("Closing_a_size i=%d\n",i);
#endif
	     close_a_size(&(current_spike->size_listeners[i]),size);
	   }

       }


       

    }
}

int
s_block_end(char * blockname)
{
  listener *myListener;

#ifdef DEBUG
  printf("s_block_end entered\n");
#endif

  myListener=find_listener(current_spike->block_listeners,blockname);



  if (myListener==NULL)
    {
      /*urg. This should never happen*/
      return 0;
    }

  /*ok, now I've found the block*/
  /*close it*/
  myListener->isopen=0;

  close_sizes(blockname,myListener->size);
  
  return 1;
}

void
s_print_buffer()
{
  unsigned long i;

#ifdef DEBUG
  printf("s_print_buffer entered\n");
#endif

  printf("Datasize=%lu\n",current_spike->datasize);
  printf("Start buffer:\n");
  for (i=0; i< current_spike->datasize; i++)
    {
      printf("%2.2x ",current_spike->databuf[i]);
      if ((i+1)%8==0)
	printf("\n");
    }
  printf("\nEnd buffer:\n");
}

void
s_printf_buffer()
{
  printf("***%s***\n",current_spike->databuf);

}
unsigned long 
s_get_size()
{
  return current_spike->datasize;
}

unsigned char * 
s_get_databuf()
{
  return current_spike->databuf;
}

/*right now spike only does tcp...*/
int
spike_send()
{
  int retval;
  if (current_spike->proto==1)
    retval=tcpwrite(current_spike->fd,s_get_size(),s_get_databuf());

  /*we don't want the stupid TCP stack under Linux to send the next spike_send packet with this one*/
  fflush(0);
  usleep(50);

  return retval;
}

int
spike_send_tcp(char * host, int port)
{

  if (!spike_connect_tcp(host,port))
    return 0;


  return tcpwrite(current_spike->fd,s_get_size(),s_get_databuf());

}

int 
spike_connect_tcp(char * host, int port)
{
  int fd;

  fd=tcpconnect(host,port);
  if (fd==-1)
    {
      fprintf(stderr,"Couldn't connect to target\n");
      return (0);
    }
  current_spike->fd=fd;
  current_spike->proto=1; /*TCP*/
  return 1;
}

void
spike_close_tcp()
{
  close(current_spike->fd);
  current_spike->fd=-1;
}

int
s_binary_repeat(char *instring, int times) 
{
  for (; times>0; times--)
    s_binary(instring);
  return 1;
}

int
s_string_repeat(char *instring, int times) 
{
  for (; times>0; times--)
    s_string(instring);
  return 1;
}


/** throws an LF (0x0a) terminated string onto the stack.
this is useful for LPD, at least, and likely lots of others.
**/
int
s_string_lf(char * instring) 
{
    unsigned long size;

#ifdef DEBUG
    printf("s_string entered\n");
#endif

    if (instring==NULL)
        return 0;

    size=strlen(instring);

    if (size!=0) { /*no null strings for us*/
        s_push(instring,size); /*won't include trailing
zero*/
        s_binary("0x0a"); /* lf termination */
    }

    return 1; /*success*/
}

/*intel order any long . . . generates an intel byte order long from
  our long format, whatever it is. So if we're on an intel box, all
  good, and if we're on a sparc, all good.*/
unsigned long 
ioal(unsigned long myint)
{
  unsigned long tint;
  tint=htonl(myint);
  intel_order( (char *) &tint, 4);
  return tint;
}

unsigned short
ioas(unsigned short myshort)
{

  unsigned short tshort;
  tshort=htons(myshort);
  intel_order( (unsigned char *)&tshort, 2);
  return tshort;

}



/*Whatever endian you are, you have an intel endian long, 
  and you want it in your format*/
unsigned long
unintel(unsigned long myint)
{
  unsigned long tint;
  /*first, we reverse it*/
  /*
    printf("intel: %d, nonintel %d\n",myint,ntohl(myint));
  */
  tint=ioal(myint);
  /*now, if we're sparc, we do nothing, and if we're intel, we re-reverse it*/
  return (tint);

}



void
intel_order(char * buffer, int length)
{
  char temp[5000];
  int i;

  if (length>sizeof(temp))
    {
      printf("error on intel_order\n");
      return;
    }
    

  memcpy(temp,buffer,length);
  for (i=0; i<length; i++)
    {
      buffer[i]=*(temp+length-i-1);
    }

} 


int
s_fd_wait()
{
  /*this function does a select to wait for
    input on the fd, and if there
    is, returns 1, else 0 */
  int fd;
  fd_set rfds;
  struct timeval tv;
  int retval;

  fd=current_spike->fd;

  /* Watch server_fd (fd 0) to see when it has input. */
  FD_ZERO(&rfds);
  FD_SET(fd, &rfds);
  /* Wait up to zero seconds  .  will this wait forever? not on linux.*/

  /* from man page: timeout is an upper bound on the amount of time
       elapsed before select returns. It may be zero, causing select
       to return immediately.  If timeout is NULL (no timeout), select
       can block indefinitely. */

  /*wait 2 seconds only*/
  tv.tv_sec = 2;
  tv.tv_usec = 0;

  retval = select(fd+1, &rfds, NULL, NULL, &tv);
  /* Don't rely on the value of tv now! */

  switch (retval)
   {
     case 0:
       /*Timeout - no packet or keypress*/
        return(0);
        break;
     case -1:
      /* ignore interrupted system calls */
       if (errno != EINTR)
         {
           /*some kind of weird select error. Die. */
           exit(-1);
         }
      /*otherwise we got interrupted, so just return false*/
       return (0);
       break;
     default:
         {
           if (FD_ISSET(fd,&rfds))
             return (1);
           else
            return (0);
         }
   }
}


/*must be called before doing any string fuzzing*/
void
s_resetfuzzvariable()
{
  current_spike->fuzzvariable=0;
  current_spike->didlastvariable=0;
}

/*true if we've done the last variable. False otherwise. Survives spike_clear()*/
int
s_didlastvariable()
{
  return current_spike->didlastvariable;
}

void
s_resetfuzzstring()
{
  current_spike->fuzzstring=0;
  current_spike->didlastfuzzstring=0;
}

int
s_didlastfuzzstring()
{
  return current_spike->didlastfuzzstring;
}

void
s_string_variable(unsigned char *variable)
{
  /*if current variable is the fuzzed variable, then send in a fuzz string, else just send the variable*/
  if (current_spike->fuzzvariable==current_spike->currentvariable)
    {
      s_string(s_fuzzstring[current_spike->fuzzstring]);
      current_spike->didlastvariable=1;
      if (s_fuzzstring[current_spike->fuzzstring+1]==NULL)
	{
	  current_spike->didlastfuzzstring=1;
	}
    }
  else
    {
      /* DEBUG */
      /*
      printf("Found variable %s\n",variable);
      */
      s_string(variable);
      current_spike->didlastvariable=0;
    }

  current_spike->firstvariable=0;
  current_spike->currentvariable++;
}


void
s_string_variables(unsigned char splitchar, unsigned char *variables)
{
  char * tempstr;
  char * variable;
  char splitarray[2];
  char * origstr;
  char * beforeequal;
  char * afterequal;
  splitarray[0]=splitchar;
  splitarray[1]=0;

  tempstr=strdup(variables);
  origstr=tempstr;

  /*for each variable, do ... */
  while (tempstr!=NULL)
    {
      /*if not the first variable*/
      if (!current_spike->firstvariable)
	{
	  /*put an ampersand between us and previous because we're not the first*/
	  s_string(splitarray);
	}
      variable=strsep(&tempstr,splitarray);
      afterequal=strdup(variable);
      splitarray[0]='='; /*set to = to split on the variable name*/
      beforeequal=strsep(&afterequal,splitarray);
      s_string(beforeequal);

      /*print an equal sign if we have a variable*/
      if (strlen(beforeequal)>0)
	s_string("=");
      
      /*if we're fuzzing, then use fuzz string, else use what we got*/
      /*we do this even if we don't have anything in afterequal*/
      s_string_variable(afterequal);
      splitarray[0]=splitchar; /*reset to & */
      
      free(beforeequal);
    }
  free(origstr);
}

void
s_incrementfuzzvariable()
{
  current_spike->fuzzvariable++;
}

void
s_incrementfuzzstring()
{
  current_spike->fuzzstring++;
}

/*if envvar is set, pushes that, else pushes realvar*/
void
s_string_or_env(unsigned char *envvar, unsigned char *realvar)
{
  if (getenv(envvar))
    {
      s_string(getenv(envvar));
    }
  else
    {
      s_string(realvar);
    }

}

void
s_add_fuzzstring(unsigned char * newfuzzstring)
{
  int i;


  for (i=0; s_fuzzstring[i]!=NULL; i++);

  s_fuzzstring[i]=strdup(newfuzzstring);
  s_fuzzstring[i+1]=NULL;

}


/*initializes a bunch of strings and throws them into s_fuzzstring,
  which is a global array of strings, ending with a null*/
void
s_init_fuzzing()
{
  char buffer[1000000];

  /*first we init it*/
  s_fuzzstring[0]=NULL;
  s_add_fuzzstring("../../../../../../../../../../../../etc/hosts%00");
  s_add_fuzzstring("../../../../../../../../../../../../etc/passwd%00");
  s_add_fuzzstring("../../../../../../../../../../../../etc/shadow%00");
  memset(buffer,0x41,1000000);
  buffer[999999]=0;
  s_add_fuzzstring(buffer);
  buffer[100000]=0;
  s_add_fuzzstring(buffer);
  buffer[50000]=0;
  s_add_fuzzstring(buffer);
  buffer[25000]=0;
  s_add_fuzzstring(buffer);
  buffer[12000]=0;
  s_add_fuzzstring(buffer);
  buffer[4096]=0;
  s_add_fuzzstring(buffer);
  buffer[1024]=0;
  s_add_fuzzstring(buffer);
  buffer[512]=0;
  s_add_fuzzstring(buffer);
  buffer[100]=0;
  s_add_fuzzstring(buffer);
  buffer[64]=0;
  s_add_fuzzstring(buffer);
  memset(buffer,'<',100000);
  buffer[100000]=0;
  s_add_fuzzstring(buffer);
  strcpy(buffer,"'sqlattempt1");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"(sqlattempt2)");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"OR 1=1");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n%n");
  s_add_fuzzstring(buffer);
  strcpy(buffer,";bob");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"\"hihihi");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"|dir");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"|ls");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%25%5c..%00");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"!@#$%%^#$%#$@#$%$$@#$%^^**(()");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"%01%02%03%04%0a%0d%0aADSF");
  s_add_fuzzstring(buffer);
  strcpy(buffer,"%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n%25n");
  s_add_fuzzstring(buffer);
 
}

void
s_setfirstvariable()
{
  current_spike->firstvariable=1;
}

/*
      if ((response=s_scan_for_variable(buffer,"WWW-Authenticate: NTLM ","\r\n"))!=NULL)

As you can see, s_scan_for_variable(inputbuffer, start, end) tries to match a substring in a buffer separated by two strings. It returns null on failure to match.
*/

unsigned char *
s_scan_for_variable(unsigned char * buffer, unsigned char *startdelim, 
		    unsigned char * enddelim)
{

  unsigned char *found, *found2, *retstring;

  found=strstr(buffer,startdelim);
  if (found==NULL)
    {
      /*failure*/
      return NULL;
    }
  
  found+=strlen(startdelim); /*skip over this stuff and get to the meat*/

  found2=strstr(found,enddelim);
  if (found2==NULL)
    {
      /*failure*/
      return NULL;
    }

  /*now we need to make a new string that copies from found to found2*/
  retstring=malloc(found2-found+1);
  memset(retstring,0x00,found2-found+1); /*this takes care of trailing null*/
  memcpy(retstring, found,found2-found); /*copy data*/
  return retstring; /*better free this later - garbage collection would be nice*/
  
  
}










