
/*localeshared.c - a fuzzer originally designed for locale fuzzing
but equally good against all sorts of other clib functions. Load
with LD_PRELOAD on most systems.*/

#include <stdio.h>

/*defines*/
/*#define DOLOCALE /*LOCALE FUZZING*/

#define SIZE 5000 /*size of our returned environment*/
#define FUZCHAR 0x41 /*our fuzzer character*/
static char stuff[SIZE];
static char display[] = "10.3.1.121:0"; /*display to return when asked*/
static char mypath[] = "/usr/bin:/usr/sbin:/bin:/sbin";
static char ld_preload[] = "";


/*Getenv fuzzing - modify this as needed to suit your particular
fuzzing needs*/

char *
getenv(char * environment)
{
 printf("GETENV: %s\n",environment);

/*sometimes you don't want to mess with this stuff*/
 if (!strcmp(environment,"DISPLAY"))
   return display;

 if (!strcmp(environment,"PATH"))
   return mypath;

 if (!strcmp(environment,"LD_PRELOAD"))
   return ld_preload;

/*return NULL when you don't want to destroy the environment*/
/*return NULL; */
/*return stuff when you want to return long strings as each variable*/
 return stuff;
}


#ifdef DOLOCALE
char*
dgettext(char * bob, char *msid)
{
 printf("SHARED: %s, %s\n",bob,msid);
return stuff;
}

char *
dcgettext(char *domainname, char *messageid, int domain)
{
/*printf ("SHARED: %s %s %d\n",domainname,messageid,domain);*/
return stuff;
}

char *
textdomain(char *domain)
{
printf("Domain: SHARED: %s\n",domain);
return stuff;
}

char *
gettext( char* text)
{
printf("SHARED: %s\n",text);
return stuff;
}
#endif /*DOLOCALE*/

_init()
{
printf("shared library loader working\n");
memset(stuff,FUZCHAR,SIZE-1);
stuff[SIZE-1]=0;
}
