/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

public class tlsMessageFactory {
    public void makeMessage( byte[] helloMessage, byte[] cipherSuite, int offset, int length, byte ver )
    {
        /* TLS RECORD LAYER
         * 0, Content Type = 0x16, handshake
         * 1 & 2, Version = 0x0301, TLS V1.0 (i.e. SSLv3.1)
         * 3 & 4, Length
         *                        0     1     2     3                                      4    */
        byte[] tlsRecordLayer = { 0x16, 0x03, ver, (byte) ((helloMessage.length-5) >> 8), (byte) (helloMessage.length-5) };

        /* Handshake Protocol
         * 0, Handshake type  = 0x01 Client Hello
         * 1-3, length
         * 4-5, Version = 0x0301, TLS V1.0 (i.e. SSLv3.1)
         *                                 5     6     7                                       8                              9     10*/
        byte[] tlsClientHandshakeHello = { 0x01, 0x00, (byte) ((helloMessage.length-9) >> 8), (byte) (helloMessage.length-9), 0x03, ver };

        /* RANDOM
         * Random is composed of two parts, the time and a 28 byte random block.
         * However I've no requirement for security in my app, so ive made it
         * static. Copying what I've done here for a real SSL/TLS app is almost
         * certainly a really bad idea.
         */

        byte[] time = new byte[4]; //11, 12, 13, 14
        byte[] randomt = { 0x01, 0x02, 0x03, 0x04, 0x05,
                           0x01, 0x02, 0x03, 0x04, 0x05,
                           0x01, 0x02, 0x03, 0x04, 0x05,
                           0x01, 0x02, 0x03, 0x04, 0x05,
                           0x01, 0x02, 0x03, 0x04, 0x05,
                           0x01, 0x02, 0x03 };

        TimeHelper.getTime( time );

        byte[] sessionLength = {0x00}; //47

        //Cipher Suites
        byte[] cipherSuiteLength = { (byte) (length >> 8), (byte) (length) }; //48, 49
        // Cipher Suite, 49, 50

        //Compression Methods
        byte[] compressionMethodsLength = {0x01}; //51
        byte[] compressionMethods = {0x00}; //52

        //Extentions Length
        byte[] extentionsLength = {0x00}; //null compression, 53

        System.arraycopy(tlsRecordLayer, 0, helloMessage, 0, tlsRecordLayer.length);
        System.arraycopy(tlsClientHandshakeHello, 0, helloMessage, 5, tlsClientHandshakeHello.length);

        System.arraycopy(time, 0, helloMessage, 11, time.length);
        System.arraycopy(randomt, 0, helloMessage, 15, 28);

        System.arraycopy(sessionLength, 0, helloMessage, 43, sessionLength.length);

        System.arraycopy(cipherSuiteLength, 0, helloMessage, 44, 2);
        System.arraycopy(cipherSuite, offset, helloMessage, 46, length);

        System.arraycopy(compressionMethodsLength, 0, helloMessage, 46+length, compressionMethodsLength.length);
        System.arraycopy(compressionMethods, 0, helloMessage, 47+length, compressionMethods.length);

        //helloMessage[52+length] = extentionsLength[0];
    }

}
