/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */
package athenasslciphercheck;

import java.util.logging.Level;
import java.util.logging.Logger;

public class tlsCipherCheck {
    /* 
     * return values
     * -5  Could not connect
     * -3  Time Out
     * -2  Unexpected data
     * -1  Rejected
     *  0  Connection Reset
     *  1  Accepted
     */
    public static int check(byte[] ciphers, int offset, int length, byte ver, FoundCipher foundCipher )
    {
        int result = 0;
        

        for( int i = 0; i < connection.settings.getRetrys(); i++ )
        {
            //System.out.println(""+offset+ " "+length);
            connection conn = new connection();

            byte[] helloMessage = new byte[48+length];
            new tlsMessageFactory().makeMessage( helloMessage, ciphers, offset, length, ver );

            if( !conn.connect( ) )
            {
                result = -5;
                break;
            }
            
            conn.send( helloMessage );

            int tmp;
            if( (tmp = conn.recv()) == 0x15 )
            {
                conn.close();
                result = -1; //rejected
                //if( i > 0 )
                //    System.out.println("Retry Successful");
                break;
            }
            else if( tmp == -1 )
            {
                result = 0; //connection reset
            }
            else if( tmp == -3 )
            {
                result = -3; //time out
            }
            else if( tmp == 0x16 )
            {
                //Get Cipher Accepted
                for( int x = 0; x < 4; x++ )
                    tmp = conn.recv();

                for( int x = 0; x < 38; x++ )
                    tmp = conn.recv();

                //Read Session Length
                int sessionLength = conn.recv();
                int t1 = 0;
                int t2 = 0;
                int x;
                for( x = 0; x < sessionLength; x++ )
                {
                    tmp = conn.recv();
                }

                t1 = conn.recv();
                t2 = conn.recv();

                foundCipher.cipher = t2 + (t1*256);

                //System.out.println( "*" + tmp );

                conn.close();
                result = 1; //accepted
                //if( i > 0 )
                  //  System.out.println("Retry Successful");

                break;
            }
            else
                result = -2; //unexpected data

            conn.close();

            //if( i+1 < connection.settings.getRetrys() )
            //    System.out.print("Retry #"+(i+1)+"....");
            //else
            //    System.out.println("Giving Up");
        }
        return result;
    }
}
