/*
 * Decompiled with CFR 0.152.
 */
package athenasslciphercheck;

import athenasslciphercheck.Cipher;
import athenasslciphercheck.CipherListWrapper;
import athenasslciphercheck.FoundCipher;
import athenasslciphercheck.Results;
import athenasslciphercheck.Settings;
import athenasslciphercheck.tlsCipherCheck;
import java.util.ArrayList;

public class tlsHeuristics {
    private ArrayList<Cipher> cipherDescList;
    private byte[] nonCipher = new byte[2];
    private boolean nonCipherAssigned = false;
    public int resetCount = 0;
    public int timedOutCount = 0;
    public int unidentifiedCount = 0;
    public int rejectedCount = 0;
    private CipherListWrapper cipherListWrapper = new CipherListWrapper();
    private Settings settings;

    public void checkTlsCiphers() {
        int i;
        byte[] cipherList = new byte[131072];
        int count = 0;
        for (int x = 0; x <= 255; ++x) {
            for (int y = 0; y <= 255; ++y) {
                cipherList[count] = (byte)x;
                cipherList[++count] = (byte)y;
                ++count;
            }
        }
        System.out.println();
        System.out.println("SSLv3 Ciphers");
        int rateLimit = 1;
        if (this.settings.getSafe()) {
            rateLimit = 32;
        }
        for (i = 0; i <= 7 * rateLimit; ++i) {
            this.search(cipherList, 512 * i * 32 / rateLimit, 16384 / rateLimit, (byte)0);
            if (this.timedOutCount <= 5) continue;
            System.out.println("SSlv3 being skipped due to timeouts");
            break;
        }
        this.printStats();
        this.resetCount = 0;
        this.timedOutCount = 0;
        this.unidentifiedCount = 0;
        this.rejectedCount = 0;
        this.nonCipher[0] = -1;
        this.nonCipher[1] = -1;
        count = 0;
        for (int x = 0; x <= 255; ++x) {
            for (int y = 0; y <= 255; ++y) {
                cipherList[count] = (byte)x;
                cipherList[++count] = (byte)y;
                ++count;
            }
        }
        this.nonCipher[0] = -1;
        this.nonCipher[1] = -1;
        this.nonCipherAssigned = false;
        System.out.println();
        System.out.println("TLSv1 Ciphers");
        for (i = 0; i <= 7 * rateLimit; ++i) {
            this.search(cipherList, 512 * i * 32 / rateLimit, 16384 / rateLimit, (byte)1);
            if (this.timedOutCount <= 5) continue;
            System.out.println("TLSv1 being skipped due to timeouts");
            break;
        }
        this.printStats();
    }

    public void search(byte[] cipherList, int offset, int length, byte ver) {
        Cipher c;
        byte[] tmp_a;
        String proto = "";
        proto = ver == 1 ? "TLSv1" : "SSLv3";
        FoundCipher foundCipher = new FoundCipher();
        FoundCipher foundCipher2 = new FoundCipher();
        foundCipher.cipher = 65535;
        foundCipher2.cipher = 65535;
        int lowerResult = tlsCipherCheck.check(cipherList, offset, length / 2, ver, foundCipher);
        int upperResult = tlsCipherCheck.check(cipherList, offset + length / 2, length / 2, ver, foundCipher2);
        if (!this.nonCipherAssigned) {
            if (lowerResult != 1) {
                this.nonCipher[0] = cipherList[offset];
                this.nonCipher[1] = cipherList[offset + 1];
                this.nonCipherAssigned = true;
            } else if (upperResult != 1) {
                this.nonCipher[0] = cipherList[offset + length / 2];
                this.nonCipher[1] = cipherList[offset + length / 2 + 1];
                this.nonCipherAssigned = true;
            }
        }
        if (foundCipher.cipher != 65535 && lowerResult == 1) {
            cipherList[foundCipher.cipher * 2] = this.nonCipher[0];
            cipherList[foundCipher.cipher * 2 + 1] = this.nonCipher[1];
            tmp_a = new byte[]{(byte)(foundCipher.cipher / 256), (byte)(foundCipher.cipher % 256)};
            c = this.cipherListWrapper.lookUpCipher(tmp_a);
            if (c != null) {
                Results.addResultLine(c, proto);
            } else {
                Results.addResultLine(null, "UNKNOWN CIPHER #" + foundCipher.cipher);
            }
        }
        if (foundCipher2.cipher != 65535 && upperResult == 1) {
            cipherList[foundCipher2.cipher * 2] = this.nonCipher[0];
            cipherList[foundCipher2.cipher * 2 + 1] = this.nonCipher[1];
            tmp_a = new byte[]{(byte)(foundCipher2.cipher / 256), (byte)(foundCipher2.cipher % 256)};
            c = this.cipherListWrapper.lookUpCipher(tmp_a);
            if (c != null) {
                Results.addResultLine(c, proto);
            } else {
                Results.addResultLine(null, "UNKNOWN CIPHER #" + foundCipher2.cipher);
            }
        }
        this.updateCounts(lowerResult, upperResult);
        if (length == 4 && lowerResult == 1 && (cipherList[offset] != this.nonCipher[0] || cipherList[offset + 1] != this.nonCipher[1])) {
            byte[] tmp = new byte[]{cipherList[offset], cipherList[offset + 1]};
            c = this.cipherListWrapper.lookUpCipher(tmp);
            if (c != null) {
                Results.addResultLine(c, proto);
            } else {
                Results.addResultLine(null, "UNKNOWN CIPHER #" + offset / 2);
            }
        }
        if (length != 4) {
            if (lowerResult == 1) {
                this.search(cipherList, offset, length / 2, ver);
            }
            if (upperResult == 1) {
                this.search(cipherList, offset + length / 2, length / 2, ver);
            }
        }
    }

    public tlsHeuristics(Settings s) {
        this.cipherListWrapper.loadCiphers();
        this.settings = s;
    }

    private void printStats() {
        if (this.timedOutCount == 0 && this.unidentifiedCount == 0) {
            return;
        }
        System.out.println("");
        boolean first = true;
        if (this.timedOutCount > 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print(this.timedOutCount + " connections timed out");
            first = false;
        }
        if (this.unidentifiedCount > 0) {
            if (!first) {
                System.out.print(", ");
            }
            System.out.print(this.unidentifiedCount + " connections responded with unexpected data");
            first = false;
        }
        System.out.println();
    }

    private void updateCounts(int lowerResult, int upperResult) {
        if (lowerResult == 0 || lowerResult == -5) {
            ++this.resetCount;
        }
        if (upperResult == 0 || upperResult == -5) {
            ++this.resetCount;
        }
        if (lowerResult == -1) {
            ++this.rejectedCount;
        }
        if (upperResult == -1) {
            ++this.rejectedCount;
        }
        if (lowerResult == -2) {
            ++this.unidentifiedCount;
        }
        if (upperResult == -2) {
            ++this.unidentifiedCount;
        }
        if (lowerResult == -3) {
            ++this.timedOutCount;
        }
        if (upperResult == -3) {
            ++this.timedOutCount;
        }
    }
}

