/*
 * Decompiled with CFR 0.152.
 */
package athenasslciphercheck;

import athenasslciphercheck.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

public class connection {
    private InputStream in;
    private OutputStream out;
    private Socket sock;
    public static Settings settings;

    public boolean connect() {
        if (settings == null) {
            System.err.println("Unexpected error, settings is null");
            return false;
        }
        try {
            Thread.sleep(settings.getThrottle());
            if (settings.getProxyType() == 0) {
                this.sock = new Socket(settings.getHost(), settings.getPort());
            } else if (settings.getProxyType() == 1) {
                this.sock = new Socket(settings.getProxyHost(), settings.getProxyPort());
            } else {
                System.err.println("Proxy Type Unsupported");
                return false;
            }
            this.sock.setSoTimeout(settings.getTimeout());
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
            if (settings.getProxyType() == 1) {
                StringBuilder HTTPConnectString = new StringBuilder();
                HTTPConnectString.append("CONNECT ");
                HTTPConnectString.append(settings.getHost());
                HTTPConnectString.append(":");
                HTTPConnectString.append(settings.getPort());
                HTTPConnectString.append(" HTTP/1.0\r\n");
                HTTPConnectString.append("User-Agent: Athena SSL Cipher Check v0.6.2\r\n");
                HTTPConnectString.append("Poxy-Connect: Keep-Alive\r\n");
                HTTPConnectString.append("Content-Length: 0\r\n");
                HTTPConnectString.append("Host: " + settings.getHost() + "\r\n");
                if (settings.getBasicAuth().length() > 0) {
                    HTTPConnectString.append("Authorization: Basic " + settings.getBasicAuth() + "\r\n");
                    HTTPConnectString.append("Proxy-Authorization: Basic " + settings.getBasicAuth() + "\r\n");
                }
                HTTPConnectString.append("Pragma: no-cache\r\n");
                HTTPConnectString.append("\r\n");
                byte[] message = new byte[HTTPConnectString.length()];
                for (int i = 0; i < HTTPConnectString.length(); ++i) {
                    message[i] = (byte)HTTPConnectString.charAt(i);
                }
                this.send(message);
                BufferedReader br = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
                String line = br.readLine();
                if (line.contains(" 403 ")) {
                    System.out.println("HTTP Proxy: 403 Access Denied");
                    return false;
                }
                if (line.contains(" 407 ")) {
                    System.out.println("HTTP Proxy: 407 Proxy Authentication Required");
                    return false;
                }
                if (!line.contains(" 200 ")) {
                    System.out.println("HTTP Proxy: Unknown Error");
                    return false;
                }
                while (this.in.available() > 0) {
                    this.in.read();
                }
            }
        }
        catch (InterruptedException e) {
            System.out.println("Unable to connect to " + settings.getHost());
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
            return false;
        }
        catch (IOException e) {
            System.out.print("Unable to connect to " + settings.getHost());
            System.out.println(", " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean send(byte[] byteArray) {
        try {
            this.out.write(byteArray, 0, byteArray.length);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
            return false;
        }
        return true;
    }

    public int recv() {
        try {
            return this.in.read();
        }
        catch (InterruptedIOException e) {
            return -3;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void close() {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }
}

