/*
 * Decompiled with CFR 0.152.
 */
package athenasslciphercheck;

import athenasslciphercheck.Cipher;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class CipherListWrapper {
    private ArrayList<Cipher> cipherDescList = new ArrayList();

    public Cipher lookUpCipher(byte[] tmp) {
        for (int i = 0; i < this.cipherDescList.size(); ++i) {
            if (this.cipherDescList.get(i).getId()[0] != tmp[0] || this.cipherDescList.get(i).getId()[1] != tmp[1]) continue;
            return this.cipherDescList.get(i);
        }
        return null;
    }

    public void loadCiphers() {
        String path = "";
        if (System.getProperty("java.class.path").contains(System.getProperty("file.separator"))) {
            path = path + System.getProperty("java.class.path").substring(0, 1 + System.getProperty("java.class.path").lastIndexOf(System.getProperty("file.separator")));
        }
        try {
            String line;
            BufferedReader fileIn = new BufferedReader(new FileReader(path + "tlsciphers.txt"));
            int count = 0;
            while ((line = fileIn.readLine()) != null) {
                ++count;
                if (line.charAt(0) == '#') continue;
                if (line.split(" ").length != 4) {
                    System.out.println("Error in configuration file on line " + count + ", 4 words expected.");
                    continue;
                }
                String cipherCode = line.split(" ")[0];
                if (cipherCode.length() != 4 || !this.isHexidec(cipherCode)) {
                    System.out.println("Error in configuration file on line " + count + ", codes must in the form of a four digit hexidecimal number");
                    continue;
                }
                Cipher tmpCipher = new Cipher(line.split(" ")[1], this.hexStringToByte(cipherCode), Integer.parseInt(line.split(" ")[2]), Integer.parseInt(line.split(" ")[3]));
                this.cipherDescList.add(tmpCipher);
            }
            fileIn.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.out.println("configuration file '" + path + "tlsciphers.txt' not found");
        }
    }

    public boolean isHexidec(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public byte[] hexStringToByte(String s) {
        byte[] array = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            int tmp = 0;
            tmp = this.hexValue(s.charAt(i)) * 16 + this.hexValue(s.charAt(i + 1));
            array[i / 2] = (byte)tmp;
        }
        return array;
    }

    public int hexValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }
}

