/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ListIterator;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.BooleanLiteral;
import lombok.ast.Cast;
import lombok.ast.CharLiteral;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.InlineIfExpression;
import lombok.ast.IntegralLiteral;
import lombok.ast.Literal;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Statement;
import lombok.ast.StringLiteral;
import lombok.ast.UnaryExpression;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public class TypeEvaluator {
    private final JavaContext context;

    public TypeEvaluator(JavaContext context) {
        this.context = context;
    }

    @Deprecated
    public JavaParser.TypeDescriptor evaluate(Node node) {
        JavaParser.ResolvedNode resolved = null;
        if (this.context != null) {
            resolved = this.context.resolve(node);
        }
        if (resolved instanceof JavaParser.ResolvedMethod) {
            JavaParser.TypeDescriptor type;
            JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
            if (method.isConstructor()) {
                JavaParser.ResolvedClass containingClass = method.getContainingClass();
                type = containingClass.getType();
            } else {
                type = method.getReturnType();
            }
            return type;
        }
        if (resolved instanceof JavaParser.ResolvedField) {
            JavaParser.TypeDescriptor type;
            Expression initializer;
            VariableDefinitionEntry first;
            VariableDeclaration declaration;
            VariableDefinition definition;
            JavaParser.ResolvedField field = (JavaParser.ResolvedField)resolved;
            Node astNode = field.findAstNode();
            if (astNode instanceof VariableDeclaration && (definition = (declaration = (VariableDeclaration)astNode).astDefinition()) != null && (first = (VariableDefinitionEntry)definition.astVariables().first()) != null && (initializer = first.astInitializer()) != null && (type = this.evaluate((Node)initializer)) != null) {
                return type;
            }
            return field.getType();
        }
        if (node instanceof VariableReference) {
            Statement statement = JavaContext.getParentOfType(node, Statement.class, false);
            if (statement != null) {
                ListIterator iterator = statement.getParent().getChildren().listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != statement) continue;
                    if (!iterator.hasPrevious()) break;
                    iterator.previous();
                    break;
                }
                String targetName = ((VariableReference)node).astIdentifier().astValue();
                while (iterator.hasPrevious()) {
                    BinaryExpression binaryExpression;
                    ExpressionStatement expressionStatement;
                    Expression expression;
                    Node previous = (Node)iterator.previous();
                    if (previous instanceof VariableDeclaration) {
                        VariableDeclaration declaration = (VariableDeclaration)previous;
                        VariableDefinition definition = declaration.astDefinition();
                        for (VariableDefinitionEntry entry : definition.astVariables()) {
                            if (entry.astInitializer() == null || !entry.astName().astValue().equals(targetName)) continue;
                            return this.evaluate((Node)entry.astInitializer());
                        }
                        continue;
                    }
                    if (!(previous instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)previous).astExpression()) instanceof BinaryExpression) || ((BinaryExpression)expression).astOperator() != BinaryOperator.ASSIGN || !targetName.equals((binaryExpression = (BinaryExpression)expression).astLeft().toString())) continue;
                    return this.evaluate((Node)binaryExpression.astRight());
                }
            }
        } else if (node instanceof Cast) {
            JavaParser.ResolvedNode typeReference;
            Cast cast = (Cast)node;
            if (this.context != null && (typeReference = this.context.resolve((Node)cast.astTypeReference())) instanceof JavaParser.ResolvedClass) {
                return ((JavaParser.ResolvedClass)typeReference).getType();
            }
            JavaParser.TypeDescriptor viewType = this.evaluate((Node)cast.astOperand());
            if (viewType != null) {
                return viewType;
            }
        } else if (node instanceof Literal) {
            if (node instanceof NullLiteral) {
                return null;
            }
            if (node instanceof BooleanLiteral) {
                return new JavaParser.DefaultTypeDescriptor("boolean");
            }
            if (node instanceof StringLiteral) {
                return new JavaParser.DefaultTypeDescriptor("java.lang.String");
            }
            if (node instanceof CharLiteral) {
                return new JavaParser.DefaultTypeDescriptor("char");
            }
            if (node instanceof IntegralLiteral) {
                IntegralLiteral literal = (IntegralLiteral)node;
                if (literal.astMarkedAsLong()) {
                    return new JavaParser.DefaultTypeDescriptor("long");
                }
                return new JavaParser.DefaultTypeDescriptor("int");
            }
            if (node instanceof FloatingPointLiteral) {
                FloatingPointLiteral literal = (FloatingPointLiteral)node;
                if (literal.astMarkedAsFloat()) {
                    return new JavaParser.DefaultTypeDescriptor("float");
                }
                return new JavaParser.DefaultTypeDescriptor("double");
            }
        } else {
            if (node instanceof UnaryExpression) {
                return this.evaluate((Node)((UnaryExpression)node).astOperand());
            }
            if (node instanceof InlineIfExpression) {
                InlineIfExpression expression = (InlineIfExpression)node;
                if (expression.astIfTrue() != null) {
                    return this.evaluate((Node)expression.astIfTrue());
                }
                if (expression.astIfFalse() != null) {
                    return this.evaluate((Node)expression.astIfFalse());
                }
            } else if (node instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)node;
                BinaryOperator operator = expression.astOperator();
                switch (operator) {
                    case LOGICAL_OR: 
                    case LOGICAL_AND: 
                    case EQUALS: 
                    case NOT_EQUALS: 
                    case GREATER: 
                    case GREATER_OR_EQUAL: 
                    case LESS: 
                    case LESS_OR_EQUAL: {
                        return new JavaParser.DefaultTypeDescriptor("boolean");
                    }
                }
                JavaParser.TypeDescriptor type = this.evaluate((Node)expression.astLeft());
                if (type != null) {
                    return type;
                }
                return this.evaluate((Node)expression.astRight());
            }
        }
        if (resolved instanceof JavaParser.ResolvedVariable) {
            JavaParser.ResolvedVariable variable = (JavaParser.ResolvedVariable)resolved;
            return variable.getType();
        }
        return null;
    }

    public PsiType evaluate(PsiElement node) {
        if (node == null) {
            return null;
        }
        PsiElement resolved = null;
        if (node instanceof PsiReference) {
            resolved = ((PsiReference)node).resolve();
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (method.isConstructor()) {
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && this.context != null) {
                    return this.context.getEvaluator().getClassType(containingClass);
                }
            } else {
                return method.getReturnType();
            }
        }
        if (resolved instanceof PsiField) {
            PsiType type;
            PsiField field = (PsiField)resolved;
            if (field.getInitializer() != null && (type = this.evaluate((PsiElement)field.getInitializer())) != null) {
                return type;
            }
            return field.getType();
        }
        if (resolved instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)resolved;
            PsiExpression last = ConstantEvaluator.findLastAssignment(node, (PsiVariable)variable);
            if (last != null) {
                return this.evaluate((PsiElement)last);
            }
            return variable.getType();
        }
        if (node instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)node;
            return expression.getType();
        }
        return null;
    }

    public static PsiType evaluate(UElement node) {
        if (node == null) {
            return null;
        }
        UElement resolved = node;
        if (resolved instanceof UReferenceExpression) {
            UastContext uastContext = UastUtils.getUastContext((UElement)node);
            resolved = UastUtils.tryResolveUDeclaration((UElement)resolved, (UastContext)uastContext);
        }
        if (resolved instanceof UMethod) {
            return ((UMethod)resolved).getPsi().getReturnType();
        }
        if (resolved instanceof UVariable) {
            UVariable variable = (UVariable)resolved;
            UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)variable, node);
            if (lastAssignment != null) {
                return TypeEvaluator.evaluate((UElement)lastAssignment);
            }
            return variable.getType();
        }
        if (resolved instanceof UCallExpression) {
            if (UastExpressionUtils.isMethodCall((UElement)resolved)) {
                PsiMethod resolvedMethod = ((UCallExpression)resolved).resolve();
                return resolvedMethod != null ? resolvedMethod.getReturnType() : null;
            }
            return ((UCallExpression)resolved).getExpressionType();
        }
        if (resolved instanceof UExpression) {
            return ((UExpression)resolved).getExpressionType();
        }
        return null;
    }

    @Deprecated
    public static JavaParser.TypeDescriptor evaluate(JavaContext context, Node node) {
        return new TypeEvaluator(context).evaluate(node);
    }

    public static PsiType evaluate(JavaContext context, PsiElement node) {
        return new TypeEvaluator(context).evaluate(node);
    }
}

