/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

public class ResourceEvaluator {
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    public static final ResourceType DIMENSION_MARKER_TYPE = ResourceType.DECLARE_STYLEABLE;
    public static final String COLOR_INT_ANNOTATION = "android.support.annotation.ColorInt";
    public static final String PX_ANNOTATION = "android.support.annotation.Px";
    public static final String DIMENSION_ANNOTATION = "android.support.annotation.Dimension";
    public static final String RES_SUFFIX = "Res";
    public static final String ANIMATOR_RES_ANNOTATION = "android.support.annotation.AnimatorRes";
    public static final String ANIM_RES_ANNOTATION = "android.support.annotation.AnimRes";
    public static final String ANY_RES_ANNOTATION = "android.support.annotation.AnyRes";
    public static final String ARRAY_RES_ANNOTATION = "android.support.annotation.ArrayRes";
    public static final String ATTR_RES_ANNOTATION = "android.support.annotation.AttrRes";
    public static final String BOOL_RES_ANNOTATION = "android.support.annotation.BoolRes";
    public static final String COLOR_RES_ANNOTATION = "android.support.annotation.ColorRes";
    public static final String DIMEN_RES_ANNOTATION = "android.support.annotation.DimenRes";
    public static final String DRAWABLE_RES_ANNOTATION = "android.support.annotation.DrawableRes";
    public static final String FONT_RES_ANNOTATION = "android.support.annotation.FontRes";
    public static final String FRACTION_RES_ANNOTATION = "android.support.annotation.FractionRes";
    public static final String ID_RES_ANNOTATION = "android.support.annotation.IdRes";
    public static final String INTEGER_RES_ANNOTATION = "android.support.annotation.IntegerRes";
    public static final String INTERPOLATOR_RES_ANNOTATION = "android.support.annotation.InterpolatorRes";
    public static final String LAYOUT_RES_ANNOTATION = "android.support.annotation.LayoutRes";
    public static final String MENU_RES_ANNOTATION = "android.support.annotation.MenuRes";
    public static final String PLURALS_RES_ANNOTATION = "android.support.annotation.PluralsRes";
    public static final String RAW_RES_ANNOTATION = "android.support.annotation.RawRes";
    public static final String STRING_RES_ANNOTATION = "android.support.annotation.StringRes";
    public static final String STYLEABLE_RES_ANNOTATION = "android.support.annotation.StyleableRes";
    public static final String STYLE_RES_ANNOTATION = "android.support.annotation.StyleRes";
    public static final String TRANSITION_RES_ANNOTATION = "android.support.annotation.TransitionRes";
    public static final String XML_RES_ANNOTATION = "android.support.annotation.XmlRes";
    private final JavaEvaluator evaluator;
    private boolean allowDereference = true;

    public ResourceEvaluator(JavaEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public ResourceEvaluator allowDereference(boolean allow) {
        this.allowDereference = allow;
        return this;
    }

    public static ResourceUrl getResource(JavaEvaluator evaluator, PsiElement element) {
        return new ResourceEvaluator(evaluator).getResource(element);
    }

    public static ResourceUrl getResource(JavaEvaluator evaluator, UElement element) {
        return new ResourceEvaluator(evaluator).getResource(element);
    }

    public static EnumSet<ResourceType> getResourceTypes(JavaEvaluator evaluator, PsiElement element) {
        return new ResourceEvaluator(evaluator).getResourceTypes(element);
    }

    public static EnumSet<ResourceType> getResourceTypes(JavaEvaluator evaluator, UElement element) {
        return new ResourceEvaluator(evaluator).getResourceTypes(element);
    }

    public ResourceUrl getResource(UElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResource((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResource((UElement)expression.getElseExpression());
            }
        } else {
            ResourceUrl url;
            UExpression selector;
            if (element instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)element;
                return this.getResource((UElement)parenthesizedExpression.getExpression());
            }
            if (element instanceof UCallExpression) {
                UCallExpression call = (UCallExpression)element;
                PsiMethod function = call.resolve();
                PsiClass containingClass = UastUtils.getContainingClass((PsiElement)function);
                if (function != null && containingClass != null) {
                    List args;
                    String qualifiedName = containingClass.getQualifiedName();
                    String name = call.getMethodName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || "android.content.res.TypedArray".equals(qualifiedName)) && name != null && name.startsWith("get") && !(args = call.getValueArguments()).isEmpty()) {
                        return this.getResource((UElement)args.get(0));
                    }
                }
            } else if (this.allowDereference && element instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression && (url = this.getResource((UElement)selector)) != null) {
                return url;
            }
        }
        if (element instanceof UReferenceExpression) {
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return url;
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable, element);
                if (lastAssignment != null) {
                    return this.getResource((UElement)lastAssignment);
                }
                return null;
            }
        }
        return null;
    }

    public ResourceUrl getResource(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResource((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResource((PsiElement)expression.getElseExpression());
            }
        } else {
            if (element instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
                return this.getResource((PsiElement)parenthesizedExpression.getExpression());
            }
            if (element instanceof PsiMethodCallExpression && this.allowDereference) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                PsiReferenceExpression expression = call.getMethodExpression();
                PsiMethod method = call.resolveMethod();
                if (method != null && method.getContainingClass() != null) {
                    PsiExpression[] args;
                    String qualifiedName = method.getContainingClass().getQualifiedName();
                    String name = expression.getReferenceName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || "android.content.res.TypedArray".equals(qualifiedName)) && name != null && name.startsWith("get") && (args = call.getArgumentList().getExpressions()).length > 0) {
                        return this.getResource((PsiElement)args[0]);
                    }
                }
            } else if (element instanceof PsiReference) {
                PsiLocalVariable variable;
                PsiExpression last;
                ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
                if (url != null) {
                    return url;
                }
                PsiElement resolved = ((PsiReference)element).resolve();
                if (resolved instanceof PsiField) {
                    url = ResourceEvaluator.getResourceConstant(resolved);
                    if (url != null) {
                        return url;
                    }
                    PsiField field = (PsiField)resolved;
                    if (field.getInitializer() != null) {
                        return this.getResource((PsiElement)field.getInitializer());
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(element, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                    return this.getResource((PsiElement)last);
                }
            }
        }
        return null;
    }

    public EnumSet<ResourceType> getResourceTypes(UElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (UElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResourceTypes((UElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResourceTypes((UElement)expression.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((UElement)expression.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((UElement)expression.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof UParenthesizedExpression) {
            UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)element;
            return this.getResourceTypes((UElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof UQualifiedReferenceExpression || element instanceof UCallExpression) {
            UElement probablyCallExpression = element;
            if (element instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression qualifiedExpression = (UQualifiedReferenceExpression)element;
                probablyCallExpression = qualifiedExpression.getSelector();
            }
            if (probablyCallExpression instanceof UCallExpression) {
                EnumSet<ResourceType> types;
                UCallExpression call = (UCallExpression)probablyCallExpression;
                PsiMethod method = call.resolve();
                PsiClass containingClass = UastUtils.getContainingClass((PsiElement)method);
                if (method != null && containingClass != null && (types = this.getTypesFromAnnotations((PsiModifierListOwner)method)) != null) {
                    return types;
                }
            }
        }
        if (element instanceof UReferenceExpression) {
            EnumSet<ResourceType> types;
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiModifierListOwner && (types = this.getTypesFromAnnotations((PsiModifierListOwner)resolved)) != null && !types.isEmpty()) {
                return types;
            }
            if (resolved instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable, element);
                if (lastAssignment != null) {
                    return this.getResourceTypes((UElement)lastAssignment);
                }
                return null;
            }
        }
        return null;
    }

    public EnumSet<ResourceType> getResourceTypes(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResourceTypes((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResourceTypes((PsiElement)expression.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((PsiElement)expression.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((PsiElement)expression.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            return this.getResourceTypes((PsiElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof PsiMethodCallExpression) {
            EnumSet<ResourceType> types;
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            PsiMethod method = call.resolveMethod();
            if (method != null && method.getContainingClass() != null && (types = this.getTypesFromAnnotations((PsiModifierListOwner)method)) != null) {
                return types;
            }
        } else if (element instanceof PsiReference) {
            PsiLocalVariable variable;
            PsiExpression last;
            EnumSet<ResourceType> types;
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((PsiReference)element).resolve();
            if (resolved instanceof PsiModifierListOwner && (types = this.getTypesFromAnnotations((PsiModifierListOwner)resolved)) != null && !types.isEmpty()) {
                return types;
            }
            if (resolved instanceof PsiField) {
                url = ResourceEvaluator.getResourceConstant(resolved);
                if (url != null) {
                    return EnumSet.of(url.type);
                }
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return this.getResourceTypes((PsiElement)field.getInitializer());
                }
                return null;
            }
            if (resolved instanceof PsiParameter) {
                return this.getTypesFromAnnotations((PsiModifierListOwner)((PsiParameter)resolved));
            }
            if (resolved instanceof PsiLocalVariable && (last = ConstantEvaluator.findLastAssignment(element, (PsiVariable)(variable = (PsiLocalVariable)resolved))) != null) {
                return this.getResourceTypes((PsiElement)last);
            }
        }
        return null;
    }

    private EnumSet<ResourceType> getTypesFromAnnotations(PsiModifierListOwner owner) {
        if (this.evaluator == null) {
            return null;
        }
        PsiAnnotation[] annotations = this.evaluator.getAllAnnotations(owner, true);
        return ResourceEvaluator.getTypesFromAnnotations(annotations);
    }

    public static EnumSet<ResourceType> getTypesFromAnnotations(PsiAnnotation[] annotations) {
        EnumSet<ResourceType> resources = null;
        for (PsiAnnotation annotation : annotations) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            switch (signature) {
                case "android.support.annotation.ColorInt": {
                    return EnumSet.of(COLOR_INT_MARKER_TYPE);
                }
                case "android.support.annotation.Px": 
                case "android.support.annotation.Dimension": {
                    return EnumSet.of(DIMENSION_MARKER_TYPE);
                }
                case "android.support.annotation.AnyRes": {
                    return ResourceEvaluator.getAnyRes();
                }
            }
            ResourceType type = ResourceEvaluator.getTypeFromAnnotationSignature(signature);
            if (type == null) continue;
            if (resources == null) {
                resources = EnumSet.of(type);
                continue;
            }
            resources.add(type);
        }
        return resources;
    }

    public static EnumSet<ResourceType> getTypesFromAnnotations(List<UAnnotation> annotations) {
        EnumSet<ResourceType> resources = null;
        for (UAnnotation annotation : annotations) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            switch (signature) {
                case "android.support.annotation.ColorInt": {
                    return EnumSet.of(COLOR_INT_MARKER_TYPE);
                }
                case "android.support.annotation.Px": 
                case "android.support.annotation.Dimension": {
                    return EnumSet.of(DIMENSION_MARKER_TYPE);
                }
                case "android.support.annotation.AnyRes": {
                    return ResourceEvaluator.getAnyRes();
                }
            }
            ResourceType type = ResourceEvaluator.getTypeFromAnnotationSignature(signature);
            if (type == null) continue;
            if (resources == null) {
                resources = EnumSet.of(type);
                continue;
            }
            resources.add(type);
        }
        return resources;
    }

    public static ResourceType getTypeFromAnnotationSignature(String signature) {
        switch (signature) {
            case "android.support.annotation.AnimatorRes": {
                return ResourceType.ANIMATOR;
            }
            case "android.support.annotation.AnimRes": {
                return ResourceType.ANIM;
            }
            case "android.support.annotation.ArrayRes": {
                return ResourceType.ARRAY;
            }
            case "android.support.annotation.AttrRes": {
                return ResourceType.ATTR;
            }
            case "android.support.annotation.BoolRes": {
                return ResourceType.BOOL;
            }
            case "android.support.annotation.ColorRes": {
                return ResourceType.COLOR;
            }
            case "android.support.annotation.DimenRes": {
                return ResourceType.DIMEN;
            }
            case "android.support.annotation.DrawableRes": {
                return ResourceType.DRAWABLE;
            }
            case "android.support.annotation.FontRes": {
                return ResourceType.FONT;
            }
            case "android.support.annotation.FractionRes": {
                return ResourceType.FRACTION;
            }
            case "android.support.annotation.IdRes": {
                return ResourceType.ID;
            }
            case "android.support.annotation.IntegerRes": {
                return ResourceType.INTEGER;
            }
            case "android.support.annotation.InterpolatorRes": {
                return ResourceType.INTERPOLATOR;
            }
            case "android.support.annotation.LayoutRes": {
                return ResourceType.LAYOUT;
            }
            case "android.support.annotation.MenuRes": {
                return ResourceType.MENU;
            }
            case "android.support.annotation.PluralsRes": {
                return ResourceType.PLURALS;
            }
            case "android.support.annotation.RawRes": {
                return ResourceType.RAW;
            }
            case "android.support.annotation.StringRes": {
                return ResourceType.STRING;
            }
            case "android.support.annotation.StyleableRes": {
                return ResourceType.STYLEABLE;
            }
            case "android.support.annotation.StyleRes": {
                return ResourceType.STYLE;
            }
            case "android.support.annotation.TransitionRes": {
                return ResourceType.TRANSITION;
            }
            case "android.support.annotation.XmlRes": {
                return ResourceType.XML;
            }
        }
        return null;
    }

    public static ResourceUrl getResourceConstant(PsiElement node) {
        PsiClass rClass;
        PsiField field;
        PsiClass typeClass;
        if (node instanceof PsiReferenceExpression) {
            PsiReferenceExpression reference;
            PsiReferenceExpression select;
            PsiReferenceExpression expression = (PsiReferenceExpression)node;
            if (expression.getQualifier() instanceof PsiReferenceExpression && (select = (PsiReferenceExpression)expression.getQualifier()).getQualifier() instanceof PsiReferenceExpression && "R".equals((reference = (PsiReferenceExpression)select.getQualifier()).getReferenceName())) {
                String typeName = select.getReferenceName();
                String name = expression.getReferenceName();
                ResourceType type = ResourceType.getEnum((String)typeName);
                if (type != null && name != null) {
                    boolean isFramework = reference.getQualifier() instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)reference.getQualifier()).getReferenceName());
                    return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
                }
            }
        } else if (node instanceof PsiField && (typeClass = (field = (PsiField)node).getContainingClass()) != null && (rClass = typeClass.getContainingClass()) != null && "R".equals(rClass.getName())) {
            String name = field.getName();
            ResourceType type = ResourceType.getEnum((String)typeClass.getName());
            if (type != null && name != null) {
                String qualifiedName = rClass.getQualifiedName();
                boolean isFramework = qualifiedName != null && qualifiedName.startsWith("android.");
                return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
            }
        }
        return null;
    }

    public static ResourceUrl getResourceConstant(UElement node) {
        ResourceReference reference = ResourceReference.get(node);
        if (reference == null) {
            return null;
        }
        String name = reference.getName();
        ResourceType type = reference.getType();
        boolean isFramework = reference.getPackage().equals("android");
        return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework);
    }

    private static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(COLOR_INT_MARKER_TYPE);
        types.remove(DIMENSION_MARKER_TYPE);
        return types;
    }
}

