/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamedObjectProviderBinding
implements ProviderBinding {
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> myNamesToProvidersMap = new THashMap(5);
    private final Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> myNamesToProvidersMapInsensitive = new THashMap(5);

    public void registerProvider(@NonNls @NotNull String[] names, @NotNull ElementPattern filter, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "registerProvider"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "registerProvider"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "registerProvider"));
        }
        Map<String, List<ProviderBinding.ProviderInfo<ElementPattern>>> map = caseSensitive ? this.myNamesToProvidersMap : this.myNamesToProvidersMapInsensitive;
        for (String attributeName : names) {
            String key = caseSensitive ? attributeName : attributeName.toLowerCase();
            List<ProviderBinding.ProviderInfo<ElementPattern>> psiReferenceProviders = map.get(key);
            if (psiReferenceProviders == null) {
                psiReferenceProviders = new SmartList<ProviderBinding.ProviderInfo<ElementPattern>>();
                map.put(key, psiReferenceProviders);
            }
            psiReferenceProviders.add(new ProviderBinding.ProviderInfo<ElementPattern>(provider, filter, priority));
        }
    }

    @Override
    public void addAcceptableReferenceProviders(@NotNull PsiElement position, @NotNull List<ProviderBinding.ProviderInfo<ProcessingContext>> list, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addAcceptableReferenceProviders"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addAcceptableReferenceProviders"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addAcceptableReferenceProviders"));
        }
        String name = this.getName(position);
        if (name != null) {
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMap.get(name), list, hints);
            NamedObjectProviderBinding.addMatchingProviders(position, this.myNamesToProvidersMapInsensitive.get(name.toLowerCase()), list, hints);
        }
    }

    @Override
    public void unregisterProvider(@NotNull PsiReferenceProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "unregisterProvider"));
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern>> list : this.myNamesToProvidersMap.values()) {
            for (ProviderBinding.ProviderInfo<ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<ElementPattern>>(list)) {
                if (!trinity.provider.equals(provider)) continue;
                list.remove(trinity);
            }
        }
        for (List<ProviderBinding.ProviderInfo<ElementPattern>> list : this.myNamesToProvidersMapInsensitive.values()) {
            for (ProviderBinding.ProviderInfo<ElementPattern> trinity : new ArrayList<ProviderBinding.ProviderInfo<ElementPattern>>(list)) {
                if (!trinity.provider.equals(provider)) continue;
                list.remove(trinity);
            }
        }
    }

    @Nullable
    protected abstract String getName(@NotNull PsiElement var1);

    static void addMatchingProviders(@NotNull PsiElement position, @Nullable List<ProviderBinding.ProviderInfo<ElementPattern>> providerList, @NotNull Collection<ProviderBinding.ProviderInfo<ProcessingContext>> output, @NotNull PsiReferenceService.Hints hints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addMatchingProviders"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addMatchingProviders"));
        }
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/psi/impl/source/resolve/reference/NamedObjectProviderBinding", "addMatchingProviders"));
        }
        if (providerList == null) {
            return;
        }
        for (int i = 0; i < providerList.size(); ++i) {
            ProviderBinding.ProviderInfo<ElementPattern> info = providerList.get(i);
            if (hints != PsiReferenceService.Hints.NO_HINTS && !info.provider.acceptsHints(position, hints)) continue;
            ProcessingContext context = new ProcessingContext();
            if (hints != PsiReferenceService.Hints.NO_HINTS) {
                context.put(PsiReferenceService.HINTS, hints);
            }
            boolean suitable = false;
            try {
                suitable = ((ElementPattern)info.processingContext).accepts(position, context);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!suitable) continue;
            output.add(new ProviderBinding.ProviderInfo<ProcessingContext>(info.provider, context, info.priority));
        }
    }
}

