/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final Computable<PsiJavaCodeReferenceElement> myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull PsiAnnotation[] annotations) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        super(level, annotations);
        this.myReference = new Computable.PredefinedValueComputable<PsiJavaCodeReferenceElement>(reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        this(new Computable.PredefinedValueComputable<PsiJavaCodeReferenceElement>(reference), level, provider);
    }

    public PsiClassReferenceType(@NotNull Computable<PsiJavaCodeReferenceElement> reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiClassReferenceType", "<init>"));
        }
        super(level, provider);
        this.myReference = reference;
    }

    private static PsiAnnotation[] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        SmartList<PsiAnnotation> result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList<PsiAnnotation>();
            }
            result.add((PsiAnnotation)child);
        }
        return result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
    }

    @Override
    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = this.myReference.compute();
        return reference != null && reference.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/PsiClassReferenceType", "equalsToText"));
        }
        return Comparing.equal(text, this.getCanonicalText());
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getReference().getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            LanguageLevel languageLevel = this.myLanguageLevel;
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getLanguageLevel"));
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(this.getReference());
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/PsiClassReferenceType", "setLanguageLevel"));
        }
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            PsiClassReferenceType psiClassReferenceType = this;
            if (psiClassReferenceType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "setLanguageLevel"));
            }
            return psiClassReferenceType;
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "setLanguageLevel"));
        }
        return psiClassReferenceType;
    }

    @Override
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Override
    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiUtilCore.ensureValid(reference);
        JavaResolveResult result = reference.advancedResolve(false);
        PsiClassType.ClassResolveResult classResolveResult = result.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result);
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "resolveGenerics"));
        }
        return classResolveResult;
    }

    @Override
    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable(aClass).iterator().hasNext()) {
                PsiClassReferenceType psiClassReferenceType = this;
                if (psiClassReferenceType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "rawType"));
                }
                return psiClassReferenceType;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor(aClass);
            PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
            if (psiImmediateClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "rawType"));
            }
            return psiImmediateClassType;
        }
        String qualifiedName = reference.getQualifiedName();
        String name = reference.getReferenceName();
        if (name == null) {
            name = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name, qualifiedName, reference.getResolveScope());
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "rawType"));
        }
        return psiClassReferenceType;
    }

    @Override
    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    @Override
    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.getReference().getTypeParameters();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getParameters"));
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType createImmediateCopy() {
        PsiClassType.ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass element = resolveResult.getElement();
        PsiClassType.Stub stub = element == null ? this : new PsiImmediateClassType(element, resolveResult.getSubstitutor());
        if (stub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "createImmediateCopy"));
        }
        return stub;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiAnnotation[] annotations;
        String presentableText = PsiNameHelper.getPresentableText(this.getReference());
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0) {
            String string = presentableText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getPresentableText"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations, false);
        sb.append(presentableText);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(annotated);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText(true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations.length == 0 ? null : annotations);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ObjectUtils.assertNotNull(this.myReference.compute());
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType", "getReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult", "<init>"));
            }
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.myDelegate.getSubstitutor();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiClassReferenceType$DelegatingClassResolveResult", "getSubstitutor"));
            }
            return psiSubstitutor;
        }

        @Override
        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        @Override
        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        @Override
        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        @Override
        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        @Override
        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        @Override
        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

