/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.concurrent.ConcurrentMap;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AttributesFlyweight {
    private static final ConcurrentMap<FlyweightKey, AttributesFlyweight> entries = ContainerUtil.newConcurrentMap();
    private static final ThreadLocal<FlyweightKey> ourKey = new ThreadLocal();
    private final int myHashCode;
    private final Color myForeground;
    private final Color myBackground;
    @JdkConstants.FontStyle
    private final int myFontType;
    private final Color myEffectColor;
    private final EffectType myEffectType;
    private final Color myErrorStripeColor;
    private static final int EFFECT_BORDER = 0;
    private static final int EFFECT_LINE = 1;
    private static final int EFFECT_WAVE = 2;
    private static final int EFFECT_STRIKEOUT = 3;
    private static final int EFFECT_BOLD_LINE = 4;
    private static final int EFFECT_BOLD_DOTTED_LINE = 5;

    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        FlyweightKey key = ourKey.get();
        if (key == null) {
            key = new FlyweightKey();
            ourKey.set(key);
        }
        key.foreground = foreground;
        key.background = background;
        key.fontType = fontType;
        key.effectColor = effectColor;
        key.effectType = effectType;
        key.errorStripeColor = errorStripeColor;
        AttributesFlyweight flyweight = (AttributesFlyweight)entries.get(key);
        if (flyweight != null) {
            AttributesFlyweight attributesFlyweight = flyweight;
            if (attributesFlyweight == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "create"));
            }
            return attributesFlyweight;
        }
        AttributesFlyweight newValue = new AttributesFlyweight(foreground, background, fontType, effectColor, effectType, errorStripeColor);
        AttributesFlyweight attributesFlyweight = ConcurrencyUtil.cacheOrGet(entries, key.clone(), newValue);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "create"));
        }
        return attributesFlyweight;
    }

    private AttributesFlyweight(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        this.myForeground = foreground;
        this.myBackground = background;
        this.myFontType = fontType;
        this.myEffectColor = effectColor;
        this.myEffectType = effectType;
        this.myErrorStripeColor = errorStripeColor;
        this.myHashCode = AttributesFlyweight.calcHashCode(foreground, background, fontType, effectColor, effectType, errorStripeColor);
    }

    @NotNull
    public static AttributesFlyweight create(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/markup/AttributesFlyweight", "create"));
        }
        Color FOREGROUND = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "FOREGROUND"));
        Color BACKGROUND = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "BACKGROUND"));
        Color EFFECT_COLOR = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "EFFECT_COLOR"));
        Color ERROR_STRIPE_COLOR = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "ERROR_STRIPE_COLOR"));
        int fontType = DefaultJDOMExternalizer.toInt(JDOMExternalizerUtil.readField(element, "FONT_TYPE", "0"));
        if (fontType < 0 || fontType > 3) {
            fontType = 0;
        }
        int FONT_TYPE = fontType;
        int EFFECT_TYPE = DefaultJDOMExternalizer.toInt(JDOMExternalizerUtil.readField(element, "EFFECT_TYPE", "0"));
        AttributesFlyweight attributesFlyweight = AttributesFlyweight.create(FOREGROUND, BACKGROUND, FONT_TYPE, EFFECT_COLOR, AttributesFlyweight.toEffectType(EFFECT_TYPE), ERROR_STRIPE_COLOR);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "create"));
        }
        return attributesFlyweight;
    }

    private static void writeColor(Element element, String fieldName, Color color) {
        if (color != null) {
            String string = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
            JDOMExternalizerUtil.writeField(element, fieldName, string);
        }
    }

    void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/markup/AttributesFlyweight", "writeExternal"));
        }
        AttributesFlyweight.writeColor(element, "FOREGROUND", this.getForeground());
        AttributesFlyweight.writeColor(element, "BACKGROUND", this.getBackground());
        int fontType = this.getFontType();
        if (fontType != 0) {
            JDOMExternalizerUtil.writeField(element, "FONT_TYPE", String.valueOf(fontType));
        }
        AttributesFlyweight.writeColor(element, "EFFECT_COLOR", this.getEffectColor());
        AttributesFlyweight.writeColor(element, "ERROR_STRIPE_COLOR", this.getErrorStripeColor());
        int effectType = AttributesFlyweight.fromEffectType(this.getEffectType());
        if (effectType != 0) {
            JDOMExternalizerUtil.writeField(element, "EFFECT_TYPE", String.valueOf(effectType));
        }
    }

    private static int fromEffectType(EffectType effectType) {
        if (effectType == null) {
            return -1;
        }
        switch (effectType) {
            case BOXED: {
                return 0;
            }
            case LINE_UNDERSCORE: {
                return 1;
            }
            case BOLD_LINE_UNDERSCORE: {
                return 4;
            }
            case STRIKEOUT: {
                return 3;
            }
            case WAVE_UNDERSCORE: {
                return 2;
            }
            case BOLD_DOTTED_LINE: {
                return 5;
            }
        }
        return -1;
    }

    private static EffectType toEffectType(int effectType) {
        switch (effectType) {
            case 0: {
                return EffectType.BOXED;
            }
            case 4: {
                return EffectType.BOLD_LINE_UNDERSCORE;
            }
            case 1: {
                return EffectType.LINE_UNDERSCORE;
            }
            case 3: {
                return EffectType.STRIKEOUT;
            }
            case 2: {
                return EffectType.WAVE_UNDERSCORE;
            }
            case 5: {
                return EffectType.BOLD_DOTTED_LINE;
            }
        }
        return null;
    }

    private static int calcHashCode(Color foreground, Color background, int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        int result = foreground != null ? foreground.hashCode() : 0;
        result = 31 * result + (background != null ? background.hashCode() : 0);
        result = 31 * result + fontType;
        result = 31 * result + (effectColor != null ? effectColor.hashCode() : 0);
        result = 31 * result + (effectType != null ? effectType.hashCode() : 0);
        result = 31 * result + (errorStripeColor != null ? errorStripeColor.hashCode() : 0);
        return result;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myFontType;
    }

    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public EffectType getEffectType() {
        return this.myEffectType;
    }

    public Color getErrorStripeColor() {
        return this.myErrorStripeColor;
    }

    @NotNull
    public AttributesFlyweight withForeground(Color foreground) {
        AttributesFlyweight attributesFlyweight = Comparing.equal(foreground, this.myForeground) ? this : AttributesFlyweight.create(foreground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, this.myErrorStripeColor);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "withForeground"));
        }
        return attributesFlyweight;
    }

    @NotNull
    public AttributesFlyweight withBackground(Color background) {
        AttributesFlyweight attributesFlyweight = Comparing.equal(background, this.myBackground) ? this : AttributesFlyweight.create(this.myForeground, background, this.myFontType, this.myEffectColor, this.myEffectType, this.myErrorStripeColor);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "withBackground"));
        }
        return attributesFlyweight;
    }

    @NotNull
    public AttributesFlyweight withFontType(@JdkConstants.FontStyle int fontType) {
        AttributesFlyweight attributesFlyweight = fontType == this.myFontType ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, fontType, this.myEffectColor, this.myEffectType, this.myErrorStripeColor);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "withFontType"));
        }
        return attributesFlyweight;
    }

    @NotNull
    public AttributesFlyweight withEffectColor(Color effectColor) {
        AttributesFlyweight attributesFlyweight = Comparing.equal(effectColor, this.myEffectColor) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, effectColor, this.myEffectType, this.myErrorStripeColor);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "withEffectColor"));
        }
        return attributesFlyweight;
    }

    @NotNull
    public AttributesFlyweight withEffectType(EffectType effectType) {
        AttributesFlyweight attributesFlyweight = Comparing.equal(effectType, this.myEffectType) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, effectType, this.myErrorStripeColor);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "withEffectType"));
        }
        return attributesFlyweight;
    }

    @NotNull
    public AttributesFlyweight withErrorStripeColor(Color stripeColor) {
        AttributesFlyweight attributesFlyweight = Comparing.equal(stripeColor, this.myErrorStripeColor) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, stripeColor);
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/AttributesFlyweight", "withErrorStripeColor"));
        }
        return attributesFlyweight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesFlyweight that = (AttributesFlyweight)o;
        if (this.myFontType != that.myFontType) {
            return false;
        }
        if (this.myBackground != null ? !this.myBackground.equals(that.myBackground) : that.myBackground != null) {
            return false;
        }
        if (this.myEffectColor != null ? !this.myEffectColor.equals(that.myEffectColor) : that.myEffectColor != null) {
            return false;
        }
        if (this.myEffectType != that.myEffectType) {
            return false;
        }
        if (this.myErrorStripeColor != null ? !this.myErrorStripeColor.equals(that.myErrorStripeColor) : that.myErrorStripeColor != null) {
            return false;
        }
        return !(this.myForeground != null ? !this.myForeground.equals(that.myForeground) : that.myForeground != null);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @NonNls
    public String toString() {
        return "AttributesFlyweight{myForeground=" + this.myForeground + ", myBackground=" + this.myBackground + ", myFontType=" + this.myFontType + ", myEffectColor=" + this.myEffectColor + ", myEffectType=" + (Object)((Object)this.myEffectType) + ", myErrorStripeColor=" + this.myErrorStripeColor + '}';
    }

    private static class FlyweightKey
    implements Cloneable {
        private Color foreground;
        private Color background;
        @JdkConstants.FontStyle
        private int fontType;
        private Color effectColor;
        private EffectType effectType;
        private Color errorStripeColor;

        private FlyweightKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyweightKey)) {
                return false;
            }
            FlyweightKey key = (FlyweightKey)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            if (this.background != null ? !this.background.equals(key.background) : key.background != null) {
                return false;
            }
            if (this.effectColor != null ? !this.effectColor.equals(key.effectColor) : key.effectColor != null) {
                return false;
            }
            if (this.effectType != key.effectType) {
                return false;
            }
            if (this.errorStripeColor != null ? !this.errorStripeColor.equals(key.errorStripeColor) : key.errorStripeColor != null) {
                return false;
            }
            return !(this.foreground != null ? !this.foreground.equals(key.foreground) : key.foreground != null);
        }

        public int hashCode() {
            return AttributesFlyweight.calcHashCode(this.foreground, this.background, this.fontType, this.effectColor, this.effectType, this.errorStripeColor);
        }

        protected FlyweightKey clone() {
            try {
                return (FlyweightKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

