/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    int defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 3;
        } else {
            n4 += 3;
            n5 += 64;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        int n2 = (this.style & 0x200) != 0 ? 108 : 116;
        this.defaultCursor = OS.gdk_cursor_new(n2);
    }

    void drawBand(int n, int n2, int n3, int n4) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        int n5 = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        if (n5 == 0) {
            return;
        }
        byte[] byArray = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int n6 = OS.gdk_bitmap_create_from_data(n5, byArray, 8, 8);
        int n7 = OS.gdk_gc_new(n5);
        int n8 = OS.gdk_colormap_get_system();
        GdkColor gdkColor = new GdkColor();
        OS.gdk_color_white(n8, gdkColor);
        OS.gdk_gc_set_foreground(n7, gdkColor);
        OS.gdk_gc_set_stipple(n7, n6);
        OS.gdk_gc_set_subwindow(n7, 1);
        OS.gdk_gc_set_fill(n7, 2);
        OS.gdk_gc_set_function(n7, 2);
        OS.gdk_draw_rectangle(n5, n7, 1, n, n2, n3, n4);
        OS.g_object_unref(n6);
        OS.g_object_unref(n7);
    }

    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        int n4 = gdkEventButton.button;
        if (n4 != 1) {
            return 0;
        }
        if (gdkEventButton.type == 5) {
            return 0;
        }
        if (gdkEventButton.type == 6) {
            return 0;
        }
        int n5 = OS.GTK_WIDGET_WINDOW(n);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n5, nArray, nArray2);
        this.startX = (int)(gdkEventButton.x_root - (double)nArray[0]);
        this.startY = (int)(gdkEventButton.y_root - (double)nArray2[0]);
        int n6 = OS.GTK_WIDGET_X(this.handle);
        int n7 = OS.GTK_WIDGET_Y(this.handle);
        int n8 = OS.GTK_WIDGET_WIDTH(this.handle);
        int n9 = OS.GTK_WIDGET_HEIGHT(this.handle);
        this.lastX = n6;
        this.lastY = n7;
        Event event = new Event();
        event.time = gdkEventButton.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n8;
        event.height = n9;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - n8 - event.x;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n8 - this.lastX;
            }
            this.parent.update(true, (this.style & 0x10000) == 0);
            this.drawBand(this.lastX, event.y, n8, n9);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, n8, n9);
            }
        }
        return n3;
    }

    int gtk_button_release_event(int n, int n2) {
        int n3 = super.gtk_button_release_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        int n4 = gdkEventButton.button;
        if (n4 != 1) {
            return 0;
        }
        if (!this.dragging) {
            return 0;
        }
        this.dragging = false;
        int n5 = OS.GTK_WIDGET_WIDTH(this.handle);
        int n6 = OS.GTK_WIDGET_HEIGHT(this.handle);
        Event event = new Event();
        event.time = gdkEventButton.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n5;
        event.height = n6;
        this.drawBand(this.lastX, this.lastY, n5, n6);
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - n5 - event.x;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return n3;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, n5, n6);
        }
        return n3;
    }

    int gtk_focus_in_event(int n, int n2) {
        int n3 = super.gtk_focus_in_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if (this.handle != 0) {
            this.lastX = OS.GTK_WIDGET_X(this.handle);
            this.lastY = OS.GTK_WIDGET_Y(this.handle);
        }
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        int n4 = gdkEventKey.keyval;
        switch (n4) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int n5 = 0;
                int n6 = 0;
                int n7 = 9;
                if ((gdkEventKey.state & 4) != 0) {
                    n7 = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (n4 == 65362 || n4 == 65364) break;
                    n5 = n4 == 65361 ? -n7 : n7;
                } else {
                    if (n4 == 65361 || n4 == 65363) break;
                    n6 = n4 == 65362 ? -n7 : n7;
                }
                int n8 = OS.GTK_WIDGET_WIDTH(this.handle);
                int n9 = OS.GTK_WIDGET_HEIGHT(this.handle);
                int n10 = 0;
                int n11 = OS.GTK_WIDGET_WIDTH(this.parent.handle);
                int n12 = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
                int n13 = this.lastX;
                int n14 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n13 = Math.min(Math.max(0, this.lastX + n5 - n10 - this.startX), n11 - n8);
                } else {
                    n14 = Math.min(Math.max(0, this.lastY + n6 - n10 - this.startY), n12 - n9);
                }
                if (n13 == this.lastX && n14 == this.lastY) {
                    return n3;
                }
                int n15 = OS.GTK_WIDGET_WINDOW(this.handle);
                int n16 = 516;
                int n17 = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int n18 = OS.gdk_pointer_grab(n15, false, n16, n15, n17, 0);
                Event event = new Event();
                event.time = gdkEventKey.time;
                event.x = n13;
                event.y = n14;
                event.width = n8;
                event.height = n9;
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = this.parent.getClientWidth() - n8 - event.x;
                }
                this.sendEvent(13, event);
                if (n18 == 0) {
                    OS.gdk_pointer_ungrab(0);
                }
                if (this.isDisposed() || !event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - n8 - this.lastX;
                }
                if ((this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, n8, n9);
                    if (this.isDisposed()) break;
                }
                int n19 = event.x;
                int n20 = event.y;
                if ((this.style & 0x200) != 0) {
                    n20 += n9 / 2;
                } else {
                    n19 += n8 / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(n19, n20));
            }
        }
        return n3;
    }

    int gtk_motion_notify_event(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int[] nArray2;
        int n6 = super.gtk_motion_notify_event(n, n2);
        if (n6 != 0) {
            return n6;
        }
        if (!this.dragging) {
            return 0;
        }
        GdkEventMotion gdkEventMotion = new GdkEventMotion();
        OS.memmove(gdkEventMotion, n2, GdkEventButton.sizeof);
        if (gdkEventMotion.is_hint != 0) {
            nArray2 = new int[1];
            nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gdk_window_get_pointer(gdkEventMotion.window, nArray2, nArray, nArray3);
            n5 = nArray2[0];
            n4 = nArray[0];
            n3 = nArray3[0];
        } else {
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(gdkEventMotion.window, nArray2, nArray);
            n5 = (int)(gdkEventMotion.x_root - (double)nArray2[0]);
            n4 = (int)(gdkEventMotion.y_root - (double)nArray[0]);
            n3 = gdkEventMotion.state;
        }
        if ((n3 & 0x100) == 0) {
            return 0;
        }
        int n7 = OS.GTK_WIDGET_X(this.handle);
        int n8 = OS.GTK_WIDGET_Y(this.handle);
        int n9 = OS.GTK_WIDGET_WIDTH(this.handle);
        int n10 = OS.GTK_WIDGET_HEIGHT(this.handle);
        int n11 = 0;
        int n12 = OS.GTK_WIDGET_WIDTH(this.parent.handle);
        int n13 = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
        int n14 = this.lastX;
        int n15 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n14 = Math.min(Math.max(0, n5 + n7 - this.startX - n11), n12 - n9);
        } else {
            n15 = Math.min(Math.max(0, n4 + n8 - this.startY - n11), n13 - n10);
        }
        if (n14 == this.lastX && n15 == this.lastY) {
            return 0;
        }
        this.drawBand(this.lastX, this.lastY, n9, n10);
        Event event = new Event();
        event.time = gdkEventMotion.time;
        event.x = n14;
        event.y = n15;
        event.width = n9;
        event.height = n10;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - n9 - event.x;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - n9 - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        this.drawBand(this.lastX, this.lastY, n9, n10);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(event.x, this.lastY, n9, n10);
        }
        return n6;
    }

    int gtk_realize(int n) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0);
        return super.gtk_realize(n);
    }

    void hookEvents() {
        super.hookEvents();
        OS.gtk_widget_add_events(this.handle, 8);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0) {
            OS.gdk_cursor_destroy(this.defaultCursor);
        }
        this.defaultCursor = 0;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void setCursor(int n) {
        super.setCursor(n != 0 ? n : this.defaultCursor);
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        return 0;
    }
}

