/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public abstract class SdkPackagesAction
extends SdkAction {
    private static final String PKG_FILE_ARG = "--package_file=";
    private List<String> mPackages = new ArrayList<String>();

    SdkPackagesAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    protected boolean applyPackageOperation(PackageOperation operation, ProgressIndicator progress) {
        return operation.prepare(progress.createSubProgress(0.5)) && operation.complete(progress.createSubProgress(1.0));
    }

    @Override
    boolean consumeArgument(String arg, ProgressIndicator progress) {
        if (arg.startsWith(PKG_FILE_ARG)) {
            String packageFile = arg.substring(PKG_FILE_ARG.length());
            try {
                this.mPackages.addAll(Files.readAllLines(this.mSettings.getFileSystem().getPath(packageFile, new String[0])));
            }
            catch (IOException e) {
                progress.logWarning(String.format("Invalid package file \"%s\" threw exception:%n%s%n", packageFile, e));
                return true;
            }
        } else if (!arg.startsWith("--")) {
            this.mPackages.add(arg);
            return true;
        }
        return false;
    }

    public List<String> getPaths(RepoManager mgr) {
        return this.mPackages;
    }
}

