/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.BlankMethodItem;
import org.jf.baksmali.Adaptors.CatchMethodItem;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Adaptors.CommentMethodItem;
import org.jf.baksmali.Adaptors.CommentedOutMethodItem;
import org.jf.baksmali.Adaptors.Debug.DebugMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItemFactory;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.PostInstructionRegisterInfoMethodItem;
import org.jf.baksmali.Adaptors.PreInstructionRegisterInfoMethodItem;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.Adaptors.SyntheticAccessCommentMethodItem;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.analysis.AnalysisException;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.analysis.MethodAnalyzer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction31t;
import org.jf.dexlib2.util.InstructionOffsetMap;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.util.SyntheticAccessorResolver;
import org.jf.dexlib2.util.TypeUtils;
import org.jf.util.ExceptionWithContext;
import org.jf.util.IndentingWriter;
import org.jf.util.SparseIntArray;

public class MethodDefinition {
    @Nonnull
    public final ClassDefinition classDef;
    @Nonnull
    public final Method method;
    @Nonnull
    public final MethodImplementation methodImpl;
    @Nonnull
    public final ImmutableList<Instruction> instructions;
    @Nonnull
    public final List<Instruction> effectiveInstructions;
    @Nonnull
    public final ImmutableList<MethodParameter> methodParameters;
    public RegisterFormatter registerFormatter;
    @Nonnull
    private final LabelCache labelCache = new LabelCache();
    @Nonnull
    private final SparseIntArray packedSwitchMap;
    @Nonnull
    private final SparseIntArray sparseSwitchMap;
    @Nonnull
    private final InstructionOffsetMap instructionOffsetMap;

    public MethodDefinition(@Nonnull ClassDefinition classDef, @Nonnull Method method, @Nonnull MethodImplementation methodImpl) {
        this.classDef = classDef;
        this.method = method;
        this.methodImpl = methodImpl;
        try {
            this.instructions = ImmutableList.copyOf((Iterable)methodImpl.getInstructions());
            this.methodParameters = ImmutableList.copyOf((Collection)method.getParameters());
            this.effectiveInstructions = Lists.newArrayList(this.instructions);
            this.packedSwitchMap = new SparseIntArray(0);
            this.sparseSwitchMap = new SparseIntArray(0);
            this.instructionOffsetMap = new InstructionOffsetMap(this.instructions);
            int endOffset = this.instructionOffsetMap.getInstructionCodeOffset(this.instructions.size() - 1) + ((Instruction)this.instructions.get(this.instructions.size() - 1)).getCodeUnits();
            for (int i = 0; i < this.instructions.size(); ++i) {
                Instruction payloadInstruction;
                int targetOffset;
                int codeOffset;
                boolean valid;
                Instruction instruction = (Instruction)this.instructions.get(i);
                Opcode opcode = instruction.getOpcode();
                if (opcode == Opcode.PACKED_SWITCH) {
                    valid = true;
                    codeOffset = this.instructionOffsetMap.getInstructionCodeOffset(i);
                    targetOffset = codeOffset + ((OffsetInstruction)instruction).getCodeOffset();
                    try {
                        targetOffset = this.findPayloadOffset(targetOffset, Opcode.PACKED_SWITCH_PAYLOAD);
                    }
                    catch (InvalidSwitchPayload ex) {
                        valid = false;
                    }
                    if (!valid) continue;
                    if (this.packedSwitchMap.get(targetOffset, -1) != -1) {
                        payloadInstruction = this.findSwitchPayload(targetOffset, Opcode.PACKED_SWITCH_PAYLOAD);
                        targetOffset = endOffset;
                        this.effectiveInstructions.set(i, (Instruction)new ImmutableInstruction31t(opcode, ((Instruction31t)instruction).getRegisterA(), targetOffset - codeOffset));
                        this.effectiveInstructions.add(payloadInstruction);
                        endOffset += payloadInstruction.getCodeUnits();
                    }
                    this.packedSwitchMap.append(targetOffset, codeOffset);
                    continue;
                }
                if (opcode != Opcode.SPARSE_SWITCH) continue;
                valid = true;
                codeOffset = this.instructionOffsetMap.getInstructionCodeOffset(i);
                targetOffset = codeOffset + ((OffsetInstruction)instruction).getCodeOffset();
                try {
                    targetOffset = this.findPayloadOffset(targetOffset, Opcode.SPARSE_SWITCH_PAYLOAD);
                }
                catch (InvalidSwitchPayload ex) {
                    valid = false;
                }
                if (!valid) continue;
                if (this.sparseSwitchMap.get(targetOffset, -1) != -1) {
                    payloadInstruction = this.findSwitchPayload(targetOffset, Opcode.SPARSE_SWITCH_PAYLOAD);
                    targetOffset = endOffset;
                    this.effectiveInstructions.set(i, (Instruction)new ImmutableInstruction31t(opcode, ((Instruction31t)instruction).getRegisterA(), targetOffset - codeOffset));
                    this.effectiveInstructions.add(payloadInstruction);
                    endOffset += payloadInstruction.getCodeUnits();
                }
                this.sparseSwitchMap.append(targetOffset, codeOffset);
            }
        }
        catch (Exception ex) {
            String methodString;
            try {
                methodString = ReferenceUtil.getMethodDescriptor((MethodReference)method);
            }
            catch (Exception ex2) {
                throw ExceptionWithContext.withContext((Throwable)ex, (String)"Error while processing method", (Object[])new Object[0]);
            }
            throw ExceptionWithContext.withContext((Throwable)ex, (String)"Error while processing method %s", (Object[])new Object[]{methodString});
        }
    }

    public static void writeEmptyMethodTo(IndentingWriter writer, Method method, BaksmaliOptions options) throws IOException {
        writer.write(".method ");
        MethodDefinition.writeAccessFlags(writer, method.getAccessFlags());
        writer.write(method.getName());
        writer.write("(");
        ImmutableList methodParameters = ImmutableList.copyOf((Collection)method.getParameters());
        for (MethodParameter parameter : methodParameters) {
            writer.write(parameter.getType());
        }
        writer.write(")");
        writer.write(method.getReturnType());
        writer.write(10);
        writer.indent(4);
        MethodDefinition.writeParameters(writer, method, (List<? extends MethodParameter>)methodParameters, options);
        String containingClass = null;
        if (options.implicitReferences) {
            containingClass = method.getDefiningClass();
        }
        AnnotationFormatter.writeTo(writer, method.getAnnotations(), containingClass);
        writer.deindent(4);
        writer.write(".end method\n");
    }

    public void writeTo(IndentingWriter writer) throws IOException {
        int parameterRegisterCount = 0;
        if (!AccessFlags.STATIC.isSet(this.method.getAccessFlags())) {
            ++parameterRegisterCount;
        }
        writer.write(".method ");
        MethodDefinition.writeAccessFlags(writer, this.method.getAccessFlags());
        writer.write(this.method.getName());
        writer.write("(");
        for (MethodParameter parameter : this.methodParameters) {
            String type = parameter.getType();
            writer.write(type);
            ++parameterRegisterCount;
            if (!TypeUtils.isWideType((String)type)) continue;
            ++parameterRegisterCount;
        }
        writer.write(")");
        writer.write(this.method.getReturnType());
        writer.write(10);
        writer.indent(4);
        if (this.classDef.options.localsDirective) {
            writer.write(".locals ");
            writer.printSignedIntAsDec(this.methodImpl.getRegisterCount() - parameterRegisterCount);
        } else {
            writer.write(".registers ");
            writer.printSignedIntAsDec(this.methodImpl.getRegisterCount());
        }
        writer.write(10);
        MethodDefinition.writeParameters(writer, this.method, this.methodParameters, this.classDef.options);
        if (this.registerFormatter == null) {
            this.registerFormatter = new RegisterFormatter(this.classDef.options, this.methodImpl.getRegisterCount(), parameterRegisterCount);
        }
        String containingClass = null;
        if (this.classDef.options.implicitReferences) {
            containingClass = this.method.getDefiningClass();
        }
        AnnotationFormatter.writeTo(writer, this.method.getAnnotations(), containingClass);
        writer.write(10);
        List<MethodItem> methodItems = this.getMethodItems();
        for (MethodItem methodItem : methodItems) {
            if (!methodItem.writeTo(writer)) continue;
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end method\n");
    }

    public Instruction findSwitchPayload(int targetOffset, Opcode type) {
        int targetIndex;
        try {
            targetIndex = this.instructionOffsetMap.getInstructionIndexAtCodeOffset(targetOffset);
        }
        catch (InstructionOffsetMap.InvalidInstructionOffset ex) {
            throw new InvalidSwitchPayload(targetOffset);
        }
        Instruction instruction = (Instruction)this.instructions.get(targetIndex);
        if (instruction.getOpcode() != type) {
            if (instruction.getOpcode() == Opcode.NOP && ++targetIndex < this.instructions.size() && (instruction = (Instruction)this.instructions.get(targetIndex)).getOpcode() == type) {
                return instruction;
            }
            throw new InvalidSwitchPayload(targetOffset);
        }
        return instruction;
    }

    public int findPayloadOffset(int targetOffset, Opcode type) {
        int targetIndex;
        try {
            targetIndex = this.instructionOffsetMap.getInstructionIndexAtCodeOffset(targetOffset);
        }
        catch (InstructionOffsetMap.InvalidInstructionOffset ex) {
            throw new InvalidSwitchPayload(targetOffset);
        }
        Instruction instruction = (Instruction)this.instructions.get(targetIndex);
        if (instruction.getOpcode() != type) {
            if (instruction.getOpcode() == Opcode.NOP && ++targetIndex < this.instructions.size() && (instruction = (Instruction)this.instructions.get(targetIndex)).getOpcode() == type) {
                return this.instructionOffsetMap.getInstructionCodeOffset(targetIndex);
            }
            throw new InvalidSwitchPayload(targetOffset);
        }
        return targetOffset;
    }

    private static void writeAccessFlags(IndentingWriter writer, int accessFlags) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForMethod((int)accessFlags)) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }

    private static void writeParameters(IndentingWriter writer, Method method, List<? extends MethodParameter> parameters, BaksmaliOptions options) throws IOException {
        boolean isStatic = AccessFlags.STATIC.isSet(method.getAccessFlags());
        int registerNumber = isStatic ? 0 : 1;
        for (MethodParameter methodParameter : parameters) {
            String parameterType = methodParameter.getType();
            String parameterName = methodParameter.getName();
            Set annotations = methodParameter.getAnnotations();
            if (options.debugInfo && parameterName != null || annotations.size() != 0) {
                writer.write(".param p");
                writer.printSignedIntAsDec(registerNumber);
                if (parameterName != null && options.debugInfo) {
                    writer.write(", ");
                    ReferenceFormatter.writeStringReference(writer, parameterName);
                }
                writer.write("    # ");
                writer.write(parameterType);
                writer.write("\n");
                if (annotations.size() > 0) {
                    writer.indent(4);
                    String containingClass = null;
                    if (options.implicitReferences) {
                        containingClass = method.getDefiningClass();
                    }
                    AnnotationFormatter.writeTo(writer, annotations, containingClass);
                    writer.deindent(4);
                    writer.write(".end param\n");
                }
            }
            ++registerNumber;
            if (!TypeUtils.isWideType((String)parameterType)) continue;
            ++registerNumber;
        }
    }

    @Nonnull
    public LabelCache getLabelCache() {
        return this.labelCache;
    }

    public int getPackedSwitchBaseAddress(int packedSwitchPayloadCodeOffset) {
        return this.packedSwitchMap.get(packedSwitchPayloadCodeOffset, -1);
    }

    public int getSparseSwitchBaseAddress(int sparseSwitchPayloadCodeOffset) {
        return this.sparseSwitchMap.get(sparseSwitchPayloadCodeOffset, -1);
    }

    private List<MethodItem> getMethodItems() {
        ArrayList<MethodItem> methodItems = new ArrayList<MethodItem>();
        if (this.classDef.options.registerInfo != 0 || this.classDef.options.normalizeVirtualMethods || this.classDef.options.deodex && this.needsAnalyzed()) {
            this.addAnalyzedInstructionMethodItems(methodItems);
        } else {
            this.addInstructionMethodItems(methodItems);
        }
        this.addTries(methodItems);
        if (this.classDef.options.debugInfo) {
            this.addDebugInfo(methodItems);
        }
        if (this.classDef.options.sequentialLabels) {
            this.setLabelSequentialNumbers();
        }
        for (LabelMethodItem labelMethodItem : this.labelCache.getLabels()) {
            methodItems.add(labelMethodItem);
        }
        Collections.sort(methodItems);
        return methodItems;
    }

    private boolean needsAnalyzed() {
        for (Instruction instruction : this.methodImpl.getInstructions()) {
            if (!instruction.getOpcode().odexOnly()) continue;
            return true;
        }
        return false;
    }

    private void addInstructionMethodItems(List<MethodItem> methodItems) {
        int currentCodeAddress = 0;
        for (int i = 0; i < this.effectiveInstructions.size(); ++i) {
            Instruction instruction = this.effectiveInstructions.get(i);
            InstructionMethodItem methodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, currentCodeAddress, instruction);
            methodItems.add(methodItem);
            if (i != this.effectiveInstructions.size() - 1) {
                methodItems.add(new BlankMethodItem(currentCodeAddress));
            }
            if (this.classDef.options.codeOffsets) {
                methodItems.add(new MethodItem(currentCodeAddress){

                    @Override
                    public double getSortOrder() {
                        return -1000.0;
                    }

                    @Override
                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        writer.write("#@");
                        writer.printUnsignedLongAsHex((long)this.codeAddress & 0xFFFFFFFFL);
                        return true;
                    }
                });
            }
            if (this.classDef.options.accessorComments && this.classDef.options.syntheticAccessorResolver != null && instruction instanceof ReferenceInstruction) {
                Opcode opcode = instruction.getOpcode();
                if (opcode.referenceType == 3) {
                    SyntheticAccessorResolver.AccessedMember accessedMember;
                    MethodReference methodReference = null;
                    try {
                        methodReference = (MethodReference)((ReferenceInstruction)instruction).getReference();
                    }
                    catch (DexBackedDexFile.InvalidItemIndex invalidItemIndex) {
                        // empty catch block
                    }
                    if (methodReference != null && SyntheticAccessorResolver.looksLikeSyntheticAccessor((String)methodReference.getName()) && (accessedMember = this.classDef.options.syntheticAccessorResolver.getAccessedMember(methodReference)) != null) {
                        methodItems.add(new SyntheticAccessCommentMethodItem(accessedMember, currentCodeAddress));
                    }
                }
            }
            currentCodeAddress += instruction.getCodeUnits();
        }
    }

    private void addAnalyzedInstructionMethodItems(List<MethodItem> methodItems) {
        MethodAnalyzer methodAnalyzer = new MethodAnalyzer(this.classDef.options.classPath, this.method, this.classDef.options.inlineResolver, this.classDef.options.normalizeVirtualMethods);
        AnalysisException analysisException = methodAnalyzer.getAnalysisException();
        if (analysisException != null) {
            methodItems.add(new CommentMethodItem(String.format("AnalysisException: %s", analysisException.getMessage()), analysisException.codeAddress, -2.147483648E9));
            analysisException.printStackTrace(System.err);
        }
        List instructions = methodAnalyzer.getAnalyzedInstructions();
        int currentCodeAddress = 0;
        for (int i = 0; i < instructions.size(); ++i) {
            AnalyzedInstruction instruction = (AnalyzedInstruction)instructions.get(i);
            InstructionMethodItem methodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, currentCodeAddress, instruction.getInstruction());
            methodItems.add(methodItem);
            if (instruction.getInstruction().getOpcode().format == Format.UnresolvedOdexInstruction) {
                methodItems.add(new CommentedOutMethodItem(InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, currentCodeAddress, instruction.getOriginalInstruction())));
            }
            if (i != instructions.size() - 1) {
                methodItems.add(new BlankMethodItem(currentCodeAddress));
            }
            if (this.classDef.options.codeOffsets) {
                methodItems.add(new MethodItem(currentCodeAddress){

                    @Override
                    public double getSortOrder() {
                        return -1000.0;
                    }

                    @Override
                    public boolean writeTo(IndentingWriter writer) throws IOException {
                        writer.write("#@");
                        writer.printUnsignedLongAsHex((long)this.codeAddress & 0xFFFFFFFFL);
                        return true;
                    }
                });
            }
            if (this.classDef.options.registerInfo != 0 && !instruction.getInstruction().getOpcode().format.isPayloadFormat) {
                methodItems.add(new PreInstructionRegisterInfoMethodItem(this.classDef.options.registerInfo, methodAnalyzer, this.registerFormatter, instruction, currentCodeAddress));
                methodItems.add(new PostInstructionRegisterInfoMethodItem(this.registerFormatter, instruction, currentCodeAddress));
            }
            currentCodeAddress += instruction.getInstruction().getCodeUnits();
        }
    }

    private void addTries(List<MethodItem> methodItems) {
        List tryBlocks = this.methodImpl.getTryBlocks();
        if (tryBlocks.size() == 0) {
            return;
        }
        int lastInstructionAddress = this.instructionOffsetMap.getInstructionCodeOffset(this.instructions.size() - 1);
        int codeSize = lastInstructionAddress + ((Instruction)this.instructions.get(this.instructions.size() - 1)).getCodeUnits();
        for (TryBlock tryBlock : tryBlocks) {
            int startAddress = tryBlock.getStartCodeAddress();
            int endAddress = startAddress + tryBlock.getCodeUnitCount();
            if (startAddress >= codeSize) {
                throw new RuntimeException(String.format("Try start offset %d is past the end of the code block.", startAddress));
            }
            if (endAddress > codeSize) {
                throw new RuntimeException(String.format("Try end offset %d is past the end of the code block.", endAddress));
            }
            int lastCoveredIndex = this.instructionOffsetMap.getInstructionIndexAtCodeOffset(endAddress - 1, false);
            int lastCoveredAddress = this.instructionOffsetMap.getInstructionCodeOffset(lastCoveredIndex);
            for (ExceptionHandler handler : tryBlock.getExceptionHandlers()) {
                int handlerAddress = handler.getHandlerCodeAddress();
                if (handlerAddress >= codeSize) {
                    throw new ExceptionWithContext("Exception handler offset %d is past the end of the code block.", new Object[]{handlerAddress});
                }
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.classDef.options, this.labelCache, lastCoveredAddress, handler.getExceptionType(), startAddress, endAddress, handlerAddress);
                methodItems.add(catchMethodItem);
            }
        }
    }

    private void addDebugInfo(List<MethodItem> methodItems) {
        for (DebugItem debugItem : this.methodImpl.getDebugItems()) {
            methodItems.add(DebugMethodItem.build(this.registerFormatter, debugItem));
        }
    }

    private void setLabelSequentialNumbers() {
        HashMap<String, Integer> nextLabelSequenceByType = new HashMap<String, Integer>();
        ArrayList<LabelMethodItem> sortedLabels = new ArrayList<LabelMethodItem>(this.labelCache.getLabels());
        Collections.sort(sortedLabels);
        for (LabelMethodItem labelMethodItem : sortedLabels) {
            Integer labelSequence = (Integer)nextLabelSequenceByType.get(labelMethodItem.getLabelPrefix());
            if (labelSequence == null) {
                labelSequence = 0;
            }
            labelMethodItem.setLabelSequence(labelSequence);
            nextLabelSequenceByType.put(labelMethodItem.getLabelPrefix(), labelSequence + 1);
        }
    }

    @Nullable
    private String getContainingClassForImplicitReference() {
        if (this.classDef.options.implicitReferences) {
            return this.classDef.classDef.getType();
        }
        return null;
    }

    public static class InvalidSwitchPayload
    extends ExceptionWithContext {
        private final int payloadOffset;

        public InvalidSwitchPayload(int payloadOffset) {
            super("No switch payload at offset: %d", new Object[]{payloadOffset});
            this.payloadOffset = payloadOffset;
        }

        public int getPayloadOffset() {
            return this.payloadOffset;
        }
    }

    public static class LabelCache {
        protected HashMap<LabelMethodItem, LabelMethodItem> labels = new HashMap();

        public LabelMethodItem internLabel(LabelMethodItem labelMethodItem) {
            LabelMethodItem internedLabelMethodItem = this.labels.get(labelMethodItem);
            if (internedLabelMethodItem != null) {
                return internedLabelMethodItem;
            }
            this.labels.put(labelMethodItem, labelMethodItem);
            return labelMethodItem;
        }

        public Collection<LabelMethodItem> getLabels() {
            return this.labels.values();
        }
    }
}

