/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class SystraceOutputParser {
    private static final String TRACE_START = "TRACE:\n";
    private final boolean mHasCrLf;
    private final boolean mUncompress;
    private final String mSystraceHtml;
    private final String mHtmlPrefix;
    private final String mHtmlSuffix;
    private byte[] mAtraceOutput;
    private int mAtraceLength;
    private int mSystraceIndex = -1;
    private static final String[] sAssetSubdirPath = new String[]{"catapult", "systrace", "systrace"};

    public SystraceOutputParser(String apiLevel, boolean compressedStream, String systraceHtml, String htmlPrefix, String htmlSuffix) {
        int api;
        try {
            api = Integer.parseInt(apiLevel);
        }
        catch (NumberFormatException numberFormatException) {
            api = 1;
        }
        this.mHasCrLf = api < 24;
        this.mUncompress = compressedStream;
        this.mSystraceHtml = systraceHtml;
        this.mHtmlPrefix = htmlPrefix;
        this.mHtmlSuffix = htmlSuffix;
    }

    public void parse(byte[] atraceOutput) {
        this.mAtraceOutput = atraceOutput;
        this.mAtraceLength = atraceOutput.length;
        if (this.mHasCrLf) {
            this.removeCrLf();
        }
        String header = new String(this.mAtraceOutput, 0, Math.min(100, this.mAtraceLength));
        this.mSystraceIndex = this.locateSystraceData(header);
        if (this.mSystraceIndex < 0) {
            throw new RuntimeException("Unable to find trace start marker 'TRACE:':\n" + header);
        }
    }

    private void removeCrLf() {
        int dst = 0;
        int src = 0;
        while (src < this.mAtraceLength - 1) {
            int copy;
            if (this.mAtraceOutput[src] == 13 && this.mAtraceOutput[src + 1] == 10) {
                copy = 10;
                ++src;
            } else {
                copy = this.mAtraceOutput[src];
            }
            this.mAtraceOutput[dst] = copy;
            ++src;
            ++dst;
        }
        this.mAtraceLength = dst;
    }

    private int locateSystraceData(String header) {
        int index = header.indexOf(TRACE_START);
        if (index < 0) {
            return -1;
        }
        return index + TRACE_START.length();
    }

    public String getSystraceHtml() {
        if (this.mSystraceIndex < 0) {
            return "";
        }
        String trace = "";
        if (this.mUncompress) {
            Inflater decompressor = new Inflater();
            decompressor.setInput(this.mAtraceOutput, this.mSystraceIndex, this.mAtraceLength - this.mSystraceIndex);
            byte[] buf = new byte[4096];
            StringBuilder sb = new StringBuilder(1000);
            try {
                int n;
                while ((n = decompressor.inflate(buf)) > 0) {
                    sb.append(new String(buf, 0, n));
                }
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e);
            }
            decompressor.end();
            trace = sb.toString();
        } else {
            trace = new String(this.mAtraceOutput, this.mSystraceIndex, this.mAtraceLength - this.mSystraceIndex);
        }
        StringBuilder html = new StringBuilder(this.mHtmlPrefix.replace("{{SYSTRACE_TRACE_VIEWER_HTML}}", this.mSystraceHtml));
        html.append("<!-- BEGIN TRACE -->\n");
        html.append("  <script class=\"trace-data\" type=\"application/text\">\n");
        html.append(trace);
        html.append("  </script>\n<!-- END TRACE -->\n");
        html.append(this.mHtmlSuffix);
        return html.toString();
    }

    public static String getSystraceHtml(File assetsFolder) {
        return SystraceOutputParser.getHtmlTemplate(assetsFolder, "systrace_trace_viewer.html");
    }

    public static String getHtmlPrefix(File assetsFolder) {
        return SystraceOutputParser.getHtmlTemplate(assetsFolder, "prefix.html");
    }

    public static String getHtmlSuffix(File assetsFolder) {
        return SystraceOutputParser.getHtmlTemplate(assetsFolder, "suffix.html");
    }

    private static String getHtmlTemplate(File assetsFolder, String htmlFileName) {
        try {
            File searchFolder = assetsFolder;
            File target = new File(searchFolder, htmlFileName);
            if (!target.exists()) {
                String[] stringArray = sAssetSubdirPath;
                int n = sAssetSubdirPath.length;
                int n2 = 0;
                while (n2 < n) {
                    String subdir = stringArray[n2];
                    if (!(searchFolder = new File(searchFolder, subdir)).isDirectory() || (target = new File(searchFolder, htmlFileName)).exists()) break;
                    ++n2;
                }
            }
            return Files.toString((File)target, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

