/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.internal.SigUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.util.IndentingWriter;

public class DexDisassembler {
    private final DexBackedDexFile dexFile;

    public DexDisassembler(DexBackedDexFile dexFile) {
        this.dexFile = dexFile;
    }

    public String disassembleMethod(String fqcn, String methodDescriptor) throws IOException {
        Optional<? extends DexBackedClassDef> classDef = this.getClassDef(fqcn);
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        Optional<DexBackedMethod> method = StreamSupport.stream(classDef.get().getMethods().spliterator(), false).filter(m -> methodDescriptor.equals(ReferenceUtil.getMethodDescriptor(m))).findFirst();
        if (!method.isPresent()) {
            throw new IllegalStateException("Unable to locate method definition in class for method " + methodDescriptor);
        }
        BaksmaliOptions options = new BaksmaliOptions();
        ClassDefinition classDefinition = new ClassDefinition(options, classDef.get());
        StringWriter writer = new StringWriter(1024);
        try (IndentingWriter iw = new IndentingWriter((Writer)writer);){
            DexBackedMethodImplementation methodImpl = method.get().getImplementation();
            if (methodImpl == null) {
                MethodDefinition.writeEmptyMethodTo(iw, method.get(), options);
            } else {
                MethodDefinition methodDefinition = new MethodDefinition(classDefinition, method.get(), methodImpl);
                methodDefinition.writeTo(iw);
            }
        }
        return writer.toString().replace("\r", "");
    }

    public String disassembleClass(String fqcn) throws IOException {
        Optional<? extends DexBackedClassDef> classDef = this.getClassDef(fqcn);
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        BaksmaliOptions options = new BaksmaliOptions();
        ClassDefinition classDefinition = new ClassDefinition(options, classDef.get());
        StringWriter writer = new StringWriter(1024);
        try (IndentingWriter iw = new IndentingWriter((Writer)writer);){
            classDefinition.writeTo(iw);
        }
        return writer.toString().replace("\r", "");
    }

    private Optional<? extends DexBackedClassDef> getClassDef(String fqcn) {
        return this.dexFile.getClasses().stream().filter(c -> fqcn.equals(SigUtils.signatureToName(c.getType()))).findFirst();
    }
}

