#!/bin/bash

# SPDX-FileCopyrightText: Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction,
# disclosure or distribution of this material and related documentation
# without an express license agreement from NVIDIA CORPORATION or
# its affiliates is strictly prohibited.

set -e
set -x

VERSION="0.3.8"

SCRIPT=$(readlink -f $0)
HERE=$(dirname $SCRIPT)

if [ -z "$GITLAB_TOKEN" ]; then
    echo "Error: GITLAB_TOKEN is not set"
    exit 1
fi

BUILD_RELATIVE_DIR="build"
BUILD_DIR="$HERE/$BUILD_RELATIVE_DIR"
rm -rf "$BUILD_DIR"
mkdir -p "$BUILD_DIR"
wget --header="PRIVATE-TOKEN: ${GITLAB_TOKEN}" \
    https://gitlab-master.nvidia.com/agora/external/xf86-video-dummy/-/archive/$VERSION/xf86-video-dummy-$VERSION.tar.gz \
    -O "$BUILD_DIR/xf86-video-dummy-$VERSION.tar.gz"

# Destination binary name (optional argument)
DESTINATION_BINARY_FILENAME=${1:-"$(pwd)/dummy_drv.so"}
# Destination source archive name (optional argument)
DESTINATION_SOURCE_ARCHIVE_FILENAME=${2:-"$(pwd)/xf86-video-dummy-source.tar.gz"}
# Docker image name
IMAGE_NAME="nvidia/xf86-video-dummy-builder:$VERSION"
# File to be copied from the image
INNER_ARCHIVE_PATH="/source/src/dummy_drv.so"

# Build the Docker image
docker build -f "${HERE}/Dockerfile" --build-arg SOURCE_ARCHIVE="$BUILD_RELATIVE_DIR/xf86-video-dummy-$VERSION.tar.gz" -t "$IMAGE_NAME" "$HERE"

# Create a temporary container from the image
TEMP_CONTAINER=$(docker create "$IMAGE_NAME")

# Copy the file from the container to the host destination directory
docker cp "$TEMP_CONTAINER:$INNER_ARCHIVE_PATH" "$DESTINATION_BINARY_FILENAME"

# Remove the temporary container
docker rm "$TEMP_CONTAINER"

cp "$BUILD_DIR/xf86-video-dummy-$VERSION.tar.gz" "$DESTINATION_SOURCE_ARCHIVE_FILENAME"

echo "Binary copied to $DESTINATION_BINARY_FILENAME"
echo "Source archive copied to $DESTINATION_SOURCE_ARCHIVE_FILENAME"
