# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


# Copyright (c) 2024-2025, NVIDIA CORPORATION. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#  * Neither the name of NVIDIA CORPORATION nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



def get_gpu_data(major: int, minor: int) -> dict:
    """
    Get the GPU data for the given compute capability version.

    Args:
        major (:class:`int`): The major compute capability version of the GPU.
        minor (:class:`int`): The minor compute capability version of the GPU.

    Returns:
        :class:`dict`: The GPU data for the given compute capability version. The dictionary contains the following key-value pairs:
            - 'cc_major': (:class:`int`) The major compute capability version of the GPU.
            - 'cc_minor': (:class:`int`) The minor compute capability version of the GPU.
            - 'sm_version': (:class:`str`) The SM version of the GPU.
            - 'threads_per_warp': (:class:`int`) The number of threads per warp.
            - 'max_warps_per_sm': (:class:`int`) The number of warps per SM.
            - 'max_threads_per_sm': (:class:`int`) The number of threads per SM.
            - 'max_thread_blocks_per_sm': (:class:`int`) The number of thread blocks per SM.
            - 'block_barriers_per_sm': (:class:`int`) The number of block barriers per SM.
            - 'smem_per_sm': (:class:`int`) The shared memory (bytes) per SM.
            - 'max_shared_mem_per_block': (:class:`int`) The maximum shared memory (bytes) per block.
            - 'registers_per_sm': (:class:`int`) The registers per SM.
            - 'max_regs_per_block': (:class:`int`) The maximum registers per block.
            - 'max_regs_per_thread': (:class:`int`) The maximum registers per thread.
            - 'reg_allocation_unit_size': (:class:`int`) The register allocation unit size.
            - 'reg_allocation_granularity': (:class:`str`) The register allocation granularity.
            - 'shared_mem_allocation_unit_size': (:class:`int`) The shared memory allocation unit size.
            - 'warps_allocation_granularity': (:class:`str`) The warp allocation granularity.
            - 'max_thread_block_size': (:class:`int`) The maximum thread block size.
            - 'shared_mem_size_configs': (:class:`list` of :class:`int`) The shared memory size configurations (bytes).
            - 'warp_reg_allocation_granularities': (:class:`list` of :class:`int`) The warp register allocation granularities.
    """
    result = _get_gpu_data(major, minor)
    if result.error == OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE:
        raise ValueError("Unknown compute capability version.")

    gpu_data = {
        "cc_major": result.gpuData.computeCapabilityMajor,
        "cc_minor": result.gpuData.computeCapabilityMinor,
        "sm_version": result.gpuData.smVersion,
        "threads_per_warp": result.gpuData.threadsPerWarp,
        "max_warps_per_sm": result.gpuData.warpsPerSm,
        "max_threads_per_sm": result.gpuData.threadsPerSm,
        "max_thread_blocks_per_sm": result.gpuData.threadBlocksPerSm,
        "block_barriers_per_sm": result.gpuData.blockBarriersPerSm,
        "smem_per_sm": result.gpuData.smemPerSm,
        "max_shared_mem_per_block": result.gpuData.maxSmemPerBlock,
        "registers_per_sm": result.gpuData.localRegsPerSm,
        "max_regs_per_block": result.gpuData.maxRegPerBlock,
        "max_regs_per_thread": result.gpuData.maxRegsPerThread,
        "reg_allocation_unit_size": result.gpuData.regAllocationUnitSize,
        "reg_allocation_granularity": result.gpuData.regAllocationGranularity,
        "shared_mem_allocation_unit_size": result.gpuData.smemAllocationUnitSize,
        "warps_allocation_granularity": result.gpuData.warpAllocationGranularity,
        "max_thread_block_size": result.gpuData.maxThreadBlockSize,
        "shared_mem_size_configs": list(result.gpuData.smemSizeConfigs),
        "warp_reg_allocation_granularities": list(result.gpuData.warpRegAllocationGranularities),
    }
    return gpu_data



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ncu_occupancy
else:
    import _ncu_occupancy

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ncu_occupancy.delete_SwigPyIterator

    def value(self):
        return _ncu_occupancy.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _ncu_occupancy.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _ncu_occupancy.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _ncu_occupancy.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _ncu_occupancy.SwigPyIterator_equal(self, x)

    def copy(self):
        return _ncu_occupancy.SwigPyIterator_copy(self)

    def next(self):
        return _ncu_occupancy.SwigPyIterator_next(self)

    def __next__(self):
        return _ncu_occupancy.SwigPyIterator___next__(self)

    def previous(self):
        return _ncu_occupancy.SwigPyIterator_previous(self)

    def advance(self, n):
        return _ncu_occupancy.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _ncu_occupancy.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _ncu_occupancy.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _ncu_occupancy.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _ncu_occupancy.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _ncu_occupancy.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _ncu_occupancy.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ncu_occupancy:
_ncu_occupancy.SwigPyIterator_swigregister(SwigPyIterator)
class vector_unsigned_int(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _ncu_occupancy.vector_unsigned_int_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _ncu_occupancy.vector_unsigned_int___nonzero__(self)

    def __bool__(self):
        return _ncu_occupancy.vector_unsigned_int___bool__(self)

    def __len__(self):
        return _ncu_occupancy.vector_unsigned_int___len__(self)

    def __getslice__(self, i, j):
        return _ncu_occupancy.vector_unsigned_int___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _ncu_occupancy.vector_unsigned_int___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _ncu_occupancy.vector_unsigned_int___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _ncu_occupancy.vector_unsigned_int___delitem__(self, *args)

    def __getitem__(self, *args):
        return _ncu_occupancy.vector_unsigned_int___getitem__(self, *args)

    def __setitem__(self, *args):
        return _ncu_occupancy.vector_unsigned_int___setitem__(self, *args)

    def pop(self):
        return _ncu_occupancy.vector_unsigned_int_pop(self)

    def append(self, x):
        return _ncu_occupancy.vector_unsigned_int_append(self, x)

    def empty(self):
        return _ncu_occupancy.vector_unsigned_int_empty(self)

    def size(self):
        return _ncu_occupancy.vector_unsigned_int_size(self)

    def swap(self, v):
        return _ncu_occupancy.vector_unsigned_int_swap(self, v)

    def begin(self):
        return _ncu_occupancy.vector_unsigned_int_begin(self)

    def end(self):
        return _ncu_occupancy.vector_unsigned_int_end(self)

    def rbegin(self):
        return _ncu_occupancy.vector_unsigned_int_rbegin(self)

    def rend(self):
        return _ncu_occupancy.vector_unsigned_int_rend(self)

    def clear(self):
        return _ncu_occupancy.vector_unsigned_int_clear(self)

    def get_allocator(self):
        return _ncu_occupancy.vector_unsigned_int_get_allocator(self)

    def pop_back(self):
        return _ncu_occupancy.vector_unsigned_int_pop_back(self)

    def erase(self, *args):
        return _ncu_occupancy.vector_unsigned_int_erase(self, *args)

    def __init__(self, *args):
        _ncu_occupancy.vector_unsigned_int_swiginit(self, _ncu_occupancy.new_vector_unsigned_int(*args))

    def push_back(self, x):
        return _ncu_occupancy.vector_unsigned_int_push_back(self, x)

    def front(self):
        return _ncu_occupancy.vector_unsigned_int_front(self)

    def back(self):
        return _ncu_occupancy.vector_unsigned_int_back(self)

    def assign(self, n, x):
        return _ncu_occupancy.vector_unsigned_int_assign(self, n, x)

    def resize(self, *args):
        return _ncu_occupancy.vector_unsigned_int_resize(self, *args)

    def insert(self, *args):
        return _ncu_occupancy.vector_unsigned_int_insert(self, *args)

    def reserve(self, n):
        return _ncu_occupancy.vector_unsigned_int_reserve(self, n)

    def capacity(self):
        return _ncu_occupancy.vector_unsigned_int_capacity(self)
    __swig_destroy__ = _ncu_occupancy.delete_vector_unsigned_int

# Register vector_unsigned_int in _ncu_occupancy:
_ncu_occupancy.vector_unsigned_int_swigregister(vector_unsigned_int)
class vector_int(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _ncu_occupancy.vector_int_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _ncu_occupancy.vector_int___nonzero__(self)

    def __bool__(self):
        return _ncu_occupancy.vector_int___bool__(self)

    def __len__(self):
        return _ncu_occupancy.vector_int___len__(self)

    def __getslice__(self, i, j):
        return _ncu_occupancy.vector_int___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _ncu_occupancy.vector_int___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _ncu_occupancy.vector_int___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _ncu_occupancy.vector_int___delitem__(self, *args)

    def __getitem__(self, *args):
        return _ncu_occupancy.vector_int___getitem__(self, *args)

    def __setitem__(self, *args):
        return _ncu_occupancy.vector_int___setitem__(self, *args)

    def pop(self):
        return _ncu_occupancy.vector_int_pop(self)

    def append(self, x):
        return _ncu_occupancy.vector_int_append(self, x)

    def empty(self):
        return _ncu_occupancy.vector_int_empty(self)

    def size(self):
        return _ncu_occupancy.vector_int_size(self)

    def swap(self, v):
        return _ncu_occupancy.vector_int_swap(self, v)

    def begin(self):
        return _ncu_occupancy.vector_int_begin(self)

    def end(self):
        return _ncu_occupancy.vector_int_end(self)

    def rbegin(self):
        return _ncu_occupancy.vector_int_rbegin(self)

    def rend(self):
        return _ncu_occupancy.vector_int_rend(self)

    def clear(self):
        return _ncu_occupancy.vector_int_clear(self)

    def get_allocator(self):
        return _ncu_occupancy.vector_int_get_allocator(self)

    def pop_back(self):
        return _ncu_occupancy.vector_int_pop_back(self)

    def erase(self, *args):
        return _ncu_occupancy.vector_int_erase(self, *args)

    def __init__(self, *args):
        _ncu_occupancy.vector_int_swiginit(self, _ncu_occupancy.new_vector_int(*args))

    def push_back(self, x):
        return _ncu_occupancy.vector_int_push_back(self, x)

    def front(self):
        return _ncu_occupancy.vector_int_front(self)

    def back(self):
        return _ncu_occupancy.vector_int_back(self)

    def assign(self, n, x):
        return _ncu_occupancy.vector_int_assign(self, n, x)

    def resize(self, *args):
        return _ncu_occupancy.vector_int_resize(self, *args)

    def insert(self, *args):
        return _ncu_occupancy.vector_int_insert(self, *args)

    def reserve(self, n):
        return _ncu_occupancy.vector_int_reserve(self, n)

    def capacity(self):
        return _ncu_occupancy.vector_int_capacity(self)
    __swig_destroy__ = _ncu_occupancy.delete_vector_int

# Register vector_int in _ncu_occupancy:
_ncu_occupancy.vector_int_swigregister(vector_int)
class map_utilization(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _ncu_occupancy.map_utilization_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _ncu_occupancy.map_utilization___nonzero__(self)

    def __bool__(self):
        return _ncu_occupancy.map_utilization___bool__(self)

    def __len__(self):
        return _ncu_occupancy.map_utilization___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _ncu_occupancy.map_utilization___getitem__(self, key)

    def __delitem__(self, key):
        return _ncu_occupancy.map_utilization___delitem__(self, key)

    def has_key(self, key):
        return _ncu_occupancy.map_utilization_has_key(self, key)

    def keys(self):
        return _ncu_occupancy.map_utilization_keys(self)

    def values(self):
        return _ncu_occupancy.map_utilization_values(self)

    def items(self):
        return _ncu_occupancy.map_utilization_items(self)

    def __contains__(self, key):
        return _ncu_occupancy.map_utilization___contains__(self, key)

    def key_iterator(self):
        return _ncu_occupancy.map_utilization_key_iterator(self)

    def value_iterator(self):
        return _ncu_occupancy.map_utilization_value_iterator(self)

    def __setitem__(self, *args):
        return _ncu_occupancy.map_utilization___setitem__(self, *args)

    def asdict(self):
        return _ncu_occupancy.map_utilization_asdict(self)

    def __init__(self, *args):
        _ncu_occupancy.map_utilization_swiginit(self, _ncu_occupancy.new_map_utilization(*args))

    def empty(self):
        return _ncu_occupancy.map_utilization_empty(self)

    def size(self):
        return _ncu_occupancy.map_utilization_size(self)

    def swap(self, v):
        return _ncu_occupancy.map_utilization_swap(self, v)

    def begin(self):
        return _ncu_occupancy.map_utilization_begin(self)

    def end(self):
        return _ncu_occupancy.map_utilization_end(self)

    def rbegin(self):
        return _ncu_occupancy.map_utilization_rbegin(self)

    def rend(self):
        return _ncu_occupancy.map_utilization_rend(self)

    def clear(self):
        return _ncu_occupancy.map_utilization_clear(self)

    def get_allocator(self):
        return _ncu_occupancy.map_utilization_get_allocator(self)

    def count(self, x):
        return _ncu_occupancy.map_utilization_count(self, x)

    def erase(self, *args):
        return _ncu_occupancy.map_utilization_erase(self, *args)

    def find(self, x):
        return _ncu_occupancy.map_utilization_find(self, x)

    def lower_bound(self, x):
        return _ncu_occupancy.map_utilization_lower_bound(self, x)

    def upper_bound(self, x):
        return _ncu_occupancy.map_utilization_upper_bound(self, x)
    __swig_destroy__ = _ncu_occupancy.delete_map_utilization

# Register map_utilization in _ncu_occupancy:
_ncu_occupancy.map_utilization_swigregister(map_utilization)
class list_range_pairs(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _ncu_occupancy.list_range_pairs_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _ncu_occupancy.list_range_pairs___nonzero__(self)

    def __bool__(self):
        return _ncu_occupancy.list_range_pairs___bool__(self)

    def __len__(self):
        return _ncu_occupancy.list_range_pairs___len__(self)

    def __getslice__(self, i, j):
        return _ncu_occupancy.list_range_pairs___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _ncu_occupancy.list_range_pairs___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _ncu_occupancy.list_range_pairs___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _ncu_occupancy.list_range_pairs___delitem__(self, *args)

    def __getitem__(self, *args):
        return _ncu_occupancy.list_range_pairs___getitem__(self, *args)

    def __setitem__(self, *args):
        return _ncu_occupancy.list_range_pairs___setitem__(self, *args)

    def pop(self):
        return _ncu_occupancy.list_range_pairs_pop(self)

    def append(self, x):
        return _ncu_occupancy.list_range_pairs_append(self, x)

    def empty(self):
        return _ncu_occupancy.list_range_pairs_empty(self)

    def size(self):
        return _ncu_occupancy.list_range_pairs_size(self)

    def swap(self, v):
        return _ncu_occupancy.list_range_pairs_swap(self, v)

    def begin(self):
        return _ncu_occupancy.list_range_pairs_begin(self)

    def end(self):
        return _ncu_occupancy.list_range_pairs_end(self)

    def rbegin(self):
        return _ncu_occupancy.list_range_pairs_rbegin(self)

    def rend(self):
        return _ncu_occupancy.list_range_pairs_rend(self)

    def clear(self):
        return _ncu_occupancy.list_range_pairs_clear(self)

    def get_allocator(self):
        return _ncu_occupancy.list_range_pairs_get_allocator(self)

    def pop_back(self):
        return _ncu_occupancy.list_range_pairs_pop_back(self)

    def erase(self, *args):
        return _ncu_occupancy.list_range_pairs_erase(self, *args)

    def __init__(self, *args):
        _ncu_occupancy.list_range_pairs_swiginit(self, _ncu_occupancy.new_list_range_pairs(*args))

    def push_back(self, x):
        return _ncu_occupancy.list_range_pairs_push_back(self, x)

    def front(self):
        return _ncu_occupancy.list_range_pairs_front(self)

    def back(self):
        return _ncu_occupancy.list_range_pairs_back(self)

    def assign(self, n, x):
        return _ncu_occupancy.list_range_pairs_assign(self, n, x)

    def resize(self, *args):
        return _ncu_occupancy.list_range_pairs_resize(self, *args)

    def insert(self, *args):
        return _ncu_occupancy.list_range_pairs_insert(self, *args)

    def pop_front(self):
        return _ncu_occupancy.list_range_pairs_pop_front(self)

    def push_front(self, x):
        return _ncu_occupancy.list_range_pairs_push_front(self, x)

    def reverse(self):
        return _ncu_occupancy.list_range_pairs_reverse(self)
    __swig_destroy__ = _ncu_occupancy.delete_list_range_pairs

# Register list_range_pairs in _ncu_occupancy:
_ncu_occupancy.list_range_pairs_swigregister(list_range_pairs)
class list_occupancy_configs(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _ncu_occupancy.list_occupancy_configs_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _ncu_occupancy.list_occupancy_configs___nonzero__(self)

    def __bool__(self):
        return _ncu_occupancy.list_occupancy_configs___bool__(self)

    def __len__(self):
        return _ncu_occupancy.list_occupancy_configs___len__(self)

    def __getslice__(self, i, j):
        return _ncu_occupancy.list_occupancy_configs___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _ncu_occupancy.list_occupancy_configs___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _ncu_occupancy.list_occupancy_configs___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _ncu_occupancy.list_occupancy_configs___delitem__(self, *args)

    def __getitem__(self, *args):
        return _ncu_occupancy.list_occupancy_configs___getitem__(self, *args)

    def __setitem__(self, *args):
        return _ncu_occupancy.list_occupancy_configs___setitem__(self, *args)

    def pop(self):
        return _ncu_occupancy.list_occupancy_configs_pop(self)

    def append(self, x):
        return _ncu_occupancy.list_occupancy_configs_append(self, x)

    def empty(self):
        return _ncu_occupancy.list_occupancy_configs_empty(self)

    def size(self):
        return _ncu_occupancy.list_occupancy_configs_size(self)

    def swap(self, v):
        return _ncu_occupancy.list_occupancy_configs_swap(self, v)

    def begin(self):
        return _ncu_occupancy.list_occupancy_configs_begin(self)

    def end(self):
        return _ncu_occupancy.list_occupancy_configs_end(self)

    def rbegin(self):
        return _ncu_occupancy.list_occupancy_configs_rbegin(self)

    def rend(self):
        return _ncu_occupancy.list_occupancy_configs_rend(self)

    def clear(self):
        return _ncu_occupancy.list_occupancy_configs_clear(self)

    def get_allocator(self):
        return _ncu_occupancy.list_occupancy_configs_get_allocator(self)

    def pop_back(self):
        return _ncu_occupancy.list_occupancy_configs_pop_back(self)

    def erase(self, *args):
        return _ncu_occupancy.list_occupancy_configs_erase(self, *args)

    def __init__(self, *args):
        _ncu_occupancy.list_occupancy_configs_swiginit(self, _ncu_occupancy.new_list_occupancy_configs(*args))

    def push_back(self, x):
        return _ncu_occupancy.list_occupancy_configs_push_back(self, x)

    def front(self):
        return _ncu_occupancy.list_occupancy_configs_front(self)

    def back(self):
        return _ncu_occupancy.list_occupancy_configs_back(self)

    def assign(self, n, x):
        return _ncu_occupancy.list_occupancy_configs_assign(self, n, x)

    def resize(self, *args):
        return _ncu_occupancy.list_occupancy_configs_resize(self, *args)

    def insert(self, *args):
        return _ncu_occupancy.list_occupancy_configs_insert(self, *args)

    def pop_front(self):
        return _ncu_occupancy.list_occupancy_configs_pop_front(self)

    def push_front(self, x):
        return _ncu_occupancy.list_occupancy_configs_push_front(self, x)

    def reverse(self):
        return _ncu_occupancy.list_occupancy_configs_reverse(self)
    __swig_destroy__ = _ncu_occupancy.delete_list_occupancy_configs

# Register list_occupancy_configs in _ncu_occupancy:
_ncu_occupancy.list_occupancy_configs_swigregister(list_occupancy_configs)


import enum

class OccupancyLimiter(enum.IntEnum):
    """
    Enum representing the occupancy limiters.

    Attributes:
        REGISTERS: Register usage is the occupancy limiter.
        SHARED_MEMORY: Shared memory usage is the occupancy limiter.
        BLOCKS: Block size is the occupancy limiter.
        BARRIERS: Barrier usage is the occupancy limiter.
    """
    REGISTERS = _ncu_occupancy._OccupancyLimiter_REGISTERS
    SHARED_MEMORY = _ncu_occupancy._OccupancyLimiter_SHARED_MEMORY
    BLOCKS = _ncu_occupancy._OccupancyLimiter_BLOCKS
    BARRIERS = _ncu_occupancy._OccupancyLimiter_BARRIERS

class OccupancyVariable(enum.IntEnum):
    """
    Enum representing the occupancy variables.

    Attributes:
        THREADS_PER_BLOCK: Threads per block.
        REGISTERS_PER_THREAD: Registers per thread.
        SHARED_MEMORY_PER_BLOCK: Shared memory per block.
        BLOCK_BARRIERS: Block barriers.
    """
    THREADS_PER_BLOCK = _ncu_occupancy._OccupancyVariable_THREADS_PER_BLOCK
    REGISTERS_PER_THREAD = _ncu_occupancy._OccupancyVariable_REGISTERS_PER_THREAD
    SHARED_MEMORY_PER_BLOCK = _ncu_occupancy._OccupancyVariable_SHARED_MEMORY_PER_BLOCK
    BLOCK_BARRIERS = _ncu_occupancy._OccupancyVariable_BLOCK_BARRIERS


from dataclasses import dataclass

@dataclass
class OccupancyParameters:
    """
    OccupancyParameters is a :class:`dataclass` that holds configuration parameters for occupancy calculations.

    Attributes:
        shared_mem_size (int): Shared memory size configuration (bytes). (default: 0)
        threads_per_block (int): Number of threads per block. (default: 256)
        registers_per_thread (int): Number of registers per thread. (default: 32)
        shared_mem_per_block (int): Shared memory (bytes) per block. (default: 2048)
        num_block_barriers (int): Number of block barriers. (default: 1)
    """
    shared_mem_size: int = 0
    threads_per_block: int = 256
    registers_per_thread: int = 32
    shared_mem_per_block: int = 2048
    num_block_barriers: int = 1

    def __post_init__(self):
        if self.shared_mem_size < 0:
            raise ValueError("shared_mem_size must be non-negative")
        if self.threads_per_block < 0:
            raise ValueError("threads_per_block must be non-negative")
        if self.registers_per_thread < 0:
            raise ValueError("registers_per_thread must be non-negative")
        if self.shared_mem_per_block < 0:
            raise ValueError("shared_mem_per_block must be non-negative")
        if self.num_block_barriers < 0:
            raise ValueError("num_block_barriers must be non-negative")


OccupancyCalculatorError_SUCCESS = _ncu_occupancy.OccupancyCalculatorError_SUCCESS
OccupancyCalculatorError_ERROR_INVALID_INPUT = _ncu_occupancy.OccupancyCalculatorError_ERROR_INVALID_INPUT
OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE = _ncu_occupancy.OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE
_OccupancyLimiter_REGISTERS = _ncu_occupancy._OccupancyLimiter_REGISTERS
_OccupancyLimiter_SHARED_MEMORY = _ncu_occupancy._OccupancyLimiter_SHARED_MEMORY
_OccupancyLimiter_BLOCKS = _ncu_occupancy._OccupancyLimiter_BLOCKS
_OccupancyLimiter_BARRIERS = _ncu_occupancy._OccupancyLimiter_BARRIERS
_OccupancyVariable_THREADS_PER_BLOCK = _ncu_occupancy._OccupancyVariable_THREADS_PER_BLOCK
_OccupancyVariable_REGISTERS_PER_THREAD = _ncu_occupancy._OccupancyVariable_REGISTERS_PER_THREAD
_OccupancyVariable_SHARED_MEMORY_PER_BLOCK = _ncu_occupancy._OccupancyVariable_SHARED_MEMORY_PER_BLOCK
_OccupancyVariable_BLOCK_BARRIERS = _ncu_occupancy._OccupancyVariable_BLOCK_BARRIERS
class OccupancyFactors(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    smemSizeConfig = property(_ncu_occupancy.OccupancyFactors_smemSizeConfig_get, _ncu_occupancy.OccupancyFactors_smemSizeConfig_set)
    threadsPerBlock = property(_ncu_occupancy.OccupancyFactors_threadsPerBlock_get, _ncu_occupancy.OccupancyFactors_threadsPerBlock_set)
    regPerThread = property(_ncu_occupancy.OccupancyFactors_regPerThread_get, _ncu_occupancy.OccupancyFactors_regPerThread_set)
    smemPerBlock = property(_ncu_occupancy.OccupancyFactors_smemPerBlock_get, _ncu_occupancy.OccupancyFactors_smemPerBlock_set)
    numBlockBarriers = property(_ncu_occupancy.OccupancyFactors_numBlockBarriers_get, _ncu_occupancy.OccupancyFactors_numBlockBarriers_set)

    def __init__(self):
        _ncu_occupancy.OccupancyFactors_swiginit(self, _ncu_occupancy.new_OccupancyFactors())
    __swig_destroy__ = _ncu_occupancy.delete_OccupancyFactors

# Register OccupancyFactors in _ncu_occupancy:
_ncu_occupancy.OccupancyFactors_swigregister(OccupancyFactors)
class SmOccupancyResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    smOccupancy = property(_ncu_occupancy.SmOccupancyResult_smOccupancy_get, _ncu_occupancy.SmOccupancyResult_smOccupancy_set)
    activeBlocksPerMultiprocessor = property(_ncu_occupancy.SmOccupancyResult_activeBlocksPerMultiprocessor_get, _ncu_occupancy.SmOccupancyResult_activeBlocksPerMultiprocessor_set)
    error = property(_ncu_occupancy.SmOccupancyResult_error_get, _ncu_occupancy.SmOccupancyResult_error_set)

    def __init__(self):
        _ncu_occupancy.SmOccupancyResult_swiginit(self, _ncu_occupancy.new_SmOccupancyResult())
    __swig_destroy__ = _ncu_occupancy.delete_SmOccupancyResult

# Register SmOccupancyResult in _ncu_occupancy:
_ncu_occupancy.SmOccupancyResult_swigregister(SmOccupancyResult)
class OccupancyLimiterResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    limiters = property(_ncu_occupancy.OccupancyLimiterResult_limiters_get, _ncu_occupancy.OccupancyLimiterResult_limiters_set)
    error = property(_ncu_occupancy.OccupancyLimiterResult_error_get, _ncu_occupancy.OccupancyLimiterResult_error_set)

    def __init__(self):
        _ncu_occupancy.OccupancyLimiterResult_swiginit(self, _ncu_occupancy.new_OccupancyLimiterResult())
    __swig_destroy__ = _ncu_occupancy.delete_OccupancyLimiterResult

# Register OccupancyLimiterResult in _ncu_occupancy:
_ncu_occupancy.OccupancyLimiterResult_swigregister(OccupancyLimiterResult)
class ResourceUtilization(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    resourcePerBlock = property(_ncu_occupancy.ResourceUtilization_resourcePerBlock_get, _ncu_occupancy.ResourceUtilization_resourcePerBlock_set)
    unusedResourceCount = property(_ncu_occupancy.ResourceUtilization_unusedResourceCount_get, _ncu_occupancy.ResourceUtilization_unusedResourceCount_set)
    unallocatedBlocks = property(_ncu_occupancy.ResourceUtilization_unallocatedBlocks_get, _ncu_occupancy.ResourceUtilization_unallocatedBlocks_set)

    def __init__(self):
        _ncu_occupancy.ResourceUtilization_swiginit(self, _ncu_occupancy.new_ResourceUtilization())
    __swig_destroy__ = _ncu_occupancy.delete_ResourceUtilization

# Register ResourceUtilization in _ncu_occupancy:
_ncu_occupancy.ResourceUtilization_swigregister(ResourceUtilization)
class ResourceUtilizationResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    smOccupancy = property(_ncu_occupancy.ResourceUtilizationResult_smOccupancy_get, _ncu_occupancy.ResourceUtilizationResult_smOccupancy_set)
    allocatedBlocks = property(_ncu_occupancy.ResourceUtilizationResult_allocatedBlocks_get, _ncu_occupancy.ResourceUtilizationResult_allocatedBlocks_set)
    resourceUtilization = property(_ncu_occupancy.ResourceUtilizationResult_resourceUtilization_get, _ncu_occupancy.ResourceUtilizationResult_resourceUtilization_set)
    error = property(_ncu_occupancy.ResourceUtilizationResult_error_get, _ncu_occupancy.ResourceUtilizationResult_error_set)

    def __init__(self):
        _ncu_occupancy.ResourceUtilizationResult_swiginit(self, _ncu_occupancy.new_ResourceUtilizationResult())
    __swig_destroy__ = _ncu_occupancy.delete_ResourceUtilizationResult

# Register ResourceUtilizationResult in _ncu_occupancy:
_ncu_occupancy.ResourceUtilizationResult_swigregister(ResourceUtilizationResult)
class OptimalOccupancyResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    occupancy = property(_ncu_occupancy.OptimalOccupancyResult_occupancy_get, _ncu_occupancy.OptimalOccupancyResult_occupancy_set)
    singleOccVariableConfig = property(_ncu_occupancy.OptimalOccupancyResult_singleOccVariableConfig_get, _ncu_occupancy.OptimalOccupancyResult_singleOccVariableConfig_set)
    multiOccVariableConfig = property(_ncu_occupancy.OptimalOccupancyResult_multiOccVariableConfig_get, _ncu_occupancy.OptimalOccupancyResult_multiOccVariableConfig_set)
    error = property(_ncu_occupancy.OptimalOccupancyResult_error_get, _ncu_occupancy.OptimalOccupancyResult_error_set)

    def __init__(self):
        _ncu_occupancy.OptimalOccupancyResult_swiginit(self, _ncu_occupancy.new_OptimalOccupancyResult())
    __swig_destroy__ = _ncu_occupancy.delete_OptimalOccupancyResult

# Register OptimalOccupancyResult in _ncu_occupancy:
_ncu_occupancy.OptimalOccupancyResult_swigregister(OptimalOccupancyResult)
class GpuDataQueryResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    gpuData = property(_ncu_occupancy.GpuDataQueryResult_gpuData_get, _ncu_occupancy.GpuDataQueryResult_gpuData_set)
    error = property(_ncu_occupancy.GpuDataQueryResult_error_get, _ncu_occupancy.GpuDataQueryResult_error_set)

    def __init__(self):
        _ncu_occupancy.GpuDataQueryResult_swiginit(self, _ncu_occupancy.new_GpuDataQueryResult())
    __swig_destroy__ = _ncu_occupancy.delete_GpuDataQueryResult

# Register GpuDataQueryResult in _ncu_occupancy:
_ncu_occupancy.GpuDataQueryResult_swigregister(GpuDataQueryResult)

def _get_gpu_data(major, minor):
    return _ncu_occupancy._get_gpu_data(major, minor)
class OccupancyCalculator(object):
    r"""

    Provide methods to calculate occupancy and analyze ways to improve it, for a given GPU.

    Args:
        computeCapabilityMajor (:class:`int`): The major compute capability version of the GPU.
        computeCapabilityMinor (:class:`int`): The minor compute capability version of the GPU.

    Returns:
        :class:`OccupancyCalculator`: An instance of the occupancy calculator.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, compute_capability_major, compute_capability_minor):
        _ncu_occupancy.OccupancyCalculator_swiginit(self, _ncu_occupancy.new_OccupancyCalculator(compute_capability_major, compute_capability_minor))
    __swig_destroy__ = _ncu_occupancy.delete_OccupancyCalculator

    def _get_sm_occupancy(self, occupancy_factors):
        return _ncu_occupancy.OccupancyCalculator__get_sm_occupancy(self, occupancy_factors)

    def _get_occupancy_limiters(self, occupancy_factors):
        return _ncu_occupancy.OccupancyCalculator__get_occupancy_limiters(self, occupancy_factors)

    def _get_resource_utilization(self, occupancy_factors):
        return _ncu_occupancy.OccupancyCalculator__get_resource_utilization(self, occupancy_factors)

    def _get_optimal_occupancy(self, occupancy_factors, resourceList):
        return _ncu_occupancy.OccupancyCalculator__get_optimal_occupancy(self, occupancy_factors, resourceList)


    def _occupancy_param_to_factors(self, occupancy_parameters: OccupancyParameters) -> OccupancyFactors:
        occupancy_factors = OccupancyFactors()
        occupancy_factors.smemSizeConfig = occupancy_parameters.shared_mem_size
        occupancy_factors.threadsPerBlock = occupancy_parameters.threads_per_block
        occupancy_factors.regPerThread = occupancy_parameters.registers_per_thread
        occupancy_factors.smemPerBlock = occupancy_parameters.shared_mem_per_block
        occupancy_factors.numBlockBarriers = occupancy_parameters.num_block_barriers
        return occupancy_factors


    def get_sm_occupancy(self, occupancy_parameters: OccupancyParameters) -> float:
        """
        Calculate the occupancy of the SMs for the given occupancy parameters.

        Args:
            occupancy_parameters (:class:`OccupancyParameters`): The input parameters for the occupancy calculation.

        Returns:
            :class:`float`: The occupancy of the SMs.
        """
        occupancy_factors = self._occupancy_param_to_factors(occupancy_parameters)

        result = self._get_sm_occupancy(occupancy_factors)
        if result.error == OccupancyCalculatorError_ERROR_INVALID_INPUT:
            raise ValueError("Invalid occupancy parameters.")
        if result.error == OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE:
            raise ValueError("Unknown compute capability version.")
        return result.smOccupancy

    def get_occupancy_limiters(self, occupancy_parameters: OccupancyParameters) -> list:
        """
        Get the occupancy limiters for the given occupancy parameters.

        Args:
            occupancy_parameters (:class:`OccupancyParameters`): The input parameters for the occupancy calculation.

        Returns:
            :class:`list` of :class:`OccupancyLimiter`
        """
        occupancy_factors = self._occupancy_param_to_factors(occupancy_parameters)

        result = self._get_occupancy_limiters(occupancy_factors)
        if result.error == OccupancyCalculatorError_ERROR_INVALID_INPUT:
            raise ValueError("Invalid occupancy parameters.")
        if result.error == OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE:
            raise ValueError("Unknown compute capability version.")

        return [OccupancyLimiter(limiter) for limiter in result.limiters]

    def get_resource_utilization(self, occupancy_parameters: OccupancyParameters) -> dict:
        """
        Get the resource utilization for the given occupancy parameters.

        Args:
            occupancy_parameters (:class:`OccupancyParameters`): The input parameters for the occupancy calculation.

        Returns:
            :class:`dict`: Resource utilization. The dictionary contains the following key-value pairs:
                - 'sm_occupancy' : (:class:`float`) The occupancy of the SMs.
                - 'allocated_blocks' : (:class:`int`) The number of allocated blocks out of the total possible blocks per SM.
                - 'resource_utilization' : (:class:`dict`) The resource utilization for each resource i.e. threads, registers, shared memory. The resource utilization dictionary contains the following key-value pairs:
                    - '<resource name>': (:class:`dict`) The resource utilization for the resource. The resource utilization dictionary contains the following key-value pairs:
                        - 'resource_per_block': (:class:`int`) The resource utilized per block.
                        - 'unused_resource_count': (:class:`int`) The unused resource count per SM.
                        - 'unallocated_blocks': (:class:`int`) The number of unallocated blocks per SM.

        """
        occupancy_factors = self._occupancy_param_to_factors(occupancy_parameters)

        result = self._get_resource_utilization(occupancy_factors)
        if result.error == OccupancyCalculatorError_ERROR_INVALID_INPUT:
            raise ValueError("Invalid occupancy parameters.")
        if result.error == OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE:
            raise ValueError("Unknown compute capability version.")

        resource_utilization = {
            "sm_occupancy": result.smOccupancy,
            "allocated_blocks": result.allocatedBlocks,
            "resource_utilization": {
                resource: {
                    "resource_per_block": utilization.resourcePerBlock,
                    "unused_resource_count": utilization.unusedResourceCount,
                    "unallocated_blocks": utilization.unallocatedBlocks,
                }
                for resource, utilization in result.resourceUtilization.items()
            }
        }

        return resource_utilization

    def get_optimal_occupancy(self, occupancy_parameters: OccupancyParameters, occupancy_variable_list: list = [OccupancyVariable.THREADS_PER_BLOCK]) -> dict:
        """
        Get the optimal occupancy configuration.

        Optimal occupancy is calculated by varying input occupancy variable values while keeping other occupancy variable values constant. If no input occupancy variable list provided then :attr:`OccupancyVariable.THREADS_PER_BLOCK` will be considered by default.

        Args:
            occupancy_parameters (:class:`OccupancyParameters`): The input parameters for the occupancy calculation.
            occupancy_variable_list (:class:`list` of :class:`OccupancyVariable`, optional): The list of occupancy variables to consider for optimal occupancy calculation. Only up to two occupancy variables can be specified. (default: :attr:`OccupancyVariable.THREADS_PER_BLOCK`)

        Returns:
            :class:`dict`: The optimal occupancy configuration. The dictionary contains the following key-value pairs:
                - 'optimal_occupancy': (:class:`float`) The optimal occupancy.
                - 'occupancy_variable_config':
                    - For single occupancy variable input: :class:`list` of :class:`tuple` of ranges.
                    - For two occupancy variables input: :class:`list` of :class:`tuple` of value combinations. The :class:`tuple` contains the values in the same order as the input occupancy variable list.
        """

        if len(occupancy_variable_list) > 2:
            raise ValueError("Invalid number of occupancy variables. Maximum 2 occupancy variables can be considered for optimal occupancy calculation.")

        if occupancy_variable_list is None or len(occupancy_variable_list) == 0:
            raise ValueError("Occupancy variable list cannot be empty.")

        occupancy_variable_int_list = [int(occupancy_variable) for occupancy_variable in occupancy_variable_list]

        occupancy_factors = self._occupancy_param_to_factors(occupancy_parameters)

        result = self._get_optimal_occupancy(occupancy_factors, occupancy_variable_int_list)
        if result.error == OccupancyCalculatorError_ERROR_INVALID_INPUT:
            raise ValueError("Invalid input parameters.")
        if result.error == OccupancyCalculatorError_ERROR_UNKNOWN_DEVICE:
            raise ValueError("Unknown compute capability version.")

        optimal_occupancy = {
            "optimal_occupancy": result.occupancy,
        }

        if len(occupancy_variable_list) == 1:
            optimal_occupancy["occupancy_variable_config"] = [(range[0], range[1]) for range in result.singleOccVariableConfig]
        else:
            optimal_occupancy["occupancy_variable_config"] = []
            for occupancy_variable_config in result.multiOccVariableConfig:
                optimal_occupancy["occupancy_variable_config"].append(occupancy_variable_config)

        return optimal_occupancy



# Register OccupancyCalculator in _ncu_occupancy:
_ncu_occupancy.OccupancyCalculator_swigregister(OccupancyCalculator)
class GpuData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    computeCapabilityMajor = property(_ncu_occupancy.GpuData_computeCapabilityMajor_get, _ncu_occupancy.GpuData_computeCapabilityMajor_set)
    computeCapabilityMinor = property(_ncu_occupancy.GpuData_computeCapabilityMinor_get, _ncu_occupancy.GpuData_computeCapabilityMinor_set)
    smVersion = property(_ncu_occupancy.GpuData_smVersion_get, _ncu_occupancy.GpuData_smVersion_set)
    threadsPerWarp = property(_ncu_occupancy.GpuData_threadsPerWarp_get, _ncu_occupancy.GpuData_threadsPerWarp_set)
    warpsPerSm = property(_ncu_occupancy.GpuData_warpsPerSm_get, _ncu_occupancy.GpuData_warpsPerSm_set)
    threadsPerSm = property(_ncu_occupancy.GpuData_threadsPerSm_get, _ncu_occupancy.GpuData_threadsPerSm_set)
    threadBlocksPerSm = property(_ncu_occupancy.GpuData_threadBlocksPerSm_get, _ncu_occupancy.GpuData_threadBlocksPerSm_set)
    blockBarriersPerSm = property(_ncu_occupancy.GpuData_blockBarriersPerSm_get, _ncu_occupancy.GpuData_blockBarriersPerSm_set)
    smemPerSm = property(_ncu_occupancy.GpuData_smemPerSm_get, _ncu_occupancy.GpuData_smemPerSm_set)
    maxSmemPerBlock = property(_ncu_occupancy.GpuData_maxSmemPerBlock_get, _ncu_occupancy.GpuData_maxSmemPerBlock_set)
    localRegsPerSm = property(_ncu_occupancy.GpuData_localRegsPerSm_get, _ncu_occupancy.GpuData_localRegsPerSm_set)
    maxRegPerBlock = property(_ncu_occupancy.GpuData_maxRegPerBlock_get, _ncu_occupancy.GpuData_maxRegPerBlock_set)
    regAllocationUnitSize = property(_ncu_occupancy.GpuData_regAllocationUnitSize_get, _ncu_occupancy.GpuData_regAllocationUnitSize_set)
    regAllocationGranularity = property(_ncu_occupancy.GpuData_regAllocationGranularity_get, _ncu_occupancy.GpuData_regAllocationGranularity_set)
    maxRegsPerThread = property(_ncu_occupancy.GpuData_maxRegsPerThread_get, _ncu_occupancy.GpuData_maxRegsPerThread_set)
    smemAllocationUnitSize = property(_ncu_occupancy.GpuData_smemAllocationUnitSize_get, _ncu_occupancy.GpuData_smemAllocationUnitSize_set)
    warpAllocationGranularity = property(_ncu_occupancy.GpuData_warpAllocationGranularity_get, _ncu_occupancy.GpuData_warpAllocationGranularity_set)
    maxThreadBlockSize = property(_ncu_occupancy.GpuData_maxThreadBlockSize_get, _ncu_occupancy.GpuData_maxThreadBlockSize_set)
    smemSizeConfigs = property(_ncu_occupancy.GpuData_smemSizeConfigs_get, _ncu_occupancy.GpuData_smemSizeConfigs_set)
    warpRegAllocationGranularities = property(_ncu_occupancy.GpuData_warpRegAllocationGranularities_get, _ncu_occupancy.GpuData_warpRegAllocationGranularities_set)

    def __init__(self):
        _ncu_occupancy.GpuData_swiginit(self, _ncu_occupancy.new_GpuData())
    __swig_destroy__ = _ncu_occupancy.delete_GpuData

# Register GpuData in _ncu_occupancy:
_ncu_occupancy.GpuData_swigregister(GpuData)

def GetGpuDataList():
    return _ncu_occupancy.GetGpuDataList()

def GetGpuData(computeCapabilityMajor, computeCapabilityMinor):
    return _ncu_occupancy.GetGpuData(computeCapabilityMajor, computeCapabilityMinor)

def GetSharedMemoryRuntime(computeCapabilityMajor, cudaVersion):
    return _ncu_occupancy.GetSharedMemoryRuntime(computeCapabilityMajor, cudaVersion)

