/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiDevType;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.ui.analysis.NVLinkConnection;
import com.nvidia.viper.ui.analysis.TopologyCanvas;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class NVLinkPropertyControl
extends Composite
implements ISessionPropertyChangeListener {
    private TableViewer tableProperty;
    private TableViewer tableThroughput;
    private TopologyCanvas canvas;
    private TableListener tableListener;
    private Listener itemSelectionListener = new Listener(){

        public void handleEvent(Event event) {
            event.detail &= 0xFFFFFFDF;
            if ((event.detail & 2) == 0) {
                return;
            }
            Table table = (Table)event.widget;
            int clientWidth = table.getClientArea().width;
            GC gc = event.gc;
            Color oldForeground = gc.getForeground();
            Color oldBackground = gc.getBackground();
            gc.setBackground(ViperColors.COLOR_NVLINK_PROPERTY_SELECTION);
            gc.fillRectangle(0, event.y, clientWidth, event.height);
            gc.setForeground(oldForeground);
            gc.setBackground(oldBackground);
            event.detail &= 0xFFFFFFFD;
        }
    };

    public NVLinkPropertyControl(Composite parent, int style) {
        super(parent, style);
        GridLayout mainLayout = new GridLayout(1, false);
        this.setLayout((Layout)mainLayout);
        this.createLabel("Logical NVLink Properties");
        this.tableProperty = this.createTableViewer(2);
        this.createProperyColumns(this.tableProperty);
        this.tableListener = new TableListener();
        this.tableProperty.addSelectionChangedListener((ISelectionChangedListener)this.tableListener);
        this.tableProperty.getTable().addListener(40, this.itemSelectionListener);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableProperty);
        this.createLabel("Logical NVLink Throughput");
        this.tableThroughput = this.createTableViewer(2);
        this.createThroughputColumns(this.tableThroughput);
        this.tableThroughput.addSelectionChangedListener((ISelectionChangedListener)this.tableListener);
        this.tableThroughput.getTable().addListener(40, this.itemSelectionListener);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableThroughput);
    }

    public void setInput(TopologyCanvas canvas) {
        this.canvas = canvas;
        List<NVLinkConnection> nvlinks = canvas.getLinks();
        this.tableProperty.setInput(nvlinks);
        this.tableProperty.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                NVLinkConnection i1 = (NVLinkConnection)e1;
                NVLinkConnection i2 = (NVLinkConnection)e2;
                return NVLinkPropertyControl.this.createLinkLabel(i1, "%s %s").compareTo(NVLinkPropertyControl.this.createLinkLabel(i2, "%s %s"));
            }
        });
        Throughput[] throughputs = new Throughput[nvlinks.size() * 2];
        int i = 0;
        for (NVLinkConnection link : nvlinks) {
            Throughput tp = new Throughput();
            tp.linkLabel = this.createLinkLabel(link, "%s-->%s");
            tp.sortLabel = this.createLinkLabel(link, "%s %s 1");
            tp.avg = canvas.getAvgTransmitBandwidth(link);
            tp.max = canvas.getMaxTransmitBandwidth(link);
            tp.min = canvas.getMinTransmitBandwidth(link);
            tp.nvlink = link;
            throughputs[i++] = tp;
            tp = new Throughput();
            tp.linkLabel = this.createLinkLabel(link, "%s<--%s");
            tp.sortLabel = this.createLinkLabel(link, "%s %s 2");
            tp.avg = canvas.getAvgReceiveBandwidth(link);
            tp.max = canvas.getMaxReceiveBandwidth(link);
            tp.min = canvas.getMinReceiveBandwidth(link);
            tp.nvlink = link;
            throughputs[i++] = tp;
        }
        this.tableThroughput.setInput((Object)throughputs);
        this.tableThroughput.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Throughput i1 = (Throughput)e1;
                Throughput i2 = (Throughput)e2;
                return i1.sortLabel.compareTo(i2.sortLabel);
            }
        });
    }

    private Label createLabel(String text) {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        label.setText(text);
        return label;
    }

    private TableViewer createTableViewer(int style) {
        TableViewer viewer = new TableViewer((Composite)this, 0x10800 | style);
        viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, false));
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return viewer;
    }

    private String getDeviceLabel(int type, int id, int domain) {
        String dev1 = type == CuptiDevType.CUPTI_DEV_TYPE_NPU.getCode() ? "CPU" + domain : "GPU" + id;
        return dev1;
    }

    private TableViewerColumn getColumn(TableViewer viewer, String text, String tooltip, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setResizable(true);
        column.setMoveable(true);
        column.setText(text);
        column.setToolTipText(tooltip);
        column.pack();
        return viewerColumn;
    }

    private void createThroughputColumns(TableViewer viewer) {
        TableViewerColumn viewerColumn = this.getColumn(viewer, "Logical NVLink", "The direction of logical NVLink", 0);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof Throughput) {
                    Throughput tp = (Throughput)element;
                    return tp.linkLabel;
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Avg Throughput", "The average throughput (excluding idle time) of logical NVLink", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof Throughput) {
                    Throughput tp = (Throughput)element;
                    String bw = tp.avg == -1L ? "n/a" : new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(tp.avg);
                    return bw;
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Max Throughput", "The maximum throughput of the logical NVLink", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof Throughput) {
                    Throughput tp = (Throughput)element;
                    String bw = tp.max == -1L ? "n/a" : new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(tp.max);
                    return bw;
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Min Throughput", "The minimum throughput (excluding idle time) of logical NVLink", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof Throughput) {
                    Throughput tp = (Throughput)element;
                    String bw = tp.min == -1L ? "n/a" : new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(tp.min);
                    return bw;
                }
                return null;
            }
        });
        if (!"win32".equals(Platform.getOS())) {
            viewerColumn = this.getColumn(viewer, "", "", 0);
            viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

                public String getText(Object element) {
                    return null;
                }
            });
        }
    }

    private String createLinkLabel(NVLinkConnection nvlink, String str) {
        String dev1 = this.getDeviceLabel(nvlink.getActivity().typeDev0, nvlink.getDevice1().getId(), nvlink.getActivity().domainNPU0);
        String dev2 = this.getDeviceLabel(nvlink.getActivity().typeDev1, nvlink.getDevice2().getId(), nvlink.getActivity().domainNPU1);
        return String.format(str, dev1, dev2);
    }

    private void createProperyColumns(TableViewer viewer) {
        TableViewerColumn viewerColumn = this.getColumn(viewer, "Logical NVLink", "The logical NVLink between two devices", 0);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    NVLinkConnection nvlink = (NVLinkConnection)element;
                    return this.createLinkLabel(nvlink, "%s<-->%s");
                }
                return "null";
            }
        });
        viewerColumn = this.getColumn(viewer, "Peak\nBandwidth", "The peak memory bandwidth of logical NVLink", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    String bw = new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(((NVLinkConnection)element).getBandwidth());
                    return bw;
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Physical\nNVLinks", "The number of physical NVLinks between two devices", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    return String.valueOf(((NVLinkConnection)element).getPhysicalLinks());
                }
                return "null";
            }
        });
        viewerColumn = this.getColumn(viewer, "Peer\nAccess", "Is peer to peer access supported by the NVLink", 0);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    return ((NVLinkConnection)element).isPeerAccess() ? "Yes" : "No";
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "System\nAccess", "Is system memory access supported by the NVLink", 0);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    return ((NVLinkConnection)element).isSystemAccess() ? "Yes" : "No";
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Peer\nAtomic", "Is peer atomic access supported by the NVLink", 0);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    return ((NVLinkConnection)element).isPeerAtomic() ? "Yes" : "No";
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "System\nAtomic", "Is system memory atomic access supported by the NVLink", 0);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    return ((NVLinkConnection)element).isSystemAtomic() ? "Yes" : "No";
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Utilization %", "The utilization of NVLink bandwidth over total time for which NVLink was profiled, excluding idle time", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    double util = canvas.getUtilization((NVLinkConnection)element);
                    return util == -1.0 ? "n/a" : Long.toString((long)util);
                }
                return null;
            }
        });
        viewerColumn = this.getColumn(viewer, "Idle time %", "The idle time w.r.t. the total time for which NVLink was profiled. Idle time is the time when there was no data transfer over any physical NVLink of a logical NVLink in either direction", 131072);
        viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

            public String getText(Object element) {
                if (element instanceof NVLinkConnection) {
                    double idle = canvas.getIdleTime((NVLinkConnection)element);
                    return idle == -1.0 ? "n/a" : Long.toString((long)idle);
                }
                return null;
            }
        });
        if (!"win32".equals(Platform.getOS())) {
            viewerColumn = this.getColumn(viewer, "", "", 0);
            viewerColumn.setLabelProvider((CellLabelProvider)new LabelProvider(this){

                public String getText(Object element) {
                    return null;
                }
            });
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if (TopologyCanvas.PROP_LINK_SELECTION.equals(propertyName) || TopologyCanvas.PROP_LINKS_SELECTION.equals(propertyName)) {
            int j;
            int[] indices;
            StructuredSelection sel = null;
            NVLinkConnection data = null;
            if (model instanceof NVLinkConnection) {
                data = (NVLinkConnection)model;
                if (TopologyCanvas.PROP_LINKS_SELECTION.equals(propertyName)) {
                    ArrayList<NVLinkConnection> datas = new ArrayList<NVLinkConnection>();
                    IStructuredSelection oldSel = (IStructuredSelection)this.tableProperty.getSelection();
                    if (oldSel != null) {
                        Object[] objectArray = oldSel.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object item = objectArray[n2];
                            if (item instanceof NVLinkConnection) {
                                datas.add((NVLinkConnection)item);
                            }
                            ++n2;
                        }
                    }
                    datas.add(data);
                    sel = new StructuredSelection(datas);
                } else {
                    sel = new StructuredSelection((Object)data);
                }
            }
            this.tableProperty.removeSelectionChangedListener((ISelectionChangedListener)this.tableListener);
            this.tableProperty.setSelection(sel);
            this.tableProperty.addSelectionChangedListener((ISelectionChangedListener)this.tableListener);
            if (TopologyCanvas.PROP_LINKS_SELECTION.equals(propertyName)) {
                int[] selectedIndices = this.tableThroughput.getTable().getSelectionIndices();
                indices = new int[selectedIndices.length + 2];
                System.arraycopy(selectedIndices, 0, indices, 0, selectedIndices.length);
                j = selectedIndices.length;
            } else {
                indices = new int[2];
                j = 0;
            }
            indices[j + 1] = -1;
            indices[j] = -1;
            int count = this.tableThroughput.getTable().getItemCount();
            int i = 0;
            while (i < count) {
                Object obj = this.tableThroughput.getElementAt(i);
                if (obj instanceof Throughput && data != null) {
                    Throughput tp = (Throughput)obj;
                    long id = tp.nvlink.getActivity().getID();
                    if (id == data.getActivity().getID()) {
                        indices[j++] = i;
                    }
                }
                ++i;
            }
            this.tableThroughput.removeSelectionChangedListener((ISelectionChangedListener)this.tableListener);
            this.tableThroughput.getTable().setSelection(indices);
            this.tableThroughput.addSelectionChangedListener((ISelectionChangedListener)this.tableListener);
        }
    }

    private class LabelProvider
    extends ColumnLabelProvider {
        private LabelProvider() {
        }

        public Color getForeground(Object element) {
            String label = this.getText(element);
            if (label != null && this.getText(element).equals("n/a")) {
                return Display.getDefault().getSystemColor(33);
            }
            return super.getForeground(element);
        }

        public String getToolTipText(Object element) {
            String label = this.getText(element);
            if (label != null && this.getText(element).equals("n/a")) {
                return "Data not available (n/a)";
            }
            return super.getToolTipText(element);
        }
    }

    private final class TableListener
    implements ISelectionChangedListener {
        private TableListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)sel).getFirstElement();
                NVLinkConnection link = null;
                if (obj instanceof NVLinkConnection) {
                    link = (NVLinkConnection)obj;
                } else if (obj instanceof Throughput) {
                    link = ((Throughput)obj).nvlink;
                }
                NVLinkPropertyControl.this.canvas.selectLink(link);
            }
        }
    }

    class Throughput {
        String linkLabel;
        String sortLabel;
        long avg = 0L;
        long max = 0L;
        long min = 0L;
        NVLinkConnection nvlink;

        Throughput() {
        }
    }
}

